/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/module.h>

void
prhead_module()
{
	mprintf(SPTR" S SYMS GSYM EX ISIZE CSIZE "SPTR" "SPTR" "SPTR" NAME\n",
		"ADDR", "INIT", "MOD_CORE", "ARGS");
}

int module_offset_list = OFFSET(struct module, list);

addr_t
print_module(addr, full)
addr_t addr;
int full;
{
	struct module m;

	memread(addr, sizeof(m), &m, "module");
	mprintf(FPTR " ", addr);
	mprintf("%c ",	m.state == MODULE_STATE_LIVE? 'L':
			m.state == MODULE_STATE_COMING? 'C':
			m.state == MODULE_STATE_GOING? 'G': '?');
	mprintf("%4x %4x %2x ", m.num_syms, m.num_gpl_syms, m.num_exentries);
	mprintf("%5lx %5lx ", m.init_size, m.core_size);
	mprintf(FPTR " " FPTR " " FPTR " ", m.init, m.module_core, m.args);
	mprintstr(m.name, sizeof(m.name));
	mprintf("\n");
	return (addr_t)m.list.next;
}

void
getmsyms_alt(addr)
	addr_t addr;
{
	int i;
	struct module m;
	struct kernel_symbol msym;
	char buf[256];
	int len;

	memread(addr, sizeof(m), &m, "module");
#ifdef DEBUG
	mprintf("DEBUG: getmsyms(%lx %s)\n", addr, m.name);
#endif

	for (i = 0; i < m.num_syms; i++) {
		memread((addr_t)m.syms + sizeof(msym) * i, sizeof(msym), &msym, "module_symbol");
		if (msym.value == 0 || msym.name == 0)
			continue;
		memread((addr_t)msym.name, sizeof(buf), buf, "symbol name");
#ifdef DEBUG
		if (strchr(buf, '/') != 0)
			continue;
#endif
		len = strlen(buf);
		if (len > 10 && buf[len - 10] =='_' && buf[len - 9] == 'R')
			buf[len - 10] = 0;
#ifdef DEBUG
		mprintf(" %s=%lx\n", buf, msym.value);
#endif
		addsym(buf, msym.value, 0);
	}
}

addr_t
getmsyms(addr)
	addr_t addr;
{
	int i;
	struct module m;
	struct kernel_symbol msym;
	char buf[256];
	addr_t text = 0, data = 0, bss = 0;
	char path[256], *p;
	extern int strncmp();
	extern char *strstr(), *strchr(), *strcpy();

	memread(addr, sizeof(m), &m, "module");
	path[0] = 0;

	for (i = 0; i < m.num_syms; i++) {
		memread((addr_t)m.syms + sizeof(msym) * i, sizeof(msym), &msym, "module_symbol");
		if (msym.value == 0 || msym.name == 0)
			continue;
		memread((addr_t)msym.name, sizeof(buf), buf, "symbol name");
		if (strncmp(buf, "__insmod_", 9) != 0)
			continue;
#ifdef DEBUG
		mprintf("[%s]\n", buf + 9);
#endif
		if (strstr(buf, ".text")) {
			text = msym.value;
		} else if (strstr(buf, ".data")) {
			data = msym.value;
		} else if (strstr(buf, ".bss")) {
			bss = msym.value;
		} else if ((p = strchr(buf, '/'))) {
			strcpy(path, p);
			p = strstr(path, ".o_");
			if (p) p[2] = 0;
		}
	}
#ifdef DEBUG
	mprintf("%s: %x %x %x\n", path, text, data, bss);
#endif
	if (getmsyms_fromfile(path, text, data, bss)) {
		mprintf("Error: reading module information: %s\n", m.name);
		getmsyms_alt(addr);
	}
	return (addr_t)m.list.next;
}
