/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t ext2_inode();
const commandtable_t command_ext2_inode =
	{"ext2_inode", ext2_inode, "address", "print ext2_inode table"};

extern addr_t print_ext2_inode();

PRIVATE addr_t
ext2_inode()
{
	int c;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		THROW(usage);
	}

	if (argcnt == optind) {
		THROW(usage);
	}
	while (args[optind]) {
		print_ext2_inode(getvalue(args[optind]));
		optind++;
	}
	return 0;
}
