/*
 * Copyright (C) 2003 ASANO Masahiro
 */

#include <sys/stat.h>
#include <unistd.h>
#include "crash.h"

PRIVATE addr_t sighand_struct();
const commandtable_t command_sighand_struct =
	{"sighand_struct", sighand_struct, "address", "print sighand_struct table"};

extern addr_t print_sighand_struct();

PRIVATE addr_t
sighand_struct()
{
	addr_t addr = 0;
	int c;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (optind == argcnt) {
		THROW(usage);
	} else {
		while (args[optind]) {
			addr = print_sighand_struct(getvalue(args[optind]));
			optind++;
		}
	}
	return addr;
}
