/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"
#include "mpercpu.h"

PRIVATE addr_t timer_vec();
const commandtable_t command_timer_vec =
	{"timer_vec", timer_vec, "[-c cpu]", "print timer_vec table (tv1-tv5)"};
extern addr_t print_timer();

IMPORT_PER_CPU(tvec_bases);
addr_t jiffies_addr;

#ifdef CONFIG_SMP
addr_t __per_cpu_offset_addr;
#endif /*CONFIG_SMP*/

#if CONFIG_NR_CPUS
unsigned long __per_cpu_offset[CONFIG_NR_CPUS];
#else
unsigned long __per_cpu_offset[1];
#endif /*CONFIG_NR_CPUS*/

PRIVATE addr_t
timer_vec()
{
	int c;
	unsigned long jiffies;
	int cpu = 0;

	while ((c = getopt(argcnt, args, "c:")) != EOF) {
		switch (c) {
		case 'c':
			cpu = (int)strtol(optarg, NULL, 0);
			if (cpu < 0)
				THROW(usage);
			if (cpu >= LENGTHOF(__per_cpu_offset))
				THROW(usage);
			break;
		default:
			THROW(usage);
		}
	}

	if (optind != argcnt)
		THROW(usage);

#ifdef CONFIG_SMP
	GETADDR(__per_cpu_offset)
	memread(__per_cpu_offset_addr, sizeof(__per_cpu_offset), __per_cpu_offset, "__per_cpu_offset");
#endif /*CONFIG_SMP*/

	GETADDR(per_cpu__tvec_bases);
	GETADDR(jiffies);
	memread(jiffies_addr, sizeof(jiffies), &jiffies, "jiffies");
	mprintf("jiffies = %lx\n", jiffies);

	return print_timer(jiffies, cpu);
}
