/*
 * Copyright (C) 2003 ASANO Masahiro
 */

#include <sys/stat.h>
#include <unistd.h>
#include "crash.h"

#include <linux/utsname.h>

PRIVATE addr_t utsname();
const commandtable_t command_stat =
	{"stat", utsname, "[address]", "print utsname table"};
extern addr_t print_user_struct();

addr_t system_utsname_addr;
extern addr_t jiffies_addr;

addr_t
print_utsname(addr)
	addr_t addr;
{
	struct new_utsname uts;

	memread(addr, sizeof(uts), &uts, "system_utsname");

	mprintf("sysname     ");
	mprintstr(uts.sysname, sizeof(uts.sysname));
	mprintf("\n");

	mprintf("nodename    ");
	mprintstr(uts.nodename, sizeof(uts.nodename));
	mprintf("\n");

	mprintf("release     ");
	mprintstr(uts.release, sizeof(uts.release));
	mprintf("\n");

	mprintf("version     ");
	mprintstr(uts.version, sizeof(uts.version));
	mprintf("\n");

	mprintf("machine     ");
	mprintstr(uts.machine, sizeof(uts.machine));
	mprintf("\n");

	mprintf("domainname  ");
	mprintstr(uts.domainname, sizeof(uts.domainname));
	mprintf("\n");

	return 0;
}

PRIVATE addr_t
utsname()
{
	int c;
	unsigned long jiffies;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (optind != argcnt)
		THROW(usage);

	GETADDR(system_utsname);
	print_utsname(system_utsname_addr);

	GETADDR(jiffies);
	memread(jiffies_addr, sizeof(jiffies), &jiffies, "jiffies");
	mprintf("jiffies     %lx  ", jiffies);
	mprint_jif(jiffies);
	mprintf("\n");

	return jiffies;
}
