/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include <sys/types.h>
#include <unistd.h>
#include "crash.h"
/*#include <linux/tasks.h>*/

PRIVATE addr_t task(), fs_struct(), mm_struct();
const commandtable_t
	command_task_struct =
	{"task_struct", task, "[-f] [address]", "print task_struct table"},
	command_fs_struct =
	{"fs_struct", fs_struct, "address", "print fs_struct"},
	command_mm_struct =
	{"mm_struct", mm_struct, "[-v] address", "print mm_struct\n  -v  show vm_area_struct"};

extern addr_t print_task();
extern addr_t print_fs_struct();
extern addr_t print_mm_struct();

addr_t init_task_addr;

PRIVATE addr_t
task()
{
	int i, c;
	int full = 0;
	addr_t addr = 0;
	extern void prhead_task();

	while ((c = getopt(argcnt, args, "f")) != EOF) {
		switch (c) {
		case 'f':
			full = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (!full) prhead_task();
	if (argcnt > optind) {
		for (i = optind; i < argcnt; i++) {
			addr = getaddr(args[i]);
			if (full) prhead_task();
			addr = print_task(addr, full);
		}
	} else {
		GETADDR(init_task);
		addr = init_task_addr;
		do {
			if (full) prhead_task();
			addr = print_task(addr, full);
		} while (addr != init_task_addr);
	}
	return addr;
}

PRIVATE addr_t
fs_struct()
{
	int c;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		THROW(usage);
	}

	if (argcnt == optind) {
		THROW(usage);
	}
	while (args[optind]) {
		(void)print_fs_struct(getaddr(args[optind]));
		optind++;
	}
	return 0;
}

PRIVATE addr_t
mm_struct()
{
	int c;
	int vflag = 0;
	addr_t addr = 0;

	while ((c = getopt(argcnt, args, "v")) != EOF) {
		switch (c) {
		case 'v':
			vflag = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (argcnt == optind) {
		THROW(usage);
	}
	while (args[optind]) {
		addr = print_mm_struct(getaddr(args[optind]), vflag);
		optind++;
	}
	return addr;
}
