/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t xfs_inode();
const commandtable_t command_xfs_inode =
	{"xfs_inode", xfs_inode, "address", "[XFS] print xfs_inode_t table"};

extern addr_t print_xfs_inode();

PRIVATE addr_t
xfs_inode()
{
	int i, c;
	addr_t addr = 0;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (argcnt > optind) {
		for (i = optind; i < argcnt; i++) {
			addr = getaddr(args[i]);
			addr = print_xfs_inode(addr, 1, 0);
		}
	} else {
		THROW(usage);
	}
	return addr;
}
