/*
 * Decompiled with CFR 0.152.
 */
package org.jent.checksmtp.daemon;

import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.jent.checksmtp.daemon.ApplicationProperties;

public class LDAPSearch {
    static /* synthetic */ Class class$org$jent$checksmtp$daemon$LDAPSearch;
    private static InitialDirContext ctx;
    private static String lastProviderUrl;

    static /* synthetic */ Class class$(String a) {
        try {
            Class<?> clazz = Class.forName(a);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private LDAPSearch() {
    }

    private static void init() {
        if (!ApplicationProperties.getLdap()) {
            lastProviderUrl = ApplicationProperties.getLdapProviderURL();
            Properties env = new Properties();
            env.setProperty("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", lastProviderUrl);
            try {
                ctx = new InitialDirContext(env);
            }
            catch (NamingException e) {
                System.err.println("LDAPSearch init error.");
                e.printStackTrace();
            }
        }
    }

    public static String search(String mail) {
        String ans = "";
        if (!ApplicationProperties.getLdap()) {
            return ans;
        }
        Class clazz = class$org$jent$checksmtp$daemon$LDAPSearch == null ? (class$org$jent$checksmtp$daemon$LDAPSearch = LDAPSearch.class$("org.jent.checksmtp.daemon.LDAPSearch")) : class$org$jent$checksmtp$daemon$LDAPSearch;
        synchronized (clazz) {
            try {
                if (ctx == null || !lastProviderUrl.equals(ApplicationProperties.getLdapProviderURL())) {
                    LDAPSearch.init();
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
        Pattern pattern = Pattern.compile("[ \t]+");
        String[] attrNames = pattern.split(ApplicationProperties.getLdapAttributes());
        System.err.println("LDAP Serarch= " + mail + " " + attrNames[0]);
        SearchControls ctrl = new SearchControls();
        ctrl.setSearchScope(2);
        ctrl.setTimeLimit(5000);
        ctrl.setCountLimit(3L);
        ctrl.setReturningAttributes(attrNames);
        try {
            NamingEnumeration<SearchResult> namingEnumeration = ctx.search(ApplicationProperties.getLdapRoot(), "(mail=" + mail + ")", ctrl);
            while (namingEnumeration.hasMore()) {
                SearchResult sr = namingEnumeration.next();
                for (int i = 0; i < attrNames.length; ++i) {
                    Attribute attr = sr.getAttributes().get(attrNames[i]);
                    String str = attr == null ? "" : (String)attr.get();
                    if (str == null) {
                        str = "";
                    }
                    if (ApplicationProperties.getLdapIsSjis()) {
                        str = new String(str.getBytes("ISO-8859-1"), "UTF-8");
                    }
                    if (i != 0) {
                        ans = String.valueOf(ans) + " ";
                    }
                    ans = String.valueOf(ans) + str;
                }
                System.err.println("ANS=" + ans);
            }
            namingEnumeration.close();
        }
        catch (NamingException e) {
            System.err.println("LDAP Search Error.");
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException ueEx) {
            UnsupportedEncodingException e = ueEx;
            System.err.println("LDAP SJIS Error.");
            e.printStackTrace();
        }
        return ans;
    }
}

