/*
 * Decompiled with CFR 0.152.
 */
package org.jent.checksmtp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.jent.checksmtp.ApplicationProperties;
import org.jent.checksmtp.LDAPSearch;
import org.jent.checksmtp.MessageDialogUI;
import org.jent.checksmtp.ResultNotify;
import org.jent.checksmtp.SmtpBufferedWriter;
import org.jent.checksmtp.ToListUI;

public class Processer
implements Runnable,
ResultNotify {
    private Socket client;
    private final int RESULT_UNKNOWN = 0;
    private final int RESULT_OK = 1;
    private final int RESULT_NG = 2;
    private int result = 0;
    private final int R354StartInput = 354;
    private final int R221ServiceClosing = 221;
    private final int R451RequestedActionAbort = 451;
    private final int R502CommandNotImplemented = 502;
    private final String COMMAND_RCPT_TO = "RCPT TO:";
    private final String COMMAND_DATA = "DATA";
    private final String COMMAND_RESET = "RSET";
    private final String COMMAND_TURN = "TURN";

    public Processer(Socket client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Socket server = null;
        try {
            String servername = ApplicationProperties.getSmtpServerHost();
            int serverport = ApplicationProperties.getSmtpServerPort();
            server = new Socket(servername, serverport);
            InputStream serverInput = server.getInputStream();
            OutputStream serverOutput = server.getOutputStream();
            InputStream clientInput = this.client.getInputStream();
            OutputStream clientOutput = this.client.getOutputStream();
            BufferedReader serverReader = new BufferedReader(new InputStreamReader(server.getInputStream()));
            PrintWriter serverWriter = new PrintWriter((Writer)new SmtpBufferedWriter(new OutputStreamWriter(server.getOutputStream(), "ISO-8859-1")), true);
            BufferedReader clientReader = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
            PrintWriter clientWriter = new PrintWriter((Writer)new SmtpBufferedWriter(new OutputStreamWriter(this.client.getOutputStream(), "ISO-8859-1")), true);
            this.smtpStart(serverReader, clientWriter, clientReader, serverWriter);
            server.close();
            server = null;
            this.client.close();
            this.client = null;
        }
        catch (IOException e) {
            String errorMessage = ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("Processer.error.Execption_occurred_at_starting_SMTP_thread.");
            System.err.println(errorMessage);
            new MessageDialogUI(errorMessage, e, 0);
        }
        catch (RuntimeException runEx) {
            new MessageDialogUI(ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("Processer.error.Runtime_Exception_occurred_in_SMTP_parse"), runEx, 0);
        }
        finally {
            if (server != null) {
                try {
                    server.close();
                }
                catch (IOException ioEx) {}
            }
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (IOException ioEx) {}
            }
            LDAPSearch.close();
        }
    }

    private int getCode(String s) {
        return Integer.parseInt(s.substring(0, 3));
    }

    private boolean isContinue(String s) {
        return '-' == s.charAt(3);
    }

    private boolean isRcptTo(String s) {
        return s.startsWith("RCPT TO:");
    }

    private boolean isData(String s) {
        return s.startsWith("DATA");
    }

    private boolean isTurn(String s) {
        return s.startsWith("TURN");
    }

    public void sayOK() {
        this.result = 1;
        this.notifyResult();
    }

    public void sayNG() {
        this.result = 2;
        this.notifyResult();
    }

    private synchronized void notifyResult() {
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void smtpStart(BufferedReader serverReader, PrintWriter clientWriter, BufferedReader clientReader, PrintWriter serverWriter) {
        try {
            ArrayList<String> toList = new ArrayList<String>();
            while (true) {
                String line = serverReader.readLine();
                clientWriter.println(line);
                System.out.println(line);
                if (this.isContinue(line)) continue;
                if (221 != this.getCode(line)) {
                    if (354 == this.getCode(line)) {
                        System.out.println("Send mail data.");
                        do {
                            line = clientReader.readLine();
                            serverWriter.println(line);
                        } while (!line.equals("."));
                        continue;
                    }
                    while (true) {
                        if ((line = clientReader.readLine()) == null) {
                            System.err.println("Client disconnected.");
                            break;
                        }
                        if (this.isRcptTo(line)) {
                            toList.add(this.formatToAddress(line));
                            break;
                        }
                        if (this.isTurn(line)) {
                            System.err.println("'TURN' is unsupported command.");
                            clientWriter.println(502);
                            continue;
                        }
                        if (!this.isData(line)) break;
                        ListIterator iterater = toList.listIterator();
                        while (iterater.hasNext()) {
                            System.out.println("ADDRESS CHECK:" + iterater.next());
                        }
                        new ToListUI(this, toList);
                        while (this.result == 0) {
                            try {
                                Processer processer = this;
                                synchronized (processer) {
                                    this.wait();
                                }
                            }
                            catch (InterruptedException e) {
                                System.err.println("Confirm dialog wait interrupted");
                                e.printStackTrace();
                            }
                        }
                        if (this.result == 1) break;
                        System.out.println("CANCEL sending mail.");
                        serverWriter.println("RSET");
                        line = serverReader.readLine();
                        System.out.println("RSET:ANSER is " + line);
                        clientWriter.println(451);
                    }
                    if (line != null) {
                        serverWriter.println(line);
                        System.out.println(line);
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException e) {
            String errorMessage = ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("Processer.error.Error_occurred_in_SMTP_parse.");
            System.err.println(errorMessage);
            new MessageDialogUI(errorMessage, e, 0);
        }
        catch (RuntimeException runEx) {
            new MessageDialogUI(ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("Processer.error.Runtime_Exception_occurred_in_SMTP_parse"), runEx, 0);
        }
        System.out.println("End of Session.");
    }

    private String formatToAddress(String line) {
        int i;
        System.out.println("FIND To: " + line);
        String str = line.substring("RCPT TO:".length() + 1);
        Pattern pattern = Pattern.compile("[< >]+");
        String[] address = pattern.split(str);
        for (i = 0; i < address.length && address[i].equals(""); ++i) {
        }
        str = address[i] + " " + LDAPSearch.search(address[i]);
        return str;
    }
}

