/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.text.MessageFormat;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIModificationVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIType;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;

public class JDIFieldVariable
extends JDIModificationVariable
implements IJavaFieldVariable {
    private Field fField;
    private ObjectReference fObject;
    private ReferenceType fType;

    public JDIFieldVariable(JDIDebugTarget target, Field field, ObjectReference objectRef) {
        super(target);
        this.fField = field;
        this.fObject = objectRef;
        this.fType = (ReferenceType)objectRef.type();
    }

    public JDIFieldVariable(JDIDebugTarget target, Field field, ReferenceType refType) {
        super(target);
        this.fField = field;
        this.fType = refType;
    }

    protected Value retrieveValue() {
        if (this.getField().isStatic()) {
            return this.getField().declaringType().getValue(this.getField());
        }
        return this.getObjectReference().getValue(this.getField());
    }

    public IJavaType getDeclaringType() {
        return JDIType.createType((JDIDebugTarget)this.getDebugTarget(), this.fField.declaringType());
    }

    public String getName() throws DebugException {
        try {
            return this.getField().name();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIFieldVariable.exception_retrieving_field_name"), e.toString()), e);
            return null;
        }
    }

    protected void setValue(Value value) throws DebugException {
        try {
            if (this.isStatic()) {
                ((ClassType)this.getField().declaringType()).setValue(this.getField(), value);
            } else {
                this.getObjectReference().setValue(this.getField(), value);
            }
        }
        catch (ClassNotLoadedException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIFieldVariable.exception_modifying_value_1"), e.toString()), e);
        }
        catch (InvalidTypeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIFieldVariable.exception_modifying_value_2"), e.toString()), e);
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIFieldVariable.exception_modifying_value_3"), e.toString()), e);
        }
    }

    public boolean isVolatile() {
        return this.getField().isVolatile();
    }

    public boolean isTransient() {
        return this.getField().isTransient();
    }

    public boolean isSynthetic() {
        return this.getField().isSynthetic();
    }

    public boolean isPublic() {
        return this.getField().isPublic();
    }

    public boolean isPrivate() {
        return this.getField().isPrivate();
    }

    public boolean isProtected() {
        return this.getField().isProtected();
    }

    public boolean isPackagePrivate() {
        return this.getField().isPackagePrivate();
    }

    public boolean isStatic() {
        return this.getField().isStatic();
    }

    public boolean isFinal() {
        return this.getField().isFinal();
    }

    public String getReferenceTypeName() {
        return this.getField().typeName();
    }

    public String getSignature() throws DebugException {
        try {
            return this.getField().signature();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIFieldVariable.exception_retrieving_field_signature"), e.toString()), e);
            return null;
        }
    }

    public Field getField() {
        return this.fField;
    }

    public ObjectReference getObjectReference() {
        return this.fObject;
    }

    public ReferenceType getReferenceType() {
        return this.fType;
    }

    public boolean supportsValueModification() {
        if (this.getField().declaringType() instanceof InterfaceType) {
            return false;
        }
        return super.supportsValueModification();
    }

    public String toString() {
        return this.getField().toString();
    }

    public void setValue(IValue v) throws DebugException {
        if (this.verifyValue(v)) {
            this.setValue(((JDIValue)v).getUnderlyingValue());
        }
    }

    protected Type getUnderlyingType() throws DebugException {
        try {
            return this.getField().type();
        }
        catch (ClassNotLoadedException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIFieldVariable.exception_while_retrieving_type_of_field"), e.toString()), e);
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIFieldVariable.exception_while_retrieving_type_of_field"), e.toString()), e);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof JDIFieldVariable) {
            JDIFieldVariable f = (JDIFieldVariable)o;
            if (this.fObject != null) {
                return this.fObject.equals(f.fObject) && f.fField.equals(this.fField);
            }
            return f.fField.equals(this.fField);
        }
        return false;
    }

    public int hashCode() {
        if (this.fObject != null) {
            return this.fField.hashCode() + this.fObject.hashCode();
        }
        return this.fField.hashCode();
    }

    public IJavaObject getReceiver() {
        ObjectReference objectReference = this.getObjectReference();
        if (objectReference == null) {
            return null;
        }
        return (IJavaObject)((Object)JDIValue.createValue(this.getJavaDebugTarget(), objectReference));
    }

    public IJavaReferenceType getReceivingType() {
        return (IJavaReferenceType)((Object)JDIType.createType(this.getJavaDebugTarget(), this.getReferenceType()));
    }
}

