/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core.sourcelookup;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;

public abstract class AbstractSourceLookupParticipant
implements ISourceLookupParticipant {
    private ISourceLookupDirector fDirector;
    protected static final Object[] EMPTY = new Object[0];

    public void init(ISourceLookupDirector director) {
        this.fDirector = director;
    }

    public void dispose() {
        this.fDirector = null;
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        String name;
        ArrayList<Object> results = null;
        if (this.isFindDuplicates()) {
            results = new ArrayList<Object>();
        }
        if ((name = this.getSourceName(object)) != null) {
            ISourceContainer[] containers = this.getSourceContainers();
            int i = 0;
            while (i < containers.length) {
                Object[] objects;
                ISourceContainer container = this.getDelegateContainer(containers[i]);
                if (container != null && (objects = container.findSourceElements(name)).length > 0) {
                    if (this.isFindDuplicates()) {
                        int j = 0;
                        while (j < objects.length) {
                            results.add(objects[j]);
                            ++j;
                        }
                    } else {
                        if (objects.length == 1) {
                            return objects;
                        }
                        return new Object[]{objects[0]};
                    }
                }
                ++i;
            }
        }
        if (results == null) {
            return EMPTY;
        }
        return results.toArray();
    }

    protected ISourceContainer getDelegateContainer(ISourceContainer container) {
        return container;
    }

    protected ISourceLookupDirector getDirector() {
        return this.fDirector;
    }

    protected boolean isFindDuplicates() {
        return this.getDirector().isFindDuplicates();
    }

    protected ISourceContainer[] getSourceContainers() {
        return this.getDirector().getSourceContainers();
    }

    public void sourceContainersChanged(ISourceLookupDirector director) {
    }
}

