/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.pde.internal.ui.editor.feature.SynchronizeVersionsWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SynchronizeVersionsAction
extends Action {
    public static final String LABEL = "Actions.synchronizeVersions.label";
    public static final String DIALOG_TITLE = "FeatureEditor.modelsInUse.title";
    public static final String DIALOG_MESSAGE = "FeatureEditor.modelsInUse.message";
    private FeatureEditor activeEditor;
    static /* synthetic */ Class class$0;

    public SynchronizeVersionsAction() {
        this.setText(PDEPlugin.getResourceString(LABEL));
    }

    private void ensureContentSaved() {
        if (this.activeEditor.isDirty()) {
            try {
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        SynchronizeVersionsAction.this.activeEditor.doSave(monitor);
                    }
                };
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PDEPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)PDEPlugin.getWorkspace().getRoot());
            }
            catch (InvocationTargetException e) {
                PDEPlugin.logException(e);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean ensureEditorsClosed() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.pde.core.plugin.IPluginModelBase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> modelClass = clazz;
        boolean result = PDECore.getDefault().getWorkspaceModelManager().getAllEditableModelsUnused(modelClass);
        if (!result) {
            MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString(DIALOG_TITLE), (String)PDEPlugin.getResourceString(DIALOG_MESSAGE));
        }
        return result;
    }

    public void run() {
        this.ensureContentSaved();
        if (!this.ensureEditorsClosed()) {
            return;
        }
        SynchronizeVersionsWizard wizard = new SynchronizeVersionsWizard(this.activeEditor);
        WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        dialog.open();
    }

    public void setActiveEditor(FeatureEditor editor) {
        this.activeEditor = editor;
        IModel model = (IModel)editor.getAggregateModel();
        this.setEnabled(model.isEditable());
    }
}

