/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin.rows;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.plugin.JavaAttributeValue;
import org.eclipse.pde.internal.ui.editor.plugin.JavaAttributeWizard;
import org.eclipse.pde.internal.ui.editor.plugin.rows.ReferenceAttributeRow;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.ide.IDE;

public class ClassAttributeRow
extends ReferenceAttributeRow {
    public ClassAttributeRow(IContextPart part, ISchemaAttribute att) {
        super(part, att);
    }

    protected boolean isReferenceModel() {
        return !this.part.getPage().getModel().isEditable();
    }

    protected void openReference() {
        String name = this.text.getText();
        name = this.trimNonAlphaChars(name);
        String path = String.valueOf(name.replace('.', '/')) + ".java";
        IProject project = this.part.getPage().getPDEEditor().getCommonProject();
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IJavaElement result = javaProject.findElement((IPath)new Path(path));
                if (result != null) {
                    JavaUI.openInEditor((IJavaElement)result);
                } else {
                    JavaAttributeValue value = this.createJavaAttributeValue();
                    JavaAttributeWizard wizard = new JavaAttributeWizard(value);
                    WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                    dialog.create();
                    SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
                    int dResult = dialog.open();
                    if (dResult == 0) {
                        path = String.valueOf(wizard.getClassName().replace('.', '/')) + ".java";
                        this.text.setText(wizard.getClassNameWithArgs());
                        result = javaProject.findElement((IPath)new Path(path));
                        if (result != null) {
                            JavaUI.openInEditor((IJavaElement)result);
                        }
                    }
                }
            } else {
                IResource resource = project.findMember((IPath)new Path(path));
                if (resource != null && resource instanceof IFile) {
                    IWorkbenchPage page = PDEPlugin.getActivePage();
                    IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)resource), (boolean)true);
                } else {
                    JavaAttributeValue value = this.createJavaAttributeValue();
                    JavaAttributeWizard wizard = new JavaAttributeWizard(value);
                    WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                    dialog.create();
                    SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
                    int dResult = dialog.open();
                    if (dResult == 0) {
                        String newValue = wizard.getClassName();
                        path = String.valueOf(newValue.replace('.', '/')) + ".java";
                        this.text.setText(newValue);
                        resource = project.findMember((IPath)new Path(path));
                        if (resource != null && resource instanceof IFile) {
                            IWorkbenchPage page = PDEPlugin.getActivePage();
                            IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)resource), (boolean)true);
                        }
                    }
                }
            }
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
        catch (JavaModelException javaModelException) {
            Display.getCurrent().beep();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    protected void browse() {
        BusyIndicator.showWhile((Display)this.text.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ClassAttributeRow.this.doOpenSelectionDialog();
            }
        });
    }

    private JavaAttributeValue createJavaAttributeValue() {
        IProject project = this.part.getPage().getPDEEditor().getCommonProject();
        IPluginModelBase model = (IPluginModelBase)this.part.getPage().getModel();
        String value = this.text.getText();
        return new JavaAttributeValue(project, model, this.getAttribute(), value);
    }

    private void doOpenSelectionDialog() {
        try {
            IProject project;
            Shell shell = PDEPlugin.getActiveWorkbenchShell();
            IResource resource = this.getPluginBase().getModel().getUnderlyingResource();
            IProject iProject = project = resource == null ? null : resource.getProject();
            if (project != null) {
                SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)2, (boolean)false, (String)"");
                dialog.setTitle(PDEPlugin.getResourceString("ClassAttributeRow.dialogTitle"));
                if (dialog.open() == 0) {
                    IType type = (IType)dialog.getResult()[0];
                    this.text.setText(type.getFullyQualifiedName());
                }
            }
        }
        catch (CoreException coreException) {}
    }

    private IPluginBase getPluginBase() {
        IBaseModel model = this.part.getPage().getPDEEditor().getAggregateModel();
        return ((IPluginModelBase)model).getPluginBase();
    }

    private String trimNonAlphaChars(String value) {
        value = value.trim();
        while (value.length() > 0 && !Character.isLetter(value.charAt(0))) {
            value = value.substring(1, value.length());
        }
        int loc = value.indexOf(":");
        if (loc != -1 && loc > 0) {
            value = value.substring(0, loc);
        } else if (loc == 0) {
            value = "";
        }
        return value;
    }
}

