/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import java.util.Vector;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.pde.internal.core.ischema.ISchemaRepeatable;
import org.eclipse.pde.internal.core.schema.RepeatableSchemaObject;
import org.eclipse.pde.internal.core.schema.SchemaElementReference;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.schema.SchemaObjectPropertySource;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class GrammarPropertySource
extends SchemaObjectPropertySource {
    public static final String P_MIN_OCCURS = "minOccurs";
    public static final String P_MAX_OCCURS = "maxOccurs";
    protected Vector descriptors;

    protected String isMinOccursValid(int ivalue) {
        if (ivalue < 0) {
            return PDEPlugin.getResourceString("GrammarPropertySource.minOccursValue");
        }
        return null;
    }

    protected String isMaxOccursValid(int ivalue) {
        if (ivalue < 0) {
            return PDEPlugin.getResourceString("GrammarPropertySource.maxOccursValue");
        }
        return null;
    }

    public GrammarPropertySource(ISchemaRepeatable obj) {
        super(obj);
    }

    public Object getEditableValue() {
        return null;
    }

    protected String getMaxOccurs(ISchemaRepeatable obj) {
        if (obj.getMaxOccurs() == Integer.MAX_VALUE) {
            return "unbounded";
        }
        return Integer.toString(obj.getMaxOccurs());
    }

    protected String getMinOccurs(ISchemaRepeatable obj) {
        return Integer.toString(obj.getMinOccurs());
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = this.getPropertyDescriptorsVector();
        }
        return this.toDescriptorArray(this.descriptors);
    }

    protected Vector getPropertyDescriptorsVector() {
        Vector<PropertyDescriptor> result = new Vector<PropertyDescriptor>();
        PropertyDescriptor desc = this.createTextPropertyDescriptor(P_MIN_OCCURS, P_MIN_OCCURS);
        desc.setValidator((ICellEditorValidator)new MinValidator());
        result.addElement(desc);
        desc = this.createTextPropertyDescriptor(P_MAX_OCCURS, P_MAX_OCCURS);
        desc.setValidator((ICellEditorValidator)new MaxValidator());
        result.addElement(desc);
        return result;
    }

    public Object getPropertyValue(Object name) {
        ISchemaRepeatable obj = (ISchemaRepeatable)this.getSourceObject();
        if (name.equals(P_MIN_OCCURS)) {
            return this.getMinOccurs(obj);
        }
        if (name.equals(P_MAX_OCCURS)) {
            return this.getMaxOccurs(obj);
        }
        return null;
    }

    public boolean isPropertySet(Object property) {
        return false;
    }

    public int parseValue(Object value) {
        String svalue = (String)value;
        if (svalue.equals("unbounded")) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.parseInt(svalue.toString());
        }
        catch (NumberFormatException e) {
            PDEPlugin.logException(e);
            return 1;
        }
    }

    public void resetPropertyValue(Object property) {
    }

    public void setPropertyValue(Object name, Object value) {
        ISchemaRepeatable obj = (ISchemaRepeatable)this.getSourceObject();
        if (name.equals(P_MIN_OCCURS)) {
            int ivalue = this.parseValue(value);
            if (obj instanceof RepeatableSchemaObject) {
                ((RepeatableSchemaObject)obj).setMinOccurs(ivalue);
            } else if (obj instanceof SchemaElementReference) {
                ((SchemaElementReference)obj).setMinOccurs(ivalue);
            }
        } else if (name.equals(P_MAX_OCCURS)) {
            int ivalue = this.parseValue(value);
            if (obj instanceof RepeatableSchemaObject) {
                ((RepeatableSchemaObject)obj).setMaxOccurs(ivalue);
            } else if (obj instanceof SchemaElementReference) {
                ((SchemaElementReference)obj).setMaxOccurs(ivalue);
            }
        }
    }

    class MinValidator
    implements ICellEditorValidator {
        MinValidator() {
        }

        public String isValid(Object value) {
            String svalue = value.toString();
            try {
                int ivalue = Integer.parseInt(svalue);
                return GrammarPropertySource.this.isMinOccursValid(ivalue);
            }
            catch (NumberFormatException numberFormatException) {
                return PDEPlugin.getResourceString("GrammarPropertySource.minOccursFormat");
            }
        }
    }

    class MaxValidator
    implements ICellEditorValidator {
        MaxValidator() {
        }

        public String isValid(Object value) {
            String svalue = value.toString();
            if (svalue.equals("unbounded")) {
                return GrammarPropertySource.this.isMaxOccursValid(Integer.MAX_VALUE);
            }
            try {
                int ivalue = Integer.parseInt(svalue);
                return GrammarPropertySource.this.isMaxOccursValid(ivalue);
            }
            catch (NumberFormatException numberFormatException) {
                return PDEPlugin.getResourceString("GrammarPropertySource.maxOccursFormat");
            }
        }
    }
}

