/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.plugin.AbstractFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationPage;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class ContentPage
extends WizardPage {
    protected boolean fIsFragment;
    protected boolean isInitialized = false;
    protected Text fIdText;
    protected Text fVersionText;
    protected Text fNameText;
    protected Text fProviderText;
    protected Text fPluginIdText;
    protected Text fPluginVersion;
    protected Combo fMatchCombo;
    protected Button fLegacyButton;
    protected AbstractFieldData fData;
    protected IProjectProvider fProjectProvider;
    protected Label fLibraryLabel;
    protected Text fLibraryText;
    protected static final int PROPERTIES_GROUP = 1;
    protected static final int P_CLASS_GROUP = 2;
    protected int fChangedGroups = 0;
    protected ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ContentPage.this.validatePage();
        }
    };
    protected ModifyListener propertiesListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (ContentPage.this.isInitialized) {
                ContentPage.this.fChangedGroups |= 1;
            }
            ContentPage.this.validatePage();
        }
    };
    protected static final String KEY_MATCH_PERFECT = "ManifestEditor.MatchSection.perfect";
    protected static final String KEY_MATCH_EQUIVALENT = "ManifestEditor.MatchSection.equivalent";
    protected static final String KEY_MATCH_COMPATIBLE = "ManifestEditor.MatchSection.compatible";
    protected static final String KEY_MATCH_GREATER = "ManifestEditor.MatchSection.greater";
    protected Text fClassText;
    protected Button fGenerateClass;
    protected Button fUIPlugin;
    protected Label fClassLabel;
    protected NewProjectCreationPage creationPage;

    public ContentPage(String pageName, IProjectProvider provider, NewProjectCreationPage page, AbstractFieldData data, boolean isFragment) {
        super(pageName);
        this.creationPage = page;
        this.fIsFragment = isFragment;
        this.fProjectProvider = provider;
        this.fData = data;
        if (isFragment) {
            this.setTitle(PDEPlugin.getResourceString("ContentPage.ftitle"));
            this.setDescription(PDEPlugin.getResourceString("ContentPage.fdesc"));
        } else {
            this.setTitle(PDEPlugin.getResourceString("ContentPage.title"));
            this.setDescription(PDEPlugin.getResourceString("ContentPage.desc"));
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        this.createPropertyControls(container);
        this.fLegacyButton = new Button(container, 32);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.fLegacyButton.setLayoutData((Object)gd);
        this.fLegacyButton.setText(PDEPlugin.getResourceString("ContentPage.legacy"));
        this.fLegacyButton.setSelection(!PDECore.getDefault().getModelManager().isOSGiRuntime());
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    protected abstract void createPropertyControls(Composite var1);

    protected Text createText(Composite parent, ModifyListener listener) {
        Text text = new Text(parent, 2052);
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(listener);
        return text;
    }

    protected void validatePage() {
        this.setMessage(null);
        String errorMessage = this.validateId();
        if (errorMessage == null) {
            if (this.fVersionText.getText().trim().length() == 0) {
                errorMessage = PDEPlugin.getResourceString("ContentPage.noversion");
            } else if (!this.isVersionValid(this.fVersionText.getText().trim())) {
                errorMessage = PDEPlugin.getResourceString("ContentPage.badversion");
            } else if (this.fNameText.getText().trim().length() == 0) {
                errorMessage = PDEPlugin.getResourceString("ContentPage.noname");
            }
        }
        if (errorMessage == null) {
            if (this.creationPage.isJavaProject() && this.fLibraryText.getText().trim().length() == 0) {
                errorMessage = PDEPlugin.getResourceString("ProjectStructurePage.noLibrary");
            }
            if (this.fIsFragment) {
                String pluginID = this.fPluginIdText.getText().trim();
                if (pluginID.length() == 0) {
                    errorMessage = PDEPlugin.getResourceString("ContentPage.nopid");
                } else if (PDECore.getDefault().getModelManager().findEntry(pluginID) == null) {
                    errorMessage = PDEPlugin.getResourceString("ContentPage.pluginNotFound");
                } else if (this.fPluginVersion.getText().trim().length() == 0) {
                    errorMessage = PDEPlugin.getResourceString("ContentPage.nopversion");
                } else if (!this.isVersionValid(this.fPluginVersion.getText().trim())) {
                    errorMessage = PDEPlugin.getResourceString("ContentPage.badpversion");
                }
            } else if (this.fGenerateClass.isEnabled() && this.fGenerateClass.getSelection()) {
                IStatus status = JavaConventions.validateJavaTypeName((String)this.fClassText.getText().trim());
                if (status.getSeverity() == 4) {
                    errorMessage = status.getMessage();
                } else if (status.getSeverity() == 2) {
                    this.setMessage(status.getMessage(), 2);
                }
            }
        }
        if (this.isInitialized) {
            this.setErrorMessage(errorMessage);
        } else {
            this.setErrorMessage(null);
        }
        this.setPageComplete(errorMessage == null);
    }

    private String validateId() {
        String id = this.fIdText.getText().trim();
        if (id.length() == 0) {
            return PDEPlugin.getResourceString("ContentPage.noid");
        }
        StringTokenizer stok = new StringTokenizer(id, ".");
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            int i = 0;
            while (i < token.length()) {
                if (!Character.isLetterOrDigit(token.charAt(i)) && '_' != token.charAt(i)) {
                    return PDEPlugin.getResourceString("ContentPage.invalidId");
                }
                ++i;
            }
        }
        return null;
    }

    private boolean isVersionValid(String version) {
        try {
            new PluginVersionIdentifier(version);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.creationPage.hasBundleStructure()) {
                this.fLegacyButton.setEnabled(false);
            } else {
                this.fLegacyButton.setEnabled(true);
            }
            this.fLibraryLabel.setEnabled(this.creationPage.isJavaProject());
            this.fLibraryText.setEnabled(this.creationPage.isJavaProject());
            if (!this.fIsFragment) {
                if (!this.creationPage.isJavaProject()) {
                    this.fGenerateClass.setEnabled(false);
                    this.fClassLabel.setEnabled(false);
                    this.fClassText.setEnabled(false);
                    this.fUIPlugin.setEnabled(false);
                } else {
                    this.fGenerateClass.setEnabled(true);
                    if (this.fGenerateClass.getSelection()) {
                        this.fClassLabel.setEnabled(true);
                        this.fClassText.setEnabled(true);
                        this.fUIPlugin.setEnabled(true);
                    }
                }
            }
        }
        if (visible) {
            int oldfChanged;
            String id = this.computeId();
            if ((this.fChangedGroups & 1) == 0) {
                oldfChanged = this.fChangedGroups;
                this.fIdText.setText(id);
                this.fVersionText.setText("1.0.0");
                this.presetNameField(id);
                this.presetProviderField(id);
                this.presetLibraryField(id);
                this.fChangedGroups = oldfChanged;
            }
            if (!this.fIsFragment && (this.fChangedGroups & 2) == 0) {
                oldfChanged = this.fChangedGroups;
                this.presetClassField(id);
                this.fChangedGroups = oldfChanged;
            }
            if (this.isInitialized) {
                this.validatePage();
            }
            this.isInitialized = true;
        } else {
            this.updateData();
        }
        super.setVisible(visible);
    }

    private String computeId() {
        return this.fProjectProvider.getProjectName().replaceAll("[^a-zA-Z0-9\\._]", "_");
    }

    private void presetLibraryField(String id) {
        StringTokenizer tok = new StringTokenizer(id, ".");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (tok.hasMoreTokens()) continue;
            this.fLibraryText.setText(String.valueOf(token) + ".jar");
        }
    }

    private void presetNameField(String id) {
        StringTokenizer tok = new StringTokenizer(id, ".");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (tok.hasMoreTokens()) continue;
            this.fNameText.setText(String.valueOf(Character.toUpperCase(token.charAt(0))) + (token.length() > 1 ? token.substring(1) : "") + " " + (this.fIsFragment ? PDEPlugin.getResourceString("ContentPage.fragment") : PDEPlugin.getResourceString("ContentPage.plugin")));
        }
    }

    private void presetProviderField(String id) {
        StringTokenizer tok = new StringTokenizer(id, ".");
        int count = tok.countTokens();
        if (count > 2 && tok.nextToken().equals("com")) {
            this.fProviderText.setText(tok.nextToken().toUpperCase());
        }
    }

    private void presetClassField(String id) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < id.length()) {
            char ch = id.charAt(i);
            if (buffer.length() == 0) {
                if (Character.isJavaIdentifierStart(ch)) {
                    buffer.append(ch);
                }
            } else if (Character.isJavaIdentifierPart(ch) || ch == '.') {
                buffer.append(ch);
            }
            ++i;
        }
        StringTokenizer tok = new StringTokenizer(buffer.toString(), ".");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (tok.hasMoreTokens()) continue;
            buffer.append("." + Character.toUpperCase(token.charAt(0)) + token.substring(1) + "Plugin");
        }
        this.fClassText.setText(buffer.toString());
    }

    public void updateData() {
        this.fData.setId(this.fIdText.getText().trim());
        this.fData.setVersion(this.fVersionText.getText().trim());
        this.fData.setName(this.fNameText.getText().trim());
        this.fData.setProvider(this.fProviderText.getText().trim());
        this.fData.setIsLegacy(this.fLegacyButton.isEnabled() && this.fLegacyButton.getSelection());
        if (this.creationPage.isJavaProject()) {
            String library = this.fLibraryText.getText().trim();
            if (!library.endsWith(".jar")) {
                library = String.valueOf(library) + ".jar";
            }
            this.fData.setLibraryName(library);
        }
    }

    public IFieldData getData() {
        return this.fData;
    }

    public String getId() {
        return this.fIdText.getText().trim();
    }
}

