/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.internal.DragCursors;
import org.eclipse.ui.internal.IChangeListener;
import org.eclipse.ui.internal.IWindowTrim;
import org.eclipse.ui.internal.IntModel;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.RadioMenu;
import org.eclipse.ui.internal.RectangleAnimation;
import org.eclipse.ui.internal.ShowFastViewContribution;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dnd.AbstractDropTarget;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.dnd.IDragOverListener;
import org.eclipse.ui.internal.dnd.IDropTarget;
import org.eclipse.ui.internal.layout.CellLayout;
import org.eclipse.ui.internal.layout.LayoutUtil;
import org.eclipse.ui.internal.layout.Row;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.presentations.PresentationUtil;
import org.osgi.framework.Bundle;

public class FastViewBar
implements IWindowTrim {
    private ToolBarManager fastViewBar;
    private Menu fastViewBarMenu;
    private Menu sidesMenu;
    private WorkbenchWindow window;
    private MenuItem restoreItem;
    private IViewReference selection;
    private boolean visible = false;
    private Composite control;
    private GridData toolBarData;
    private static final int HIDDEN_WIDTH = 5;
    private MenuItem showOn;
    private Cursor moveCursor;
    private MenuItem closeItem;
    private MenuItem orientationItem;
    private IntModel side = new IntModel(FastViewBar.getInitialSide());
    private IntModel currentOrientation = new IntModel(512);
    private RadioMenu radioButtons;
    private IViewReference selectedView;
    private int lastSide;
    private Label fastViewLabel;
    private Label fastViewLabel2;
    private int oldLength = 0;
    private IChangeListener orientationChangeListener = new IChangeListener(){

        public void update(boolean changed) {
            if (changed && FastViewBar.this.selectedView != null) {
                FastViewBar.this.setOrientation(FastViewBar.this.selectedView, FastViewBar.this.currentOrientation.get());
            }
        }
    };
    private Map viewOrientation = new HashMap();
    private Listener menuListener;

    public FastViewBar(WorkbenchWindow theWindow) {
        this.window = theWindow;
        this.window.addPerspectiveListener(new IPerspectiveListener(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                FastViewBar.this.update(true);
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
                FastViewBar.this.update(true);
            }
        });
    }

    private static int getInitialSide() {
        String loc = PrefUtil.getAPIPreferenceStore().getString("initialFastViewBarLocation");
        if ("bottom".equals(loc)) {
            return 1024;
        }
        if ("left".equals(loc)) {
            return 16384;
        }
        if ("right".equals(loc)) {
            return 131072;
        }
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        if (bundle != null) {
            Status status = new Status(2, "org.eclipse.ui", 2, "Invalid value for org.eclipse.ui/initialFastViewBarLocation preference.  Value \"" + loc + "\" should be one of \"" + "left" + "\", \"" + "bottom" + "\", or \"" + "right" + "\".", null);
            Platform.getLog((Bundle)bundle).log((IStatus)status);
        }
        return 1024;
    }

    public void setOrientation(IViewReference refToSet, int newState) {
        if (newState == this.getOrientation(refToSet)) {
            return;
        }
        this.viewOrientation.put(refToSet.getId(), new Integer(newState));
        Perspective persp = this.getPerspective();
        if (persp != null) {
            IViewReference ref = persp.getActiveFastView();
            if (ref != null) {
                persp.setActiveFastView(null);
            }
            persp.setActiveFastView(refToSet);
        }
    }

    private WorkbenchPage getPage() {
        if (this.window == null) {
            return null;
        }
        return this.window.getActiveWorkbenchPage();
    }

    private Perspective getPerspective() {
        WorkbenchPage page = this.getPage();
        if (page == null) {
            return null;
        }
        return page.getActivePerspective();
    }

    public void createControl(Composite parent) {
        this.control = new Composite(parent, 0);
        this.side.addChangeListener(new IChangeListener(){

            public void update(boolean changed) {
                if (changed && Geometry.isHorizontal((int)FastViewBar.this.getSide()) != Geometry.isHorizontal((int)FastViewBar.this.lastSide)) {
                    FastViewBar.this.disposeChildControls();
                    FastViewBar.this.createChildControls();
                }
                FastViewBar.this.lastSide = FastViewBar.this.getSide();
            }
        });
        this.currentOrientation.addChangeListener(this.orientationChangeListener);
        this.createChildControls();
    }

    protected void createChildControls() {
        int newSide = this.getSide();
        int flags = Geometry.isHorizontal((int)newSide) ? 256 : 512;
        this.fastViewBar = new ToolBarManager(0x800040 | flags);
        this.fastViewBar.add((IContributionItem)new ShowFastViewContribution(this.window));
        this.menuListener = new Listener(){

            public void handleEvent(Event event) {
                Point loc = new Point(event.x, event.y);
                if (event.type == 35) {
                    FastViewBar.this.showFastViewBarPopup(loc);
                }
            }
        };
        CellLayout controlLayout = new CellLayout(0).setMargins(0, newSide == 1024 ? 0 : 3).setDefaultRow(Row.growing()).setDefaultColumn(Row.fixed()).setColumn(newSide == 1024 ? 1 : 0, Row.growing());
        this.control.setLayout((Layout)controlLayout);
        String tip = WorkbenchMessages.getString("FastViewBar.0");
        this.control.setToolTipText(tip);
        if (newSide == 1024) {
            this.fastViewLabel = this.createFastViewSeparator(this.control);
            this.fastViewLabel.setToolTipText(tip);
        }
        this.fastViewBar.createControl(this.control);
        if (newSide == 1024) {
            this.fastViewLabel2 = this.createFastViewSeparator(this.control);
            this.fastViewLabel2.setToolTipText(tip);
        }
        this.getToolBar().addListener(35, this.menuListener);
        Listener dragListener = new Listener(){

            public void handleEvent(Event event) {
                Point position = DragUtil.getEventLoc(event);
                IViewReference ref = FastViewBar.this.getViewAt(position);
                if (ref == null) {
                    FastViewBar.this.startDraggingFastViewBar(position, false);
                } else {
                    FastViewBar.this.startDraggingFastView(ref, position, false);
                }
            }
        };
        IDragOverListener fastViewDragTarget = new IDragOverListener(){

            public IDropTarget drag(Control currentControl, Object draggedObject, Point position, Rectangle dragRectangle) {
                ToolItem targetItem = FastViewBar.this.getToolItem(position);
                if (draggedObject instanceof ViewPane) {
                    ViewPane pane = (ViewPane)draggedObject;
                    if (pane.getWorkbenchWindow() != FastViewBar.this.window) {
                        return null;
                    }
                    ArrayList<Object> newList = new ArrayList<Object>(1);
                    newList.add(draggedObject);
                    return new ViewDropTarget(newList, targetItem);
                }
                if (draggedObject instanceof ViewStack) {
                    ViewStack folder = (ViewStack)draggedObject;
                    if (folder.getWorkbenchWindow() != FastViewBar.this.window) {
                        return null;
                    }
                    ArrayList<LayoutPart> viewList = new ArrayList<LayoutPart>(folder.getItemCount());
                    LayoutPart[] children = folder.getChildren();
                    int idx = 0;
                    while (idx < children.length) {
                        if (!(children[idx] instanceof PartPlaceholder)) {
                            viewList.add(children[idx]);
                        }
                        ++idx;
                    }
                    return new ViewDropTarget(viewList, targetItem);
                }
                return null;
            }

            class ViewDropTarget
            extends AbstractDropTarget {
                List panes;
                ToolItem position;

                public ViewDropTarget(List panesToDrop, ToolItem position) {
                    this.panes = panesToDrop;
                    this.position = position;
                }

                public void drop() {
                    IViewReference view = FastViewBar.this.getViewFor(this.position);
                    Iterator iter = this.panes.iterator();
                    while (iter.hasNext()) {
                        ViewPane pane = (ViewPane)iter.next();
                        FastViewBar.this.getPage().addFastView(pane.getViewReference());
                        FastViewBar.this.getPage().getActivePerspective().moveFastView(pane.getViewReference(), view);
                    }
                    FastViewBar.this.update(true);
                }

                public Cursor getCursor() {
                    return DragCursors.getCursor(7);
                }

                public Rectangle getSnapRectangle() {
                    if (this.position == null) {
                        if (FastViewBar.this.getToolBar().getItemCount() > 0) {
                            return FastViewBar.this.getLocationOfNextIcon();
                        }
                        return DragUtil.getDisplayBounds(FastViewBar.this.getControl());
                    }
                    return Geometry.toDisplay((Control)FastViewBar.this.getToolBar(), (Rectangle)this.position.getBounds());
                }
            }
        };
        this.toolBarData = new GridData(1808);
        this.toolBarData.widthHint = 5;
        this.visible = false;
        this.getToolBar().setLayoutData((Object)this.toolBarData);
        PresentationUtil.addDragListener((Control)this.getToolBar(), dragListener);
        DragUtil.addDragTarget(this.getControl(), fastViewDragTarget);
        if (this.fastViewLabel != null) {
            PresentationUtil.addDragListener((Control)this.fastViewLabel, dragListener);
        }
        if (this.fastViewLabel2 != null) {
            PresentationUtil.addDragListener((Control)this.fastViewLabel2, dragListener);
        }
        this.update(true);
    }

    protected void startDraggingFastView(IViewReference ref, Point position, boolean usingKeyboard) {
        ViewPane pane = (ViewPane)((WorkbenchPartReference)((Object)ref)).getPane();
        ToolItem item = this.itemFor(pane.getViewReference());
        Rectangle dragRect = Geometry.toDisplay((Control)this.getToolBar(), (Rectangle)item.getBounds());
        this.getPerspective();
        this.getPage();
        this.startDrag((ViewPane)((WorkbenchPartReference)((Object)ref)).getPane(), dragRect, position, usingKeyboard);
    }

    private void startDrag(Object toDrag, Rectangle dragRect, Point position, boolean usingKeyboard) {
        boolean success;
        Perspective persp = this.getPerspective();
        WorkbenchPage page = this.getPage();
        IViewReference oldFastView = null;
        if (persp != null) {
            oldFastView = persp.getActiveFastView();
            if (page != null) {
                page.hideFastView();
            }
        }
        if (page.isZoomed()) {
            page.zoomOut();
        }
        if (!(success = DragUtil.performDrag(toDrag, dragRect, position, !usingKeyboard)) && oldFastView != null && page != null) {
            page.toggleFastView(oldFastView);
        }
    }

    protected void startDraggingFastViewBar(Point position, boolean usingKeyboard) {
        Rectangle dragRect = DragUtil.getDisplayBounds((Control)this.control);
        this.startDrag(this, dragRect, position, usingKeyboard);
    }

    private Label createFastViewSeparator(Composite control2) {
        Label result = new Label(control2, 514);
        result.addListener(35, this.menuListener);
        if (this.moveCursor == null) {
            this.moveCursor = new Cursor((Device)this.control.getDisplay(), 5);
        }
        result.setCursor(this.moveCursor);
        GridData data = new GridData(1040);
        data.heightHint = 10;
        data.widthHint = 10;
        data.verticalAlignment = 2;
        data.horizontalAlignment = 2;
        result.setLayoutData((Object)data);
        return result;
    }

    private ToolBar getToolBar() {
        return this.fastViewBar.getControl();
    }

    private IViewReference getViewFor(ToolItem item) {
        if (item == null) {
            return null;
        }
        return (IViewReference)item.getData("FastView");
    }

    private IViewReference getViewAt(Point position) {
        return this.getViewFor(this.getToolItem(position));
    }

    private ToolItem getToolItem(Point position) {
        ToolBar toolbar = this.getToolBar();
        Point local = toolbar.toControl(position);
        return toolbar.getItem(local);
    }

    private void showFastViewBarPopup(Point pt) {
        ToolBar toolBar = this.getToolBar();
        if (this.fastViewBarMenu == null) {
            Menu menu = new Menu((Control)toolBar);
            this.orientationItem = new MenuItem(menu, 64);
            this.orientationItem.setText(WorkbenchMessages.getString("FastViewBar.view_orientation"));
            Menu orientationSwtMenu = new Menu(this.orientationItem);
            RadioMenu orientationMenu = new RadioMenu(orientationSwtMenu, this.currentOrientation);
            orientationMenu.addMenuItem(WorkbenchMessages.getString("FastViewBar.horizontal"), new Integer(256));
            orientationMenu.addMenuItem(WorkbenchMessages.getString("FastViewBar.vertical"), new Integer(512));
            this.orientationItem.setMenu(orientationSwtMenu);
            this.restoreItem = new MenuItem(menu, 32);
            this.restoreItem.setSelection(true);
            this.restoreItem.setText(WorkbenchMessages.getString("ViewPane.fastView"));
            this.restoreItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WorkbenchPage page;
                    if (FastViewBar.this.selectedView != null && (page = FastViewBar.this.window.getActiveWorkbenchPage()) != null) {
                        int idx = FastViewBar.this.getIndex(FastViewBar.this.selectedView);
                        ToolItem item = FastViewBar.this.getItem(idx);
                        Rectangle bounds = item.getBounds();
                        Rectangle startBounds = Geometry.toDisplay((Control)item.getParent(), (Rectangle)bounds);
                        page.removeFastView(FastViewBar.this.selectedView);
                        PartPane pane = ((WorkbenchPartReference)((Object)FastViewBar.this.selectedView)).getPane();
                        RectangleAnimation animation = new RectangleAnimation(FastViewBar.this.window.getShell(), startBounds, DragUtil.getDisplayBounds(((LayoutPart)pane).getControl()));
                        animation.schedule();
                    }
                }
            });
            this.closeItem = new MenuItem(menu, 0);
            this.closeItem.setText(WorkbenchMessages.getString("WorkbenchWindow.close"));
            this.closeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WorkbenchPage page;
                    if (FastViewBar.this.selectedView != null && (page = FastViewBar.this.window.getActiveWorkbenchPage()) != null) {
                        page.hideView(FastViewBar.this.selectedView);
                    }
                }
            });
            new MenuItem(menu, 2);
            this.showOn = new MenuItem(menu, 64);
            this.showOn.setText(WorkbenchMessages.getString("FastViewBar.dock_on"));
            this.sidesMenu = new Menu(this.showOn);
            this.radioButtons = new RadioMenu(this.sidesMenu, this.side);
            this.radioButtons.addMenuItem(WorkbenchMessages.getString("FastViewBar.Left"), new Integer(16384));
            this.radioButtons.addMenuItem(WorkbenchMessages.getString("FastViewBar.Right"), new Integer(131072));
            this.radioButtons.addMenuItem(WorkbenchMessages.getString("FastViewBar.Bottom"), new Integer(1024));
            this.showOn.setMenu(this.sidesMenu);
            this.fastViewBarMenu = menu;
        }
        this.selectedView = this.getViewAt(pt);
        boolean selectingView = this.selectedView != null;
        this.restoreItem.setEnabled(selectingView);
        this.restoreItem.setSelection(true);
        this.closeItem.setEnabled(selectingView);
        this.orientationItem.setEnabled(selectingView);
        if (selectingView) {
            this.currentOrientation.set(this.getOrientation(this.selectedView), this.orientationChangeListener);
        }
        this.fastViewBarMenu.setLocation(pt.x, pt.y);
        this.fastViewBarMenu.setVisible(true);
    }

    public int getOrientation(IViewReference ref) {
        return this.isHorizontal(ref) ? 256 : 512;
    }

    public Control getControl() {
        return this.control;
    }

    public void dispose() {
        if (this.radioButtons != null) {
            this.radioButtons.dispose();
        }
        this.disposeChildControls();
    }

    protected void disposeChildControls() {
        this.fastViewBar.dispose();
        this.fastViewBar = null;
        if (this.fastViewLabel != null) {
            this.fastViewLabel.dispose();
            this.fastViewLabel = null;
        }
        if (this.fastViewLabel2 != null) {
            this.fastViewLabel2.dispose();
            this.fastViewLabel2 = null;
        }
        if (this.moveCursor != null) {
            this.moveCursor.dispose();
            this.moveCursor = null;
        }
        this.oldLength = 0;
    }

    public void update(boolean force) {
        boolean shouldExpand;
        this.fastViewBar.update(force);
        ToolItem[] items = this.fastViewBar.getControl().getItems();
        boolean bl = shouldExpand = items.length > 0;
        if (shouldExpand != this.visible) {
            this.getToolBar().setVisible(true);
            this.toolBarData.widthHint = !shouldExpand ? 5 : -1;
            this.visible = shouldExpand;
        }
        if (items.length != this.oldLength) {
            LayoutUtil.resize((Control)this.control);
            this.oldLength = items.length;
        }
        int idx = 0;
        while (idx < items.length) {
            IViewReference view = this.getViewFor(items[idx]);
            this.viewOrientation.put(view.getId(), new Integer(this.isHorizontal(view) ? 256 : 512));
            ++idx;
        }
    }

    public IViewReference getSelection() {
        return this.selection;
    }

    public void setSelection(IViewReference selected) {
        ToolItem[] items = this.fastViewBar.getControl().getItems();
        int i = 0;
        while (i < items.length) {
            ToolItem item;
            item.setSelection(this.getView(item = items[i]) == selected);
            ++i;
        }
        this.selection = selected;
    }

    private IViewReference getView(ToolItem item) {
        return (IViewReference)item.getData("FastView");
    }

    private int getIndex(IViewReference toFind) {
        ToolItem[] items = this.fastViewBar.getControl().getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getData("FastView") == toFind) {
                return i;
            }
            ++i;
        }
        return items.length;
    }

    private ToolItem getItem(int idx) {
        ToolItem[] items = this.fastViewBar.getControl().getItems();
        if (idx >= items.length) {
            return null;
        }
        return items[idx];
    }

    private ToolItem itemFor(IViewReference toFind) {
        return this.getItem(this.getIndex(toFind));
    }

    public int getValidSides() {
        return 148480;
    }

    public void dock(int side) {
        this.side.set(side);
    }

    public int getSide() {
        return this.side.get();
    }

    public void addDockingListener(IChangeListener listener) {
        this.side.addChangeListener(listener);
    }

    private boolean isHorizontal(IViewReference ref) {
        boolean horizontalBar;
        Integer orientation = (Integer)this.viewOrientation.get(ref.getId());
        boolean horizontal = horizontalBar = Geometry.isHorizontal((int)this.getSide());
        horizontal = orientation != null ? orientation == 256 : false;
        return horizontal;
    }

    public int getViewSide(IViewReference ref) {
        boolean horizontal = this.isHorizontal(ref);
        if (horizontal) {
            return this.getSide() == 1024 ? 1024 : 128;
        }
        return this.getSide() == 131072 ? 131072 : 16384;
    }

    public void saveState(IMemento memento) {
        memento.putInteger("fastViewLocation", this.getSide());
        Iterator iter = this.viewOrientation.keySet().iterator();
        while (iter.hasNext()) {
            String next = (String)iter.next();
            IMemento orientation = memento.createChild("orientation");
            orientation.putString("view", next);
            orientation.putInteger("position", (Integer)this.viewOrientation.get(next));
        }
    }

    public Rectangle getLocationOfNextIcon() {
        ToolBar control = this.getToolBar();
        Rectangle result = control.getBounds();
        Point size = control.computeSize(-1, -1, false);
        result.height = size.y;
        result.width = size.x;
        boolean horizontal = Geometry.isHorizontal((int)this.getSide());
        int hoverSide = horizontal ? 131072 : 1024;
        result = Geometry.getExtrudedEdge((Rectangle)result, (int)(-Geometry.getDimension((Rectangle)result, (!horizontal ? 1 : 0) != 0)), (int)hoverSide);
        return Geometry.toDisplay((Control)control.getParent(), (Rectangle)result);
    }

    public void restoreState(IMemento memento) {
        Integer bigInt = memento.getInteger("fastViewLocation");
        if (bigInt != null) {
            this.dock(bigInt);
        }
        IMemento[] orientations = memento.getChildren("orientation");
        int i = 0;
        while (i < orientations.length) {
            IMemento next = orientations[i];
            this.viewOrientation.put(next.getString("view"), next.getInteger("position"));
            ++i;
        }
    }
}

