/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.internal.core.Assert;
import org.eclipse.team.internal.core.subscribers.SubscriberSyncInfoCollector;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.synchronize.IRefreshEvent;
import org.eclipse.team.internal.ui.synchronize.IRefreshSubscriberListener;
import org.eclipse.team.internal.ui.synchronize.WorkbenchAction;
import org.eclipse.team.ui.synchronize.ISynchronizeManager;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.progress.UIJob;

public final class RefreshSubscriberJob
extends Job {
    private static final Object FAMILY_ID = new Object();
    private boolean reschedule = false;
    private boolean restartOnCancel = true;
    private static long scheduleDelay;
    private IResource[] resources;
    private SubscriberParticipant participant;
    private String taskName;
    private static List listeners;
    private static final int STARTED = 1;
    private static final int DONE = 2;
    private static final ILock lock;
    private static final IStatus POSTPONED;

    static {
        listeners = new ArrayList(1);
        lock = Platform.getJobManager().newLock();
        POSTPONED = new Status(8, "org.eclipse.team.ui", 0, "Scheduled refresh postponed due to conflicting operation", null);
    }

    public RefreshSubscriberJob(SubscriberParticipant participant, String jobName, String taskName, IResource[] resources, IRefreshSubscriberListener listener) {
        super(taskName);
        Assert.isNotNull((Object)resources);
        Assert.isNotNull((Object)participant);
        Assert.isNotNull((Object)resources);
        this.resources = resources;
        this.participant = participant;
        this.taskName = jobName;
        this.setPriority(50);
        this.setRefreshInterval(3600L);
        this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (RefreshSubscriberJob.this.shouldReschedule()) {
                    IStatus result = event.getResult();
                    if (result.getSeverity() == 8 && !RefreshSubscriberJob.this.restartOnCancel) {
                        return;
                    }
                    long delay = scheduleDelay;
                    if (result == POSTPONED) {
                        delay = 5000L;
                    }
                    RefreshSubscriberJob.this.schedule(delay);
                    RefreshSubscriberJob.this.restartOnCancel = true;
                }
            }
        });
        if (listener != null) {
            this.initialize(listener);
        }
    }

    public boolean shouldRun() {
        return this.getSubscriber() != null;
    }

    public boolean belongsTo(Object family) {
        if (family instanceof RefreshSubscriberJob) {
            return ((RefreshSubscriberJob)((Object)family)).getSubscriber() == this.getSubscriber();
        }
        if (family instanceof SubscriberParticipant) {
            return family == this.participant;
        }
        return family == RefreshSubscriberJob.getFamily() || family == ISynchronizeManager.FAMILY_SYNCHRONIZE_OPERATION;
    }

    public static Object getFamily() {
        return FAMILY_ID;
    }

    /*
     * Exception decompiling
     */
    public IStatus run(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 8[TRYBLOCK] [5 : 335->338)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isJobInFamilyRunning(Object family) {
        Job[] jobs = Platform.getJobManager().find(family);
        if (jobs != null && jobs.length > 0) {
            int i = 0;
            while (i < jobs.length) {
                Job job = jobs[i];
                if (job.getState() != 0) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private IStatus calculateStatus(IRefreshEvent event) {
        StringBuffer text = new StringBuffer();
        int code = 0;
        SyncInfo[] changes = event.getChanges();
        SubscriberSyncInfoCollector collector = this.getCollector();
        if (collector != null) {
            int numChanges = this.refreshedResourcesContainChanges(event);
            if (numChanges > 0) {
                code = 1;
                if (changes.length > 0) {
                    String numNewChanges = Integer.toString(event.getChanges().length);
                    if (event.getChanges().length == 1) {
                        text.append(Policy.bind("RefreshCompleteDialog.newChangesSingular", new Object[]{this.getName(), numNewChanges}));
                    } else {
                        text.append(Policy.bind("RefreshCompleteDialog.newChangesPlural", new Object[]{this.getName(), numNewChanges}));
                    }
                } else if (numChanges == 1) {
                    text.append(Policy.bind("RefreshCompleteDialog.changesSingular", new Object[]{this.getName(), new Integer(numChanges)}));
                } else {
                    text.append(Policy.bind("RefreshCompleteDialog.changesPlural", new Object[]{this.getName(), new Integer(numChanges)}));
                }
            } else {
                code = 2;
                text.append(Policy.bind("RefreshCompleteDialog.6", this.getName()));
            }
            return new Status(0, "org.eclipse.team.ui", code, text.toString(), null);
        }
        return Status.OK_STATUS;
    }

    private int refreshedResourcesContainChanges(IRefreshEvent event) {
        int numChanges = 0;
        SubscriberSyncInfoCollector collector = this.getCollector();
        if (collector != null) {
            SyncInfoTree set = collector.getSyncInfoSet();
            IResource[] resources = event.getResources();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                SyncInfo[] infos = set.getSyncInfos(resource, 2);
                if (infos != null && infos.length > 0) {
                    numChanges += infos.length;
                }
                ++i;
            }
        }
        return numChanges;
    }

    private void initialize(final IRefreshSubscriberListener listener) {
        final ActionFactory.IWorkbenchAction[] gotoAction = new ActionFactory.IWorkbenchAction[1];
        final WorkbenchAction actionWrapper = new WorkbenchAction(){

            public void run() {
                if (gotoAction[0] != null) {
                    gotoAction[0].run();
                }
            }

            public boolean isEnabled() {
                if (gotoAction[0] != null) {
                    return gotoAction[0].isEnabled();
                }
                return true;
            }

            public String getToolTipText() {
                if (gotoAction[0] != null) {
                    return gotoAction[0].getToolTipText();
                }
                return super.getToolTipText();
            }

            public void dispose() {
                super.dispose();
                if (gotoAction[0] != null) {
                    gotoAction[0].dispose();
                }
            }
        };
        IProgressMonitor group = Platform.getJobManager().createProgressGroup();
        group.beginTask(this.taskName, 100);
        this.setProgressGroup(group, 80);
        this.getCollector().setProgressGroup(group, 20);
        this.setProperty(IProgressConstants.ICON_PROPERTY, this.participant.getImageDescriptor());
        this.setProperty(IProgressConstants.ACTION_PROPERTY, (Object)actionWrapper);
        this.setProperty(IProgressConstants.KEEPONE_PROPERTY, !this.isJobModal());
        IRefreshSubscriberListener autoListener = new IRefreshSubscriberListener(){

            public void refreshStarted(IRefreshEvent event) {
                if (listener != null) {
                    listener.refreshStarted(event);
                }
            }

            public ActionFactory.IWorkbenchAction refreshDone(IRefreshEvent event) {
                if (listener != null) {
                    boolean isModal = RefreshSubscriberJob.this.isJobModal();
                    ActionFactory.IWorkbenchAction runnable = listener.refreshDone(event);
                    if (runnable != null) {
                        if (isModal) {
                            if (runnable != null) {
                                IAction[] r = new IAction[]{runnable};
                                UIJob update = new UIJob(this, "", r){
                                    final /* synthetic */ 3 this$1;
                                    private final /* synthetic */ IAction[] val$r;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$r = iActionArray;
                                    }

                                    public IStatus runInUIThread(IProgressMonitor monitor) {
                                        this.val$r[0].run();
                                        return Status.OK_STATUS;
                                    }
                                };
                                update.setSystem(true);
                                update.schedule();
                            }
                        } else {
                            gotoAction[0] = runnable;
                            actionWrapper.setEnabled(runnable.isEnabled());
                            actionWrapper.setToolTipText(runnable.getToolTipText());
                            runnable.addPropertyChangeListener(new IPropertyChangeListener(this, actionWrapper){
                                final /* synthetic */ 3 this$1;
                                private final /* synthetic */ ActionFactory.IWorkbenchAction val$actionWrapper;
                                {
                                    this.this$1 = var1_1;
                                    this.val$actionWrapper = iWorkbenchAction;
                                }

                                public void propertyChange(PropertyChangeEvent event) {
                                    if (event.getProperty().equals("enabled")) {
                                        Boolean bool = (Boolean)event.getNewValue();
                                        this.val$actionWrapper.setEnabled(bool.booleanValue());
                                    }
                                }
                            });
                        }
                    }
                    RefreshSubscriberJob.removeRefreshListener(this);
                }
                return null;
            }
        };
        if (listener != null) {
            RefreshSubscriberJob.addRefreshListener(autoListener);
        }
    }

    protected IResource[] getResources() {
        return this.resources;
    }

    protected Subscriber getSubscriber() {
        return this.participant.getSubscriber();
    }

    protected SubscriberSyncInfoCollector getCollector() {
        return this.participant.getSubscriberSyncInfoCollector();
    }

    public long getScheduleDelay() {
        return scheduleDelay;
    }

    protected void start() {
        if (this.getState() == 0 && this.shouldReschedule()) {
            this.schedule(this.getScheduleDelay());
        }
    }

    public void setRefreshInterval(long seconds) {
        boolean restart = false;
        if (this.getState() == 1) {
            restart = true;
            this.cancel();
        }
        scheduleDelay = seconds * 1000L;
        if (restart) {
            this.start();
        }
    }

    public long getRefreshInterval() {
        return scheduleDelay / 1000L;
    }

    public void setRestartOnCancel(boolean restartOnCancel) {
        this.restartOnCancel = restartOnCancel;
    }

    public void setReschedule(boolean reschedule) {
        this.reschedule = reschedule;
    }

    public boolean shouldReschedule() {
        return this.reschedule;
    }

    public static void addRefreshListener(IRefreshSubscriberListener listener) {
        List list = listeners;
        synchronized (list) {
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        }
    }

    public static void removeRefreshListener(IRefreshSubscriberListener listener) {
        List list = listeners;
        synchronized (list) {
            listeners.remove(listener);
        }
    }

    protected void notifyListeners(final int state, final IRefreshEvent event) {
        IRefreshSubscriberListener[] listenerArray;
        List list = listeners;
        synchronized (list) {
            listenerArray = listeners.toArray(new IRefreshSubscriberListener[listeners.size()]);
        }
        int i = 0;
        while (i < listenerArray.length) {
            IRefreshSubscriberListener listener = listenerArray[i];
            Notification notification = new Notification(){

                protected void notify(IRefreshSubscriberListener listener) {
                    switch (state) {
                        case 1: {
                            listener.refreshStarted(event);
                            break;
                        }
                        case 2: {
                            listener.refreshDone(event);
                            break;
                        }
                    }
                }
            };
            notification.run(listener);
            ++i;
        }
    }

    private boolean isJobModal() {
        Boolean isModal = (Boolean)this.getProperty(IProgressConstants.PROPERTY_IN_DIALOG);
        if (isModal == null) {
            return false;
        }
        return isModal;
    }

    private abstract class Notification
    implements ISafeRunnable {
        private IRefreshSubscriberListener listener;

        Notification() {
        }

        public void handleException(Throwable exception) {
        }

        public void run(IRefreshSubscriberListener listener) {
            this.listener = listener;
            Platform.run((ISafeRunnable)this);
        }

        public void run() throws Exception {
            this.notify(this.listener);
        }

        protected abstract void notify(IRefreshSubscriberListener var1);
    }

    private class NonblockingProgressMonitor
    extends ProgressMonitorWrapper {
        private final RefreshSubscriberJob job;
        private long blockTime;
        private static final int THRESHOLD = 250;
        private boolean wasBlocking = false;

        protected NonblockingProgressMonitor(IProgressMonitor monitor, RefreshSubscriberJob job) {
            super(monitor);
            this.job = job;
        }

        public boolean isCanceled() {
            if (super.isCanceled()) {
                return true;
            }
            if (this.job.shouldReschedule() && this.job.isBlocking()) {
                if (this.blockTime == 0L) {
                    this.blockTime = System.currentTimeMillis();
                } else if (System.currentTimeMillis() - this.blockTime > 250L) {
                    this.wasBlocking = true;
                    return true;
                }
            } else {
                this.blockTime = 0L;
            }
            this.wasBlocking = false;
            return false;
        }

        public boolean wasBlocking() {
            return this.wasBlocking;
        }
    }
}

