/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.internal.core.subscribers.SubscriberSyncInfoCollector;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.IRefreshSubscriberListener;
import org.eclipse.team.internal.ui.synchronize.RefreshSubscriberJob;
import org.eclipse.team.internal.ui.synchronize.RefreshUserNotificationPolicy;
import org.eclipse.team.internal.ui.synchronize.RefreshUserNotificationPolicyInModalDialog;
import org.eclipse.team.internal.ui.synchronize.SubscriberParticipantPage;
import org.eclipse.team.internal.ui.synchronize.SubscriberRefreshSchedule;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.AbstractSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.AbstractSynchronizeScope;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantReference;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.WorkspaceScope;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPageBookViewPage;

public abstract class SubscriberParticipant
extends AbstractSynchronizeParticipant
implements IPropertyChangeListener {
    private SubscriberSyncInfoCollector collector;
    private SubscriberRefreshSchedule refreshSchedule = new SubscriberRefreshSchedule(this);
    private ISynchronizeScope scope;
    private static final String CTX_SUBSCRIBER_PARTICIPANT_SETTINGS = "org.eclipse.team.ui.TEAMSUBSRCIBERSETTINGS";
    private static final String CTX_SUBSCRIBER_SCHEDULE_SETTINGS = "org.eclipse.team.ui.TEAMSUBSRCIBER_REFRESHSCHEDULE";

    public SubscriberParticipant() {
    }

    public SubscriberParticipant(ISynchronizeScope scope) {
        this();
        this.scope = scope;
        scope.addPropertyChangeListener(this);
    }

    public final IPageBookViewPage createPage(ISynchronizePageConfiguration configuration) {
        this.validateConfiguration(configuration);
        return new SubscriberParticipantPage(configuration, this.getSubscriberSyncInfoCollector());
    }

    public IResource[] getResources() {
        return this.collector.getRoots();
    }

    private void setResources(IResource[] roots) {
        this.collector.setRoots(roots);
    }

    public final void refreshInDialog(Shell shell, IResource[] resources, String jobName, String taskName, ISynchronizePageConfiguration configuration, IWorkbenchSite site) {
        RefreshUserNotificationPolicyInModalDialog listener = new RefreshUserNotificationPolicyInModalDialog(shell, taskName, configuration, this);
        this.internalRefresh(resources, jobName, taskName, site, listener);
    }

    public final void refresh(IResource[] resources, String shortTaskName, String longTaskName, IWorkbenchSite site) {
        RefreshUserNotificationPolicy listener = new RefreshUserNotificationPolicy(this);
        this.internalRefresh(resources, shortTaskName, longTaskName, site, listener);
    }

    public final IStatus refreshNow(IResource[] resources, String taskName, IProgressMonitor monitor) {
        Platform.getJobManager().cancel((Object)this);
        RefreshSubscriberJob job = new RefreshSubscriberJob(this, taskName, taskName, resources, null);
        return job.run(monitor);
    }

    public void dispose() {
        Platform.getJobManager().cancel((Object)this);
        this.refreshSchedule.dispose();
        TeamUI.removePropertyChangeListener(this);
        this.collector.dispose();
        this.scope.dispose();
    }

    public String getName() {
        String name = super.getName();
        return Policy.bind("SubscriberParticipant.namePattern", name, this.scope.getName());
    }

    public SyncInfoTree getSyncInfoSet() {
        return this.getSubscriberSyncInfoCollector().getSyncInfoSet();
    }

    public Subscriber getSubscriber() {
        if (this.collector == null) {
            return null;
        }
        return this.collector.getSubscriber();
    }

    public static SubscriberParticipant getMatchingParticipant(String ID, IResource[] resources) {
        ISynchronizeParticipantReference[] refs = TeamUI.getSynchronizeManager().getSynchronizeParticipants();
        int i = 0;
        while (i < refs.length) {
            block5: {
                ISynchronizeParticipantReference reference = refs[i];
                if (reference.getId().equals(ID)) {
                    SubscriberParticipant p;
                    try {
                        p = (SubscriberParticipant)reference.getParticipant();
                    }
                    catch (TeamException teamException) {
                        break block5;
                    }
                    Object[] roots = p.getResources();
                    Arrays.sort(resources, Utils.resourceComparator);
                    Arrays.sort(roots, Utils.resourceComparator);
                    if (Arrays.equals(resources, roots)) {
                        return p;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(TeamUI.GLOBAL_IGNORES_CHANGED)) {
            this.collector.reset();
        }
        if (event.getProperty().equals("prop_roots")) {
            this.setResources(this.scope.getRoots());
        }
    }

    public void init(String secondaryId, IMemento memento) throws PartInitException {
        IMemento settings;
        super.init(secondaryId, memento);
        if (memento != null && (settings = memento.getChild(CTX_SUBSCRIBER_PARTICIPANT_SETTINGS)) != null) {
            SubscriberRefreshSchedule schedule = SubscriberRefreshSchedule.init(settings.getChild(CTX_SUBSCRIBER_SCHEDULE_SETTINGS), this);
            this.setRefreshSchedule(schedule);
            this.scope = AbstractSynchronizeScope.createScope(settings);
            this.scope.addPropertyChangeListener(this);
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        IMemento settings = memento.createChild(CTX_SUBSCRIBER_PARTICIPANT_SETTINGS);
        this.refreshSchedule.saveState(settings.createChild(CTX_SUBSCRIBER_SCHEDULE_SETTINGS));
        AbstractSynchronizeScope.saveScope(this.scope, settings);
    }

    public void reset() {
        this.getSubscriberSyncInfoCollector().reset();
    }

    public SubscriberSyncInfoCollector getSubscriberSyncInfoCollector() {
        return this.collector;
    }

    public void setRefreshSchedule(SubscriberRefreshSchedule schedule) {
        if (this.refreshSchedule == schedule) {
            return;
        }
        if (this.refreshSchedule != null) {
            this.refreshSchedule.dispose();
        }
        this.refreshSchedule = schedule;
    }

    public SubscriberRefreshSchedule getRefreshSchedule() {
        return this.refreshSchedule;
    }

    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        configuration.setProperty("org.eclipse.team.ui.P_PARTICIPANT_SYNC_INFO_SET", this.collector.getSyncInfoSet());
    }

    public void run(IWorkbenchPart part) {
        this.refresh(this.getResources(), this.getShortTaskName(), this.getLongTaskName(), (IWorkbenchSite)(part != null ? part.getSite() : null));
    }

    protected String getShortTaskName() {
        return Policy.bind("Participant.synchronizing");
    }

    protected String getLongTaskName() {
        return Policy.bind("Participant.synchronizing");
    }

    protected void validateConfiguration(ISynchronizePageConfiguration configuration) {
    }

    protected void setSubscriber(Subscriber subscriber) {
        if (this.scope == null) {
            this.scope = new WorkspaceScope();
        }
        this.collector = new SubscriberSyncInfoCollector(subscriber, this.scope.getRoots());
        TeamUI.addPropertyChangeListener(this);
        this.collector.start();
        SubscriberRefreshSchedule schedule = this.getRefreshSchedule();
        if (schedule.isEnabled()) {
            this.getRefreshSchedule().startJob();
        }
    }

    protected void setSyncInfoFilter(SyncInfoFilter filter) {
        this.collector.setFilter(filter);
    }

    private void internalRefresh(IResource[] resources, String jobName, String taskName, IWorkbenchSite site, IRefreshSubscriberListener listener) {
        Platform.getJobManager().cancel((Object)this);
        RefreshSubscriberJob job = new RefreshSubscriberJob(this, jobName, taskName, resources, listener);
        job.setUser(true);
        Utils.schedule(job, site);
        TeamUIPlugin.getPlugin().getPreferenceStore().setValue("org.eclipse.team.ui.sychronizing_default_participant", this.getId());
        TeamUIPlugin.getPlugin().getPreferenceStore().setValue("org.eclipse.team.ui.sychronizing_default_participant_sec_id", this.getSecondaryId());
    }

    public ISynchronizeScope getScope() {
        return this.scope;
    }
}

