/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaWordFinder;
import org.eclipse.jdt.internal.ui.text.HTMLTextPresenter;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.hover.IJavaEditorTextHover;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class JavaDebugHover
implements IJavaEditorTextHover,
ITextHoverExtension,
ISelectionListener,
IPartListener {
    protected IEditorPart fEditor;
    protected ISelection fSelection = null;
    static /* synthetic */ Class class$0;

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part.equals(this.fEditor)) {
            IWorkbenchPage page = this.fEditor.getSite().getPage();
            page.removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
            page.removePartListener((IPartListener)this);
            this.fSelection = null;
            this.fEditor = null;
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.fSelection = selection;
    }

    public void setEditor(IEditorPart editor) {
        if (editor != null) {
            this.fEditor = editor;
            final IWorkbenchPage page = editor.getSite().getPage();
            page.addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
            page.addPartListener((IPartListener)this);
            Runnable r = new Runnable(){

                public void run() {
                    JavaDebugHover.this.fSelection = page.getSelection("org.eclipse.debug.ui.DebugView");
                }
            };
            JDIDebugUIPlugin.getStandardDisplay().asyncExec(r);
        }
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return JavaWordFinder.findWord(textViewer.getDocument(), offset);
    }

    protected IJavaStackFrame getFrame() {
        Object el;
        IStructuredSelection selection;
        if (this.fSelection instanceof IStructuredSelection && (selection = (IStructuredSelection)this.fSelection).size() == 1 && (el = selection.getFirstElement()) instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)el;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.debug.core.IJavaStackFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IJavaStackFrame)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IJavaStackFrame frame = this.getFrame();
        if (frame != null) {
            try {
                StringBuffer buffer;
                block8: {
                    IDocument document = textViewer.getDocument();
                    if (document == null) {
                        return null;
                    }
                    String variableName = document.get(hoverRegion.getOffset(), hoverRegion.getLength());
                    buffer = new StringBuffer();
                    try {
                        IJavaVariable variable = frame.findVariable(variableName);
                        if (variable != null) {
                            JavaDebugHover.appendVariable(buffer, (IVariable)variable);
                        }
                    }
                    catch (DebugException x) {
                        if (x.getStatus().getCode() == 100) break block8;
                        JDIDebugUIPlugin.log(x);
                    }
                }
                if (buffer.length() > 0) {
                    return buffer.toString();
                }
            }
            catch (BadLocationException x) {
                JDIDebugUIPlugin.log(x);
            }
        }
        return null;
    }

    private static void appendVariable(StringBuffer buffer, IVariable variable) throws DebugException {
        buffer.append("<p>");
        buffer.append("<pre>").append(variable.getName()).append("</pre>");
        buffer.append(" =");
        String type = JavaDebugHover.getTypeName(variable);
        String value = "<b><pre>" + variable.getValue().getValueString() + "</pre></b>";
        if (type == null) {
            buffer.append(" null");
        } else if (type.equals("java.lang.String")) {
            buffer.append(" \"");
            buffer.append(value);
            buffer.append('\"');
        } else if (type.equals("boolean")) {
            buffer.append(' ');
            buffer.append(value);
        } else {
            buffer.append(" (");
            buffer.append("<pre>").append(type).append("</pre>");
            buffer.append(") ");
            buffer.append(value);
        }
        buffer.append("</p>");
    }

    private static String getTypeName(IVariable variable) throws DebugException {
        IValue value = variable.getValue();
        if (value instanceof IJavaValue) {
            IJavaType type = ((IJavaValue)value).getJavaType();
            if (type == null) {
                return null;
            }
            return type.getName();
        }
        return value.getReferenceTypeName();
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (PreferenceConstants.getPreferenceStore().getBoolean("PreferenceConstants.EDITOR_SHOW_TEXT_HOVER_AFFORDANCE")) {
            return new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), DebugUIMessages.getString("JavaDebugHover.16"));
                }
            };
        }
        return null;
    }
}

