/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;

public class ValidBreakpointLocationLocator
extends ASTVisitor {
    private CompilationUnit fCompilationUnit;
    private int fLineNumber;
    private int fLocation;
    private boolean fLocationFound;
    private String fTypeName;

    public ValidBreakpointLocationLocator(CompilationUnit compilationUnit, int lineNumber) {
        this.fCompilationUnit = compilationUnit;
        this.fLineNumber = lineNumber;
        this.fLocationFound = false;
    }

    public int getValidLocation() {
        if (this.fLocationFound) {
            return this.fLocation;
        }
        return -1;
    }

    public String getFullyQualifiedTypeName() {
        return this.fTypeName;
    }

    protected static String computeTypeName(ASTNode node) {
        String typeName = null;
        while (!(node instanceof CompilationUnit)) {
            if (node instanceof TypeDeclaration) {
                String identifier = ((TypeDeclaration)node).getName().getIdentifier();
                typeName = typeName == null ? identifier : String.valueOf(identifier) + "$" + typeName;
            } else {
                typeName = null;
            }
            node = node.getParent();
        }
        PackageDeclaration packageDecl = ((CompilationUnit)node).getPackage();
        String packageIdentifier = "";
        if (packageDecl != null) {
            Name packageName = packageDecl.getName();
            while (packageName.isQualifiedName()) {
                QualifiedName qualifiedName = (QualifiedName)packageName;
                packageIdentifier = String.valueOf(qualifiedName.getName().getIdentifier()) + "." + packageIdentifier;
                packageName = qualifiedName.getQualifier();
            }
            packageIdentifier = String.valueOf(((SimpleName)packageName).getIdentifier()) + "." + packageIdentifier;
        }
        return String.valueOf(packageIdentifier) + typeName;
    }

    private boolean visit(ASTNode node, boolean isCode) {
        int startPosition = node.getStartPosition();
        int startLine = this.fCompilationUnit.lineNumber(startPosition);
        int endLine = this.fCompilationUnit.lineNumber(startPosition + node.getLength() - 1);
        if (this.fLocationFound || endLine < this.fLineNumber) {
            return false;
        }
        if (isCode && this.fLineNumber <= startLine) {
            this.fLocation = startLine;
            this.fLocationFound = true;
            this.fTypeName = ValidBreakpointLocationLocator.computeTypeName(node);
            return false;
        }
        return true;
    }

    private boolean isReplacedByConstantValue(Expression node) {
        switch (node.getNodeType()) {
            case 9: 
            case 13: 
            case 34: 
            case 45: {
                return true;
            }
            case 27: {
                return this.isReplacedByConstantValue((InfixExpression)node);
            }
            case 38: {
                return this.isReplacedByConstantValue((PrefixExpression)node);
            }
        }
        return false;
    }

    private boolean isReplacedByConstantValue(InfixExpression node) {
        if (!this.isReplacedByConstantValue(node.getLeftOperand()) || !this.isReplacedByConstantValue(node.getRightOperand())) {
            return false;
        }
        if (node.hasExtendedOperands()) {
            Iterator iter = node.extendedOperands().iterator();
            while (iter.hasNext()) {
                if (this.isReplacedByConstantValue((Expression)iter.next())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isReplacedByConstantValue(PrefixExpression node) {
        PrefixExpression.Operator operator = node.getOperator();
        if (operator != PrefixExpression.Operator.INCREMENT && operator != PrefixExpression.Operator.DECREMENT) {
            return this.isReplacedByConstantValue(node.getOperand());
        }
        return false;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(ArrayAccess node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(ArrayCreation node) {
        return this.visit((ASTNode)node, node.getInitializer() == null);
    }

    public boolean visit(ArrayInitializer node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(ArrayType node) {
        return false;
    }

    public boolean visit(AssertStatement node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(Assignment node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(Block node) {
        if (this.visit((ASTNode)node, false)) {
            if (node.statements().isEmpty() && node.getParent().getNodeType() == 31) {
                this.fLocation = this.fCompilationUnit.lineNumber(node.getStartPosition() + node.getLength() - 1);
                this.fLocationFound = true;
                this.fTypeName = ValidBreakpointLocationLocator.computeTypeName((ASTNode)node);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean visit(BooleanLiteral node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(BreakStatement node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(CastExpression node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(CatchClause node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(CharacterLiteral node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(ClassInstanceCreation node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(CompilationUnit node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(ConditionalExpression node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(ConstructorInvocation node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(ContinueStatement node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(DoStatement node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(EmptyStatement node) {
        return false;
    }

    public boolean visit(ExpressionStatement node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(FieldAccess node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(FieldDeclaration node) {
        if (this.visit((ASTNode)node, false)) {
            List fragments = node.fragments();
            Iterator iter = fragments.iterator();
            while (iter.hasNext()) {
                ((VariableDeclarationFragment)iter.next()).accept((ASTVisitor)this);
            }
        }
        return false;
    }

    public boolean visit(ForStatement node) {
        return this.visit((ASTNode)node, node.initializers().isEmpty() && node.getExpression() == null && node.updaters().isEmpty());
    }

    public boolean visit(IfStatement node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(ImportDeclaration node) {
        return false;
    }

    public boolean visit(InfixExpression node) {
        if (this.visit((ASTNode)node, false)) {
            if (this.isReplacedByConstantValue(node)) {
                this.fLocation = this.fCompilationUnit.lineNumber(node.getStartPosition());
                this.fLocationFound = true;
                this.fTypeName = ValidBreakpointLocationLocator.computeTypeName((ASTNode)node);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean visit(Initializer node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(InstanceofExpression node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(Javadoc node) {
        return false;
    }

    public boolean visit(LabeledStatement node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(MethodDeclaration node) {
        Block body;
        if (this.visit((ASTNode)node, false) && (body = node.getBody()) != null) {
            body.accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(MethodInvocation node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(NullLiteral node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(NumberLiteral node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(PackageDeclaration node) {
        return false;
    }

    public boolean visit(ParenthesizedExpression node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(PostfixExpression node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(PrefixExpression node) {
        if (this.visit((ASTNode)node, false)) {
            if (this.isReplacedByConstantValue(node)) {
                this.fLocation = this.fCompilationUnit.lineNumber(node.getStartPosition());
                this.fLocationFound = true;
                this.fTypeName = ValidBreakpointLocationLocator.computeTypeName((ASTNode)node);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean visit(PrimitiveType node) {
        return false;
    }

    public boolean visit(QualifiedName node) {
        this.visit((ASTNode)node, true);
        return false;
    }

    public boolean visit(ReturnStatement node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(SimpleName node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(SimpleType node) {
        return false;
    }

    public boolean visit(SingleVariableDeclaration node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(StringLiteral node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(SuperConstructorInvocation node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(SuperFieldAccess node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(SuperMethodInvocation node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(SwitchCase node) {
        return false;
    }

    public boolean visit(SwitchStatement node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(SynchronizedStatement node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(ThisExpression node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(ThrowStatement node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(TryStatement node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(TypeDeclaration node) {
        if (this.visit((ASTNode)node, false)) {
            List bodyDeclaration = node.bodyDeclarations();
            Iterator iter = bodyDeclaration.iterator();
            while (iter.hasNext()) {
                ((BodyDeclaration)iter.next()).accept((ASTVisitor)this);
            }
        }
        return false;
    }

    public boolean visit(TypeDeclarationStatement node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(TypeLiteral node) {
        return false;
    }

    public boolean visit(VariableDeclarationExpression node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(VariableDeclarationFragment node) {
        Expression initializer = node.getInitializer();
        if (this.visit((ASTNode)node, false) && initializer != null) {
            this.visit((ASTNode)node.getName(), true);
            initializer.accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(VariableDeclarationStatement node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(WhileStatement node) {
        return this.visit((ASTNode)node, false);
    }
}

