/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.internal.debug.ui.ExceptionHandler;
import org.eclipse.jdt.internal.debug.ui.Filter;
import org.eclipse.jdt.internal.debug.ui.FilterLabelProvider;
import org.eclipse.jdt.internal.debug.ui.FilterViewerSorter;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.propertypages.JavaExceptionBreakpointAdvancedPage;
import org.eclipse.jdt.internal.debug.ui.propertypages.PropertyPageMessages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ExceptionFilterEditor {
    protected static final String DEFAULT_PACKAGE = "(default package)";
    private IJavaExceptionBreakpoint fBreakpoint;
    private Button fAddFilterButton;
    private Button fAddPackageButton;
    private Button fAddTypeButton;
    private Button fRemoveFilterButton;
    private Text fEditorText;
    private String fInvalidEditorText = null;
    private TableEditor fTableEditor;
    private TableItem fNewTableItem;
    private Filter fNewFilter;
    private CheckboxTableViewer fFilterViewer;
    private Table fFilterTable;
    private FilterContentProvider fFilterContentProvider;

    public ExceptionFilterEditor(Composite parent, JavaExceptionBreakpointAdvancedPage page) {
        this.fBreakpoint = (IJavaExceptionBreakpoint)page.getBreakpoint();
        Composite outer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        outer.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        outer.setLayoutData((Object)gd);
        Label label = new Label(outer, 0);
        label.setText(PropertyPageMessages.getString("ExceptionFilterEditor.5"));
        label.setFont(parent.getFont());
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fFilterTable = new Table(outer, 67618);
        TableLayout tableLayout = new TableLayout();
        ColumnLayoutData[] columnLayoutData = new ColumnLayoutData[]{new ColumnWeightData(100)};
        tableLayout.addColumnData(columnLayoutData[0]);
        this.fFilterTable.setLayout((Layout)tableLayout);
        new TableColumn(this.fFilterTable, 0);
        this.fFilterViewer = new CheckboxTableViewer(this.fFilterTable);
        this.fTableEditor = new TableEditor(this.fFilterTable);
        this.fFilterViewer.setLabelProvider((IBaseLabelProvider)new FilterLabelProvider());
        this.fFilterViewer.setSorter((ViewerSorter)new FilterViewerSorter());
        this.fFilterContentProvider = new FilterContentProvider(this.fFilterViewer);
        this.fFilterViewer.setContentProvider((IContentProvider)this.fFilterContentProvider);
        this.fFilterViewer.setInput((Object)this);
        gd = new GridData(1808);
        gd.widthHint = 100;
        this.fFilterViewer.getTable().setLayoutData((Object)gd);
        this.fFilterViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Filter filter = (Filter)event.getElement();
                ExceptionFilterEditor.this.fFilterContentProvider.toggleFilter(filter);
            }
        });
        this.fFilterViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty()) {
                    ExceptionFilterEditor.this.fRemoveFilterButton.setEnabled(false);
                } else {
                    ExceptionFilterEditor.this.fRemoveFilterButton.setEnabled(true);
                }
            }
        });
        this.fFilterViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    ExceptionFilterEditor.this.removeFilters();
                }
            }
        });
        this.createFilterButtons(outer);
    }

    protected void doStore() {
        Object[] filters = this.fFilterContentProvider.getElements(null);
        ArrayList<String> inclusionFilters = new ArrayList<String>(filters.length);
        ArrayList<String> exclusionFilters = new ArrayList<String>(filters.length);
        int i = 0;
        while (i < filters.length) {
            Filter filter = (Filter)filters[i];
            String name = filter.getName();
            if (name.equals(DEFAULT_PACKAGE)) {
                name = "";
            }
            if (filter.isChecked()) {
                inclusionFilters.add(name);
            } else {
                exclusionFilters.add(name);
            }
            ++i;
        }
        try {
            this.fBreakpoint.setInclusionFilters(inclusionFilters.toArray(new String[inclusionFilters.size()]));
            this.fBreakpoint.setExclusionFilters(exclusionFilters.toArray(new String[exclusionFilters.size()]));
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
    }

    private void createFilterButtons(Composite container) {
        Composite buttonContainer = new Composite(container, 0);
        GridData gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)buttonLayout);
        this.fAddFilterButton = new Button(buttonContainer, 8);
        this.fAddFilterButton.setText(PropertyPageMessages.getString("ExceptionFilterEditor.6"));
        this.fAddFilterButton.setToolTipText(PropertyPageMessages.getString("ExceptionFilterEditor.7"));
        gd = new GridData(770);
        this.fAddFilterButton.setLayoutData((Object)gd);
        this.fAddFilterButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent se) {
                ExceptionFilterEditor.this.editFilter();
            }

            public void widgetDefaultSelected(SelectionEvent se) {
            }
        });
        this.fAddTypeButton = new Button(buttonContainer, 8);
        this.fAddTypeButton.setText(PropertyPageMessages.getString("ExceptionFilterEditor.8"));
        this.fAddTypeButton.setToolTipText(PropertyPageMessages.getString("ExceptionFilterEditor.9"));
        gd = this.getButtonGridData(this.fAddTypeButton);
        this.fAddTypeButton.setLayoutData((Object)gd);
        this.fAddTypeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent se) {
                ExceptionFilterEditor.this.addType();
            }

            public void widgetDefaultSelected(SelectionEvent se) {
            }
        });
        this.fAddPackageButton = new Button(buttonContainer, 8);
        this.fAddPackageButton.setText(PropertyPageMessages.getString("ExceptionFilterEditor.10"));
        this.fAddPackageButton.setToolTipText(PropertyPageMessages.getString("ExceptionFilterEditor.11"));
        gd = this.getButtonGridData(this.fAddPackageButton);
        this.fAddPackageButton.setLayoutData((Object)gd);
        this.fAddPackageButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent se) {
                ExceptionFilterEditor.this.addPackage();
            }

            public void widgetDefaultSelected(SelectionEvent se) {
            }
        });
        this.fRemoveFilterButton = new Button(buttonContainer, 8);
        this.fRemoveFilterButton.setText(PropertyPageMessages.getString("ExceptionFilterEditor.12"));
        this.fRemoveFilterButton.setToolTipText(PropertyPageMessages.getString("ExceptionFilterEditor.13"));
        gd = this.getButtonGridData(this.fRemoveFilterButton);
        this.fRemoveFilterButton.setLayoutData((Object)gd);
        this.fRemoveFilterButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent se) {
                ExceptionFilterEditor.this.removeFilters();
            }

            public void widgetDefaultSelected(SelectionEvent se) {
            }
        });
        this.fRemoveFilterButton.setEnabled(false);
    }

    private GridData getButtonGridData(Button button) {
        GridData gd = new GridData(770);
        GC gc = new GC((Drawable)button);
        gc.setFont(button.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        gd.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        gd.heightHint = Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)14);
        return gd;
    }

    private void editFilter() {
        if (this.fEditorText != null) {
            this.validateChangeAndCleanup();
        }
        this.fNewFilter = this.fFilterContentProvider.addFilter("");
        this.fNewTableItem = this.fFilterTable.getItem(0);
        int textStyles = 16388;
        if (!SWT.getPlatform().equals("motif")) {
            textStyles |= 0x800;
        }
        this.fEditorText = new Text((Composite)this.fFilterTable, textStyles);
        GridData gd = new GridData(1808);
        this.fEditorText.setLayoutData((Object)gd);
        this.fTableEditor.horizontalAlignment = 16384;
        this.fTableEditor.grabHorizontal = true;
        this.fTableEditor.setEditor((Control)this.fEditorText, this.fNewTableItem, 0);
        this.fEditorText.setText(this.fNewFilter.getName());
        this.fEditorText.selectAll();
        this.setEditorListeners(this.fEditorText);
        this.fEditorText.setFocus();
    }

    private void setEditorListeners(Text text) {
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.character == '\r') {
                    if (ExceptionFilterEditor.this.fInvalidEditorText != null) {
                        ExceptionFilterEditor.this.fEditorText.setText(ExceptionFilterEditor.this.fInvalidEditorText);
                        ExceptionFilterEditor.this.fInvalidEditorText = null;
                    } else {
                        ExceptionFilterEditor.this.validateChangeAndCleanup();
                    }
                } else if (event.character == '\u001b') {
                    ExceptionFilterEditor.this.removeNewFilter();
                    ExceptionFilterEditor.this.cleanupEditor();
                }
            }
        });
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                if (ExceptionFilterEditor.this.fInvalidEditorText != null) {
                    ExceptionFilterEditor.this.fEditorText.setText(ExceptionFilterEditor.this.fInvalidEditorText);
                    ExceptionFilterEditor.this.fInvalidEditorText = null;
                } else {
                    ExceptionFilterEditor.this.validateChangeAndCleanup();
                }
            }
        });
        text.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
            }
        });
    }

    private void validateChangeAndCleanup() {
        String trimmedValue = this.fEditorText.getText().trim();
        if (trimmedValue.length() < 1) {
            this.removeNewFilter();
        } else {
            if (!this.validateEditorInput(trimmedValue)) {
                this.fInvalidEditorText = trimmedValue;
                this.fEditorText.setText(PropertyPageMessages.getString("ExceptionFilterEditor.14"));
                this.fEditorText.getDisplay().beep();
                return;
            }
            Object[] filters = this.fFilterContentProvider.getElements(null);
            int i = 0;
            while (i < filters.length) {
                Filter filter = (Filter)filters[i];
                if (filter.getName().equals(trimmedValue)) {
                    this.removeNewFilter();
                    this.cleanupEditor();
                    return;
                }
                ++i;
            }
            this.fNewTableItem.setText(trimmedValue);
            this.fNewFilter.setName(trimmedValue);
            this.fFilterViewer.refresh();
        }
        this.cleanupEditor();
    }

    private boolean validateEditorInput(String trimmedValue) {
        char firstChar = trimmedValue.charAt(0);
        if (!Character.isJavaIdentifierStart(firstChar) && firstChar != '*') {
            return false;
        }
        int length = trimmedValue.length();
        int i = 1;
        while (i < length) {
            char c = trimmedValue.charAt(i);
            if (!(Character.isJavaIdentifierPart(c) || c == '.' && i != length - 1 || c == '*' && i == length - 1)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void cleanupEditor() {
        if (this.fEditorText != null) {
            this.fNewFilter = null;
            this.fNewTableItem = null;
            this.fTableEditor.setEditor(null, null, 0);
            this.fEditorText.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ExceptionFilterEditor.this.fEditorText.dispose();
                    ExceptionFilterEditor.this.fEditorText = null;
                }
            });
        }
    }

    private void removeFilters() {
        IStructuredSelection selection = (IStructuredSelection)this.fFilterViewer.getSelection();
        this.fFilterContentProvider.removeFilters(selection.toArray());
    }

    private void removeNewFilter() {
        this.fFilterContentProvider.removeFilters(new Object[]{this.fNewFilter});
    }

    private void addPackage() {
        Shell shell = this.fAddPackageButton.getDisplay().getActiveShell();
        ElementListSelectionDialog dialog = null;
        try {
            dialog = JDIDebugUIPlugin.createAllPackagesDialog(shell, null, false);
        }
        catch (JavaModelException jme) {
            String title = PropertyPageMessages.getString("ExceptionFilterEditor.15");
            String message = PropertyPageMessages.getString("ExceptionFilterEditor.16");
            ExceptionHandler.handle((CoreException)((Object)jme), title, message);
            return;
        }
        if (dialog == null) {
            return;
        }
        dialog.setTitle(PropertyPageMessages.getString("ExceptionFilterEditor.15"));
        dialog.setMessage(PropertyPageMessages.getString("ExceptionFilterEditor.18"));
        dialog.setMultipleSelection(true);
        if (dialog.open() == 1) {
            return;
        }
        Object[] packages = dialog.getResult();
        if (packages != null) {
            int i = 0;
            while (i < packages.length) {
                IJavaElement pkg = (IJavaElement)packages[i];
                String filter = pkg.getElementName();
                filter = filter.length() < 1 ? DEFAULT_PACKAGE : String.valueOf(filter) + ".*";
                Filter f = this.fFilterContentProvider.addFilter(filter);
                this.fFilterContentProvider.checkFilter(f, true);
                ++i;
            }
        }
    }

    private void addType() {
        Shell shell = this.fAddTypeButton.getDisplay().getActiveShell();
        SelectionDialog dialog = null;
        try {
            dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)2, (boolean)false);
        }
        catch (JavaModelException jme) {
            String title = PropertyPageMessages.getString("ExceptionFilterEditor.19");
            String message = PropertyPageMessages.getString("ExceptionFilterEditor.20");
            ExceptionHandler.handle((CoreException)((Object)jme), title, message);
            return;
        }
        dialog.setTitle(PropertyPageMessages.getString("ExceptionFilterEditor.19"));
        dialog.setMessage(PropertyPageMessages.getString("ExceptionFilterEditor.22"));
        if (dialog.open() == 1) {
            return;
        }
        Object[] types = dialog.getResult();
        if (types != null) {
            int i = 0;
            while (i < types.length) {
                IType type = (IType)types[i];
                Filter f = this.fFilterContentProvider.addFilter(type.getFullyQualifiedName());
                this.fFilterContentProvider.checkFilter(f, true);
                ++i;
            }
        }
    }

    protected class FilterContentProvider
    implements IStructuredContentProvider {
        private CheckboxTableViewer fViewer;
        private List fFilters;

        public FilterContentProvider(CheckboxTableViewer viewer) {
            this.fViewer = viewer;
            this.populateFilters();
        }

        protected void populateFilters() {
            String[] iFilters = null;
            String[] eFilters = null;
            try {
                iFilters = ExceptionFilterEditor.this.fBreakpoint.getInclusionFilters();
                eFilters = ExceptionFilterEditor.this.fBreakpoint.getExclusionFilters();
            }
            catch (CoreException ce) {
                JDIDebugUIPlugin.log(ce);
                iFilters = new String[]{};
                eFilters = new String[]{};
            }
            this.fFilters = new ArrayList();
            this.populateFilters(iFilters, true);
            this.populateFilters(eFilters, false);
        }

        protected void populateFilters(String[] filters, boolean checked) {
            int i = 0;
            while (i < filters.length) {
                String name = filters[i];
                if (name.length() == 0) {
                    name = ExceptionFilterEditor.DEFAULT_PACKAGE;
                }
                Filter filter = this.addFilter(name);
                this.checkFilter(filter, checked);
                ++i;
            }
        }

        public Filter addFilter(String name) {
            Filter filter = new Filter(name, false);
            if (!this.fFilters.contains(filter)) {
                this.fFilters.add(filter);
                this.fViewer.add((Object)filter);
            }
            return filter;
        }

        public void removeFilters(Object[] filters) {
            int i = 0;
            while (i < filters.length) {
                Filter filter = (Filter)filters[i];
                this.fFilters.remove(filter);
                ++i;
            }
            this.fViewer.remove(filters);
        }

        public void toggleFilter(Filter filter) {
            boolean newState = !filter.isChecked();
            filter.setChecked(newState);
            this.fViewer.setChecked((Object)filter, newState);
        }

        public void checkFilter(Filter filter, boolean checked) {
            filter.setChecked(checked);
            this.fViewer.setChecked((Object)filter, checked);
        }

        public Object[] getElements(Object inputElement) {
            return this.fFilters.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

