/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.scheduler;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.scheduler.UpdateScheduler;
import org.eclipse.update.internal.ui.wizards.InstallWizard;
import org.eclipse.update.internal.ui.wizards.ResizableInstallWizardDialog;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.search.IUpdateSearchResultCollector;
import org.eclipse.update.search.UpdateSearchRequest;

public class AutomaticUpdatesJob
extends Job {
    public static final Object family = new Object();
    private IUpdateSearchResultCollector resultCollector;
    private static final IStatus OK_STATUS = new Status(0, UpdateScheduler.getPluginId(), 0, "", null);
    private UpdateSearchRequest searchRequest;
    private ArrayList updates = new ArrayList();

    public AutomaticUpdatesJob() {
        super(UpdateScheduler.getString("AutomaticUpdatesJob.AutomaticUpdateSearch"));
        this.setPriority(50);
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public boolean belongsTo(Object family) {
        return AutomaticUpdatesJob.family == family;
    }

    public IStatus run(IProgressMonitor monitor) {
        if (UpdateCore.DEBUG) {
            UpdateCore.debug((String)"Automatic update search started.");
        }
        this.searchRequest = UpdateUtils.createNewUpdatesRequest(null);
        try {
            if (this.resultCollector == null) {
                this.resultCollector = new AutomaticSearchResultCollector();
            }
            this.searchRequest.performSearch(this.resultCollector, monitor);
            if (UpdateCore.DEBUG) {
                UpdateCore.debug((String)("Automatic update search finished - " + this.updates.size() + " results."));
            }
            if (this.updates.size() > 0) {
                boolean download = UpdateCore.getPlugin().getPluginPreferences().getBoolean("download");
                if (download) {
                    if (UpdateCore.DEBUG) {
                        UpdateCore.debug((String)"Automatic download of updates started.");
                    }
                    int i = 0;
                    while (i < this.updates.size()) {
                        IInstallFeatureOperation op = (IInstallFeatureOperation)this.updates.get(i);
                        IFeature feature = op.getFeature();
                        UpdateUtils.downloadFeatureContent((IFeature)feature, (IProgressMonitor)monitor);
                        ++i;
                    }
                    if (UpdateCore.DEBUG) {
                        UpdateCore.debug((String)"Automatic download of updates finished.");
                    }
                }
                if (!InstallWizard.isRunning()) {
                    if (download) {
                        AutomaticUpdatesJob.getStandardDisplay().asyncExec(new Runnable(){

                            public void run() {
                                AutomaticUpdatesJob.this.asyncNotifyDownloadUser();
                            }
                        });
                    } else {
                        AutomaticUpdatesJob.getStandardDisplay().asyncExec(new Runnable(){

                            public void run() {
                                AutomaticUpdatesJob.this.asyncNotifyUser();
                            }
                        });
                    }
                }
                return Job.ASYNC_FINISH;
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return OK_STATUS;
    }

    private void asyncNotifyUser() {
        AutomaticUpdatesJob.getStandardDisplay().beep();
        if (MessageDialog.openQuestion((Shell)UpdateScheduler.getActiveWorkbenchShell(), (String)UpdateScheduler.getString("AutomaticUpdatesJob.EclipseUpdates1"), (String)UpdateScheduler.getString("AutomaticUpdatesJob.UpdatesAvailable"))) {
            BusyIndicator.showWhile((Display)AutomaticUpdatesJob.getStandardDisplay(), (Runnable)new Runnable(){

                public void run() {
                    AutomaticUpdatesJob.this.openInstallWizard();
                }
            });
        }
        this.done(OK_STATUS);
    }

    private void asyncNotifyDownloadUser() {
        AutomaticUpdatesJob.getStandardDisplay().beep();
        if (MessageDialog.openQuestion((Shell)UpdateScheduler.getActiveWorkbenchShell(), (String)UpdateScheduler.getString("AutomaticUpdatesJob.EclipseUpdates2"), (String)UpdateScheduler.getString("AutomaticUpdatesJob.UpdatesDownloaded"))) {
            BusyIndicator.showWhile((Display)AutomaticUpdatesJob.getStandardDisplay(), (Runnable)new Runnable(){

                public void run() {
                    AutomaticUpdatesJob.this.openInstallWizard();
                }
            });
        }
        this.done(OK_STATUS);
    }

    private void openInstallWizard() {
        if (InstallWizard.isRunning()) {
            return;
        }
        InstallWizard wizard = new InstallWizard(this.searchRequest, this.updates);
        ResizableInstallWizardDialog dialog = new ResizableInstallWizardDialog(UpdateScheduler.getActiveWorkbenchShell(), (IWizard)wizard, UpdateScheduler.getString("AutomaticUpdatesJob.Updates"));
        dialog.create();
        dialog.open();
    }

    private class AutomaticSearchResultCollector
    implements IUpdateSearchResultCollector {
        AutomaticSearchResultCollector() {
        }

        public void accept(IFeature feature) {
            IInstallFeatureOperation operation = OperationsManager.getOperationFactory().createInstallOperation(null, feature, null, null, null);
            AutomaticUpdatesJob.this.updates.add(operation);
        }
    }
}

