/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.tasks;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class IdReplaceTask
extends Task {
    private static final String FEATURE = "feature";
    private static final String ID = "id";
    private static final String VERSION = "version";
    private static final String COMMA = ",";
    private static final String BACKSLASH = "\"";
    private static final String EMPTY = "";
    private static final String PLUGIN = "plugin";
    private static final String INCLUDES = "includes";
    private String featureFilePath;
    private Map pluginIds = new HashMap(10);
    private Map featureIds = new HashMap(4);
    private String selfVersion;
    private static final String GENERIC_VERSION_NUMBER = "0.0.0";
    private static final String DOT_QUALIFIER = ".qualifier";

    public void setFeatureFilePath(String path) {
        this.featureFilePath = path;
    }

    public void setSelfVersion(String version) {
        this.selfVersion = version;
    }

    public void setPluginIds(String values) {
        this.pluginIds = new HashMap(10);
        StringTokenizer tokens = new StringTokenizer(values, COMMA);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            String id = EMPTY;
            if (!token.equals(EMPTY)) {
                id = token;
            }
            String version = EMPTY;
            token = tokens.nextToken().trim();
            if (!token.equals(EMPTY)) {
                version = token;
            }
            this.pluginIds.put(id, version);
        }
    }

    public void setFeatureIds(String values) {
        this.featureIds = new HashMap(10);
        StringTokenizer tokens = new StringTokenizer(values, COMMA);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            String id = EMPTY;
            if (!token.equals(EMPTY)) {
                id = token;
            }
            String version = EMPTY;
            token = tokens.nextToken().trim();
            if (!token.equals(EMPTY)) {
                version = token;
            }
            this.featureIds.put(id, version);
        }
    }

    public void execute() {
        int startVersionWord;
        StringBuffer buffer = null;
        try {
            buffer = this.readFile(new File(this.featureFilePath));
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        int startFeature = this.scan(buffer, 0, FEATURE);
        if (startFeature == -1) {
            return;
        }
        int endFeature = this.scan(buffer, startFeature + 1, ">");
        if (this.selfVersion != null && (startVersionWord = this.scan(buffer, startFeature + 1, VERSION)) < endFeature) {
            int startVersionId = this.scan(buffer, startVersionWord + 1, BACKSLASH);
            int endVersionId = this.scan(buffer, startVersionId + 1, BACKSLASH);
            buffer.replace(startVersionId + 1, endVersionId, this.selfVersion);
        }
        int startElement = endFeature;
        int startId = 0;
        while (true) {
            int startPlugin = this.scan(buffer, startElement + 1, PLUGIN);
            int startInclude = this.scan(buffer, startElement + 1, INCLUDES);
            if (startPlugin == -1 && startInclude == -1) break;
            int foundElement = -1;
            boolean isPlugin = false;
            if (startPlugin == -1 || startInclude == -1) {
                foundElement = startPlugin != -1 ? startPlugin : startInclude;
                isPlugin = startPlugin != -1;
            } else if (startPlugin < startInclude) {
                foundElement = startPlugin;
                isPlugin = true;
            } else {
                foundElement = startInclude;
                isPlugin = false;
            }
            startId = this.scan(buffer, foundElement, ID);
            if (startId == -1) break;
            int startElementId = this.scan(buffer, startId + 1, BACKSLASH);
            int endElementId = this.scan(buffer, startElementId + 1, BACKSLASH);
            char[] elementId = new char[endElementId - startElementId - 1];
            buffer.getChars(startElementId + 1, endElementId, elementId, 0);
            int startVersionWord2 = this.scan(buffer, endElementId + 1, VERSION);
            int startVersionId = this.scan(buffer, startVersionWord2 + 1, BACKSLASH);
            int endVersionId = this.scan(buffer, startVersionId + 1, BACKSLASH);
            char[] versionId = new char[endVersionId - startVersionId - 1];
            buffer.getChars(startVersionId + 1, endVersionId, versionId, 0);
            if (!new String(versionId).equals(GENERIC_VERSION_NUMBER) && !new String(versionId).endsWith(DOT_QUALIFIER)) {
                startElement = startVersionId;
                continue;
            }
            ++startVersionId;
            String replacementVersion = null;
            replacementVersion = isPlugin ? (String)this.pluginIds.get(new String(elementId)) : (String)this.featureIds.get(new String(elementId));
            if (replacementVersion == null) {
                System.err.println("Could not find" + new String(elementId));
            } else {
                buffer.replace(startVersionId, endVersionId, replacementVersion);
            }
            startElement = startVersionId;
        }
        try {
            IdReplaceTask.transferStreams(new ByteArrayInputStream(buffer.toString().getBytes()), new FileOutputStream(this.featureFilePath));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private int scan(StringBuffer buf, int start, String targetName) {
        return this.scan(buf, start, new String[]{targetName});
    }

    private int scan(StringBuffer buf, int start, String[] targets) {
        int i = start;
        while (i < buf.length()) {
            int j = 0;
            while (j < targets.length) {
                String match;
                if (i < buf.length() - targets[j].length() && targets[j].equals(match = buf.substring(i, i + targets[j].length()))) {
                    return i;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StringBuffer readFile(File targetName) throws IOException {
        InputStreamReader reader = new InputStreamReader(new BufferedInputStream(new FileInputStream(targetName)));
        StringBuffer result = new StringBuffer();
        char[] buf = new char[4096];
        try {
            int count = reader.read(buf, 0, buf.length);
            while (count != -1) {
                result.append(buf, 0, count);
                count = reader.read(buf, 0, buf.length);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (IOException iOException) {
            return result;
        }
        reader.close();
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void transferStreams(InputStream source, OutputStream destination) throws IOException {
        source = new BufferedInputStream(source);
        destination = new BufferedOutputStream(destination);
        try {
            byte[] buffer = new byte[8192];
            while (true) {
                int bytesRead = -1;
                bytesRead = source.read(buffer);
                if (bytesRead != -1) {
                    destination.write(buffer, 0, bytesRead);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                source.close();
            }
            catch (IOException iOException) {}
            try {
                destination.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (IOException iOException) {}
        source.close();
        try {}
        catch (IOException iOException) {
            return;
        }
        destination.close();
    }
}

