/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.packager;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Utils;

public class UnzipperGenerator
extends AbstractScriptGenerator {
    private String directoryLocation = "packager.directory.txt";
    private Properties zipsList;
    private Config configInfo;
    private String packagingPropertiesLocation;
    private String[] unzipOrder = new String[0];

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate() throws CoreException {
        this.prepareGeneration();
        this.openScript(AbstractScriptGenerator.workingDirectory, "unzipper.xml");
        try {
            this.generatePrologue();
            this.generateUncompressionCommands();
            this.generateEpilogue();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.closeScript();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.closeScript();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void prepareGeneration() {
        if (this.packagingPropertiesLocation == null) {
            return;
        }
        Properties packagingProperties = new Properties();
        BufferedInputStream propertyStream = null;
        try {
            propertyStream = new BufferedInputStream(new FileInputStream(this.packagingPropertiesLocation));
            try {
                packagingProperties.load(new BufferedInputStream(propertyStream));
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                ((InputStream)propertyStream).close();
                throw throwable;
            }
            {
                Object var3_5 = null;
                ((InputStream)propertyStream).close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
        this.unzipOrder = Utils.getArrayFromStringWithBlank(packagingProperties.getProperty("unzipOrder", ""), ",");
    }

    private void generateEpilogue() {
        this.script.printTargetEnd();
        this.script.println();
        this.script.printProjectEnd();
    }

    private void generatePrologue() {
        this.script.println();
        this.configInfo = (Config)AbstractScriptGenerator.getConfigInfos().get(0);
        this.script.printComment("Unzip script for " + this.configInfo.toString("."));
        this.script.println();
        this.script.printProjectDeclaration("Unzipper", "main", ".");
        this.script.printTargetDeclaration("main", null, null, null, null);
    }

    private void generateUncompressionCommands() throws CoreException {
        this.zipsList = AbstractScriptGenerator.readProperties(AbstractScriptGenerator.workingDirectory, this.directoryLocation, 4);
        ArrayList<String[]> toUnzipWithOrder = new ArrayList<String[]>(this.unzipOrder.length);
        String zipEntries = this.zipsList.getProperty(Config.genericConfig().toString(","), "");
        if (!this.configInfo.equals(Config.genericConfig())) {
            zipEntries = String.valueOf(zipEntries) + (zipEntries.length() == 0 ? "" : " & ") + this.zipsList.getProperty(this.configInfo.toString(","), "");
        }
        String[] allZipEntries = Utils.getArrayFromString(zipEntries, "&");
        int i = 0;
        while (i < allZipEntries.length) {
            String[] entryDetail = Utils.getArrayFromString(allZipEntries[i], ",");
            if (!entryDetail[1].equals(".")) {
                this.script.printMkdirTask("${tempDirectory}/" + entryDetail[1]);
            }
            if (this.delayed(entryDetail[0])) {
                toUnzipWithOrder.add(entryDetail);
            } else {
                this.generateUncompress(entryDetail);
            }
            ++i;
        }
        i = 0;
        while (i < this.unzipOrder.length) {
            Iterator iter = toUnzipWithOrder.iterator();
            while (iter.hasNext()) {
                String[] entry = (String[])iter.next();
                if (!entry[0].startsWith(this.unzipOrder[i])) continue;
                this.generateUncompress(entry);
                iter.remove();
            }
            ++i;
        }
    }

    private void generateUncompress(String[] entryDetail) {
        if (entryDetail[0].endsWith(".zip")) {
            this.generateUnzip(entryDetail);
            return;
        }
        if (entryDetail[0].endsWith(".tar.gz") || entryDetail[0].endsWith(".tar")) {
            this.generateUntar(entryDetail);
        }
    }

    private boolean delayed(String fileName) {
        int i = 0;
        while (i < this.unzipOrder.length) {
            if (fileName.startsWith(this.unzipOrder[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void generateUnzip(String[] entryDetail) {
        ArrayList<String> parameters = new ArrayList<String>(1);
        parameters.add("-o -X ${unzipArgs} ");
        parameters.add(String.valueOf(this.getPropertyFormat("downloadDirectory")) + '/' + entryDetail[0]);
        this.script.printExecTask("unzip", "${tempDirectory}/" + entryDetail[1], parameters, null);
    }

    private void generateUntar(String[] entryDetail) {
        ArrayList<String> parameters = new ArrayList<String>(2);
        parameters.add("-" + (entryDetail[0].endsWith(".gz") ? "z" : "") + "pxvf");
        parameters.add(String.valueOf(this.getPropertyFormat("downloadDirectory")) + '/' + entryDetail[0]);
        this.script.printExecTask("tar", "${tempDirectory}/" + entryDetail[1], parameters, null);
    }

    public void setDirectoryLocation(String filename) {
        this.directoryLocation = filename;
    }

    public void setPropertyFile(String propertyFile) {
        this.packagingPropertiesLocation = propertyFile;
    }
}

