/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jface.text.Region;

public class ImportReferencesCollector
extends GenericVisitor {
    private Region fSubRange;
    private Collection fResult;

    public ImportReferencesCollector(Region rangeLimit, Collection result) {
        super(true);
        this.fResult = result;
        this.fSubRange = rangeLimit;
    }

    private boolean isAffected(ASTNode node) {
        if (this.fSubRange == null) {
            return true;
        }
        int nodeStart = node.getStartPosition();
        return nodeStart + node.getLength() > this.fSubRange.getOffset() && this.fSubRange.getOffset() + this.fSubRange.getLength() > nodeStart;
    }

    private void addReference(SimpleName name) {
        if (this.isAffected((ASTNode)name)) {
            this.fResult.add(name);
        }
    }

    private void typeRefFound(Name node) {
        if (node != null) {
            while (node.isQualifiedName()) {
                node = ((QualifiedName)node).getQualifier();
            }
            this.addReference((SimpleName)node);
        }
    }

    private void possibleTypeRefFound(Name node) {
        while (node.isQualifiedName()) {
            node = ((QualifiedName)node).getQualifier();
        }
        IBinding binding = node.resolveBinding();
        if (binding == null || binding.getKind() == 2) {
            this.addReference((SimpleName)node);
        }
    }

    private void doVisitChildren(List elements) {
        int nElements = elements.size();
        int i = 0;
        while (i < nElements) {
            ((ASTNode)elements.get(i)).accept((ASTVisitor)this);
            ++i;
        }
    }

    private void doVisitNode(ASTNode node) {
        if (node != null) {
            node.accept((ASTVisitor)this);
        }
    }

    protected boolean visitNode(ASTNode node) {
        return this.isAffected(node);
    }

    public boolean visit(ArrayType node) {
        this.doVisitNode((ASTNode)node.getElementType());
        return false;
    }

    public boolean visit(SimpleType node) {
        this.typeRefFound(node.getName());
        return false;
    }

    public boolean visit(QualifiedName node) {
        this.possibleTypeRefFound((Name)node);
        return false;
    }

    public boolean visit(ImportDeclaration node) {
        return false;
    }

    public boolean visit(PackageDeclaration node) {
        return false;
    }

    public boolean visit(ThisExpression node) {
        this.typeRefFound(node.getQualifier());
        return false;
    }

    private void evalQualifyingExpression(Expression expr) {
        if (expr != null) {
            if (expr instanceof Name) {
                this.possibleTypeRefFound((Name)expr);
            } else {
                expr.accept((ASTVisitor)this);
            }
        }
    }

    public boolean visit(ClassInstanceCreation node) {
        this.typeRefFound(node.getName());
        this.evalQualifyingExpression(node.getExpression());
        if (node.getAnonymousClassDeclaration() != null) {
            node.getAnonymousClassDeclaration().accept((ASTVisitor)this);
        }
        this.doVisitChildren(node.arguments());
        return false;
    }

    public boolean visit(MethodInvocation node) {
        this.evalQualifyingExpression(node.getExpression());
        this.doVisitChildren(node.arguments());
        return false;
    }

    public boolean visit(SuperConstructorInvocation node) {
        if (!this.isAffected((ASTNode)node)) {
            return false;
        }
        this.evalQualifyingExpression(node.getExpression());
        this.doVisitChildren(node.arguments());
        return false;
    }

    public boolean visit(FieldAccess node) {
        this.evalQualifyingExpression(node.getExpression());
        return false;
    }

    public boolean visit(SimpleName node) {
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        if (!this.isAffected((ASTNode)node)) {
            return false;
        }
        this.doVisitNode((ASTNode)node.getJavadoc());
        this.typeRefFound(node.getSuperclass());
        Iterator iter = node.superInterfaces().iterator();
        while (iter.hasNext()) {
            this.typeRefFound((Name)iter.next());
        }
        this.doVisitChildren(node.bodyDeclarations());
        return false;
    }

    public boolean visit(MethodDeclaration node) {
        if (!this.isAffected((ASTNode)node)) {
            return false;
        }
        this.doVisitNode((ASTNode)node.getJavadoc());
        if (!node.isConstructor()) {
            this.doVisitNode((ASTNode)node.getReturnType());
        }
        this.doVisitChildren(node.parameters());
        Iterator iter = node.thrownExceptions().iterator();
        while (iter.hasNext()) {
            this.typeRefFound((Name)iter.next());
        }
        this.doVisitNode((ASTNode)node.getBody());
        return false;
    }

    public boolean visit(TagElement node) {
        Object first;
        String name = node.getTagName();
        List list = node.fragments();
        int idx = 0;
        if (name != null && !list.isEmpty() && (first = list.get(0)) instanceof Name) {
            if ("@throws".equals(name) || "@exception".equals(name)) {
                this.typeRefFound((Name)first);
            } else if ("@see".equals(name) || "@link".equals(name) || "@linkplain".equals(name)) {
                this.possibleTypeRefFound((Name)first);
            }
            ++idx;
        }
        int i = idx;
        while (i < list.size()) {
            this.doVisitNode((ASTNode)list.get(i));
            ++i;
        }
        return false;
    }

    public boolean visit(MemberRef node) {
        Name name = node.getQualifier();
        if (name != null) {
            this.typeRefFound(name);
        }
        return false;
    }

    public boolean visit(MethodRef node) {
        List list;
        Name qualifier = node.getQualifier();
        if (qualifier != null) {
            this.typeRefFound(qualifier);
        }
        if ((list = node.parameters()) != null) {
            this.doVisitChildren(list);
        }
        return false;
    }
}

