/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.text.Collator;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.util.CompilationUnitSorter;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.MembersOrderPreferenceCache;

public class SortMembersOperation
implements IWorkspaceRunnable {
    private ICompilationUnit fCompilationUnit;
    private int[] fPositions;

    public SortMembersOperation(ICompilationUnit cu, int[] positions) {
        this.fCompilationUnit = cu;
        this.fPositions = positions;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        CompilationUnitSorter.sort((ICompilationUnit)this.fCompilationUnit, (int[])this.fPositions, (Comparator)new DefaultJavaElementComparator(), (int)0, (IProgressMonitor)monitor);
    }

    public ISchedulingRule getScheduleRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public class DefaultJavaElementComparator
    implements Comparator {
        private Collator fCollator = Collator.getInstance();
        private MembersOrderPreferenceCache fMemberOrderCache = JavaPlugin.getDefault().getMemberOrderPreferenceCache();

        private int category(BodyDeclaration bodyDeclaration) {
            switch (bodyDeclaration.getNodeType()) {
                case 31: {
                    MethodDeclaration method = (MethodDeclaration)bodyDeclaration;
                    if (method.isConstructor()) {
                        return this.getMemberCategory(1);
                    }
                    int flags = method.getModifiers();
                    if (Modifier.isStatic((int)flags)) {
                        return this.getMemberCategory(7);
                    }
                    return this.getMemberCategory(2);
                }
                case 23: {
                    int flags = ((FieldDeclaration)bodyDeclaration).getModifiers();
                    if (Modifier.isStatic((int)flags)) {
                        return this.getMemberCategory(5);
                    }
                    return this.getMemberCategory(3);
                }
                case 28: {
                    int flags = ((Initializer)bodyDeclaration).getModifiers();
                    if (Modifier.isStatic((int)flags)) {
                        return this.getMemberCategory(6);
                    }
                    return this.getMemberCategory(4);
                }
                case 55: {
                    return this.getMemberCategory(0);
                }
            }
            return 0;
        }

        private int getMemberCategory(int kind) {
            return this.fMemberOrderCache.getCategoryIndex(kind);
        }

        public int compare(Object e1, Object e2) {
            int vis;
            int cat2;
            BodyDeclaration bodyDeclaration1 = (BodyDeclaration)e1;
            BodyDeclaration bodyDeclaration2 = (BodyDeclaration)e2;
            int cat1 = this.category(bodyDeclaration1);
            if (cat1 != (cat2 = this.category(bodyDeclaration2))) {
                return cat1 - cat2;
            }
            if (this.fMemberOrderCache.isSortByVisibility()) {
                int flags1 = JdtFlags.getVisibilityCode(bodyDeclaration1);
                int flags2 = JdtFlags.getVisibilityCode(bodyDeclaration2);
                vis = this.fMemberOrderCache.getVisibilityIndex(flags1) - this.fMemberOrderCache.getVisibilityIndex(flags2);
                if (vis != 0) {
                    return vis;
                }
            }
            switch (bodyDeclaration1.getNodeType()) {
                case 31: {
                    String name2;
                    MethodDeclaration method1 = (MethodDeclaration)bodyDeclaration1;
                    MethodDeclaration method2 = (MethodDeclaration)bodyDeclaration2;
                    if (this.fMemberOrderCache.isSortByVisibility() && (vis = this.fMemberOrderCache.getVisibilityIndex(method1.getModifiers()) - this.fMemberOrderCache.getVisibilityIndex(method2.getModifiers())) != 0) {
                        return vis;
                    }
                    String name1 = method1.getName().getIdentifier();
                    int cmp = this.fCollator.compare(name1, name2 = method2.getName().getIdentifier());
                    if (cmp != 0) {
                        return cmp;
                    }
                    List parameters1 = method1.parameters();
                    List parameters2 = method2.parameters();
                    int length1 = parameters1.size();
                    int length2 = parameters2.size();
                    int len = Math.min(length1, length2);
                    int i = 0;
                    while (i < len) {
                        SingleVariableDeclaration param1 = (SingleVariableDeclaration)parameters1.get(i);
                        SingleVariableDeclaration param2 = (SingleVariableDeclaration)parameters2.get(i);
                        cmp = this.fCollator.compare(this.buildSignature(param1.getType()), this.buildSignature(param2.getType()));
                        if (cmp != 0) {
                            return cmp;
                        }
                        ++i;
                    }
                    if (length1 != length2) {
                        return length1 - length2;
                    }
                    int value1 = (Integer)bodyDeclaration1.getProperty("relativeOrder");
                    int value2 = (Integer)bodyDeclaration2.getProperty("relativeOrder");
                    return value1 - value2;
                }
                case 23: {
                    FieldDeclaration field1 = (FieldDeclaration)bodyDeclaration1;
                    FieldDeclaration field2 = (FieldDeclaration)bodyDeclaration2;
                    String name1 = ((VariableDeclarationFragment)field1.fragments().get(0)).getName().getIdentifier();
                    String name2 = ((VariableDeclarationFragment)field2.fragments().get(0)).getName().getIdentifier();
                    int cmp = this.fCollator.compare(name1, name2);
                    if (cmp != 0) {
                        return cmp;
                    }
                    int value1 = (Integer)bodyDeclaration1.getProperty("relativeOrder");
                    int value2 = (Integer)bodyDeclaration2.getProperty("relativeOrder");
                    return value1 - value2;
                }
                case 28: {
                    int value1 = (Integer)bodyDeclaration1.getProperty("relativeOrder");
                    int value2 = (Integer)bodyDeclaration2.getProperty("relativeOrder");
                    return value1 - value2;
                }
                case 55: {
                    TypeDeclaration type1 = (TypeDeclaration)bodyDeclaration1;
                    TypeDeclaration type2 = (TypeDeclaration)bodyDeclaration2;
                    String name1 = type1.getName().getIdentifier();
                    String name2 = type2.getName().getIdentifier();
                    int cmp = this.fCollator.compare(name1, name2);
                    if (cmp != 0) {
                        return cmp;
                    }
                    int value1 = (Integer)bodyDeclaration1.getProperty("relativeOrder");
                    int value2 = (Integer)bodyDeclaration2.getProperty("relativeOrder");
                    return value1 - value2;
                }
            }
            return 0;
        }

        private String buildSignature(Type type) {
            switch (type.getNodeType()) {
                case 39: {
                    PrimitiveType.Code code = ((PrimitiveType)type).getPrimitiveTypeCode();
                    return code.toString();
                }
                case 5: {
                    ArrayType arrayType = (ArrayType)type;
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(this.buildSignature(arrayType.getElementType()));
                    int dimensions = arrayType.getDimensions();
                    int j = 0;
                    while (j < dimensions) {
                        buffer.append("[]");
                        ++j;
                    }
                    return buffer.toString();
                }
                case 43: {
                    SimpleType simpleType = (SimpleType)type;
                    return this.buildSignature(simpleType.getName());
                }
            }
            return null;
        }

        private String buildSignature(Name name) {
            if (name.isSimpleName()) {
                return ((SimpleName)name).getIdentifier();
            }
            QualifiedName qualifiedName = (QualifiedName)name;
            return String.valueOf(this.buildSignature(qualifiedName.getQualifier())) + '.' + this.buildSignature((Name)qualifiedName.getName());
        }
    }
}

