/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.nls.AccessorClassInfo;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSMessages;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class NLSSourceModifier {
    private final String fSubstitutionPattern;

    private NLSSourceModifier(String substitutionPattern) {
        this.fSubstitutionPattern = substitutionPattern;
    }

    public static Change create(ICompilationUnit cu, NLSSubstitution[] subs, String substitutionPattern, IPackageFragment accessorPackage, String accessorClassName) throws CoreException {
        NLSSourceModifier sourceModification = new NLSSourceModifier(substitutionPattern);
        String message = NLSMessages.getFormattedString("NLSSourceModifier.change.description", cu.getElementName());
        CompilationUnitChange change = new CompilationUnitChange(message, cu);
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        change.setEdit((TextEdit)multiTextEdit);
        accessorClassName = sourceModification.createImportForAccessor(multiTextEdit, accessorClassName, accessorPackage, cu);
        int i = 0;
        while (i < subs.length) {
            NLSSubstitution substitution = subs[i];
            int newState = substitution.getState();
            if (substitution.hasStateChanged()) {
                if (newState == 0) {
                    if (substitution.getInitialState() == 2) {
                        sourceModification.addNLS(substitution, (TextChange)change, accessorClassName);
                    } else if (substitution.getInitialState() == 1) {
                        sourceModification.addAccessor(substitution, (TextChange)change, accessorClassName);
                    }
                } else if (newState == 2) {
                    if (substitution.getInitialState() == 1) {
                        sourceModification.deleteTag(substitution, (TextChange)change);
                        if (substitution.isValueRename()) {
                            sourceModification.replaceValue(substitution, (TextChange)change);
                        }
                    } else if (substitution.getInitialState() == 0) {
                        sourceModification.deleteAccessor(substitution, (TextChange)change);
                        sourceModification.deleteTag(substitution, (TextChange)change);
                    }
                } else if (newState == 1) {
                    if (substitution.getInitialState() == 2) {
                        sourceModification.addNLS(substitution, (TextChange)change, accessorClassName);
                        if (substitution.isValueRename()) {
                            sourceModification.replaceValue(substitution, (TextChange)change);
                        }
                    } else if (substitution.getInitialState() == 0) {
                        sourceModification.deleteAccessor(substitution, (TextChange)change);
                    }
                }
            } else if (newState == 0) {
                if (substitution.isKeyRename()) {
                    sourceModification.replaceKey(substitution, (TextChange)change);
                }
                if (substitution.isAccessorRename()) {
                    sourceModification.replaceAccessor(substitution, (TextChange)change);
                }
            } else if (substitution.isValueRename()) {
                sourceModification.replaceValue(substitution, (TextChange)change);
            }
            ++i;
        }
        return change;
    }

    private void replaceAccessor(NLSSubstitution substitution, TextChange change) {
        AccessorClassInfo accessorClassInfo = substitution.getAccessorClassInfo();
        if (accessorClassInfo != null) {
            Region region = accessorClassInfo.getRegion();
            int len = accessorClassInfo.getName().length();
            String[] args = new String[]{accessorClassInfo.getName(), substitution.getUpdatedAccessor()};
            TextChangeCompatibility.addTextEdit(change, NLSMessages.getFormattedString("NLSSourceModifier.replace_accessor", args), (TextEdit)new ReplaceEdit(region.getOffset(), len, substitution.getUpdatedAccessor()));
        }
    }

    private void replaceKey(NLSSubstitution substitution, TextChange change) {
        Region region = substitution.getNLSElement().getPosition();
        String[] args = new String[]{substitution.getInitialKey(), substitution.getKey()};
        TextChangeCompatibility.addTextEdit(change, NLSMessages.getFormattedString("NLSSourceModifier.replace_key", args), (TextEdit)new ReplaceEdit(region.getOffset(), region.getLength(), String.valueOf('\"') + this.unwindEscapeChars(substitution.getKey()) + '\"'));
    }

    private void replaceValue(NLSSubstitution substitution, TextChange change) {
        Region region = substitution.getNLSElement().getPosition();
        String[] args = new String[]{substitution.getInitialValue(), substitution.getValueNonEmpty()};
        TextChangeCompatibility.addTextEdit(change, NLSMessages.getFormattedString("NLSSourceModifier.replace_value", args), (TextEdit)new ReplaceEdit(region.getOffset(), region.getLength(), String.valueOf('\"') + this.unwindEscapeChars(substitution.getValueNonEmpty()) + '\"'));
    }

    private void deleteAccessor(NLSSubstitution substitution, TextChange change) {
        AccessorClassInfo accessorClassInfo = substitution.getAccessorClassInfo();
        if (accessorClassInfo != null) {
            Region region = accessorClassInfo.getRegion();
            TextChangeCompatibility.addTextEdit(change, NLSMessages.getFormattedString("NLSSourceModifier.remove_accessor", accessorClassInfo.getName()), (TextEdit)new ReplaceEdit(region.getOffset(), region.getLength(), String.valueOf('\"') + this.unwindEscapeChars(substitution.getValueNonEmpty()) + '\"'));
        }
    }

    private String unwindEscapeChars(String s) {
        StringBuffer sb = new StringBuffer(s.length());
        int length = s.length();
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            sb.append(this.getUnwoundString(c));
            ++i;
        }
        return sb.toString();
    }

    private String getUnwoundString(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return String.valueOf(c);
    }

    private void deleteTag(NLSSubstitution substitution, TextChange change) {
        Region textRegion = substitution.getNLSElement().getTagPosition();
        TextChangeCompatibility.addTextEdit(change, NLSMessages.getString("NLSSourceModifier.remove_tag"), (TextEdit)new DeleteEdit(textRegion.getOffset(), textRegion.getLength()));
    }

    private String createImportForAccessor(MultiTextEdit parent, String accessorClassName, IPackageFragment accessorPackage, ICompilationUnit cu) throws CoreException {
        String string;
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = cu.getPath();
        try {
            manager.connect(path, null);
            IType type = accessorPackage.getCompilationUnit(String.valueOf(accessorClassName) + ".java").getType(accessorClassName);
            String fullyQualifiedName = type.getFullyQualifiedName();
            ImportRewrite importRewrite = new ImportRewrite(cu);
            String nameToUse = importRewrite.addImport(fullyQualifiedName);
            TextEdit edit = importRewrite.createEdit(manager.getTextFileBuffer(path).getDocument());
            parent.addChild(edit);
            string = nameToUse;
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            manager.disconnect(path, null);
            throw throwable;
        }
        manager.disconnect(path, null);
        return string;
    }

    private void addNLS(NLSSubstitution sub, TextChange change, String accessorName) {
        if (sub.getState() == 2) {
            return;
        }
        NLSElement element = sub.getNLSElement();
        this.addAccessor(sub, change, accessorName);
        String arg = sub.getState() == 0 ? sub.getKey() : sub.getValueNonEmpty();
        String name = NLSMessages.getFormattedString("NLSSourceModifier.add_tag", arg);
        TextChangeCompatibility.addTextEdit(change, name, this.createAddTagChange(element));
    }

    private void addAccessor(NLSSubstitution sub, TextChange change, String accessorName) {
        if (sub.getState() == 0) {
            NLSElement element = sub.getNLSElement();
            Region position = element.getPosition();
            String[] args = new String[]{sub.getValueNonEmpty(), sub.getKey()};
            String text = NLSMessages.getFormattedString("NLSSourceModifier.externalize", args);
            String resourceGetter = this.createResourceGetter(sub.getKey(), accessorName);
            TextChangeCompatibility.addTextEdit(change, text, (TextEdit)new ReplaceEdit(position.getOffset(), position.getLength(), resourceGetter));
        }
    }

    private TextEdit createAddTagChange(NLSElement element) {
        int offset = element.getTagPosition().getOffset();
        String text = String.valueOf(' ') + element.getTagText();
        return new InsertEdit(offset, text);
    }

    private String createResourceGetter(String key, String accessorName) {
        StringBuffer buf = new StringBuffer();
        buf.append(accessorName);
        buf.append('.');
        int i = this.fSubstitutionPattern.indexOf("${key}");
        if (i != -1) {
            buf.append(this.fSubstitutionPattern.substring(0, i));
            buf.append('\"').append(key).append('\"');
            buf.append(this.fSubstitutionPattern.substring(i + "${key}".length()));
        }
        return buf.toString();
    }
}

