/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.sef;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.dom.OldASTRewrite;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.sef.AccessAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class SelfEncapsulateFieldRefactoring
extends Refactoring {
    private IField fField;
    private TextChangeManager fChangeManager;
    private CompilationUnit fRoot;
    private VariableDeclarationFragment fFieldDeclaration;
    private OldASTRewrite fRewriter;
    private int fVisibility;
    private String fGetterName;
    private String fSetterName;
    private String fArgName;
    private boolean fSetterMustReturnValue;
    private int fInsertionIndex;
    private boolean fEncapsulateDeclaringClass;
    private boolean fGenerateJavadoc;
    private List fUsedReadNames;
    private List fUsedModifyNames;
    private static final String NO_NAME = "";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    private SelfEncapsulateFieldRefactoring(IField field) throws JavaModelException {
        Assert.isNotNull(field);
        this.fField = field;
        this.fChangeManager = new TextChangeManager();
        this.fGetterName = GetterSetterUtil.getGetterName(field, null);
        this.fSetterName = GetterSetterUtil.getSetterName(field, null);
        this.fEncapsulateDeclaringClass = true;
        this.fArgName = NamingConventions.removePrefixAndSuffixForFieldName((IJavaProject)field.getJavaProject(), (String)field.getElementName(), (int)field.getFlags());
        this.checkArgName();
    }

    public static boolean isAvailable(IField field) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)field);
    }

    public static SelfEncapsulateFieldRefactoring create(IField field) throws JavaModelException {
        if (Checks.checkAvailability((IJavaElement)field).hasFatalError()) {
            return null;
        }
        return new SelfEncapsulateFieldRefactoring(field);
    }

    public IField getField() {
        return this.fField;
    }

    public String getGetterName() {
        return this.fGetterName;
    }

    public void setGetterName(String name) {
        this.fGetterName = name;
        Assert.isNotNull(this.fGetterName);
    }

    public String getSetterName() {
        return this.fSetterName;
    }

    public void setSetterName(String name) {
        this.fSetterName = name;
        Assert.isNotNull(this.fSetterName);
    }

    public void setInsertionIndex(int index) {
        this.fInsertionIndex = index;
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public void setVisibility(int visibility) {
        this.fVisibility = visibility;
    }

    public void setEncapsulateDeclaringClass(boolean encapsulateDeclaringClass) {
        this.fEncapsulateDeclaringClass = encapsulateDeclaringClass;
    }

    public boolean getEncapsulateDeclaringClass() {
        return this.fEncapsulateDeclaringClass;
    }

    public boolean getGenerateJavadoc() {
        return this.fGenerateJavadoc;
    }

    public void setGenerateJavadoc(boolean value) {
        this.fGenerateJavadoc = value;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        this.fVisibility = this.fField.getFlags() & 7;
        RefactoringStatus result = new RefactoringStatus();
        this.fRoot = new RefactoringASTParser(2).parse(this.fField.getCompilationUnit(), true, pm);
        ISourceRange sourceRange = this.fField.getNameRange();
        ASTNode node = NodeFinder.perform((ASTNode)this.fRoot, sourceRange.getOffset(), sourceRange.getLength());
        if (node == null) {
            return this.mappingErrorFound(result, node);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.VariableDeclarationFragment");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fFieldDeclaration = (VariableDeclarationFragment)ASTNodes.getParent(node, clazz);
        if (this.fFieldDeclaration == null) {
            return this.mappingErrorFound(result, node);
        }
        if (this.fFieldDeclaration.resolveBinding() == null) {
            if (!this.processCompilerError(result, node)) {
                result.addFatalError(RefactoringCoreMessages.getString("SelfEncapsulateField.type_not_resolveable"));
            }
            return result;
        }
        this.computeUsedNames();
        this.fRewriter = new OldASTRewrite((ASTNode)this.fRoot);
        return result;
    }

    private RefactoringStatus mappingErrorFound(RefactoringStatus result, ASTNode node) {
        if (node != null && (node.getFlags() & 1) != 0 && this.processCompilerError(result, node)) {
            return result;
        }
        result.addFatalError(this.getMappingErrorMessage());
        return result;
    }

    private boolean processCompilerError(RefactoringStatus result, ASTNode node) {
        Message[] messages = ASTNodes.getMessages(node, 2);
        if (messages.length == 0) {
            return false;
        }
        result.addFatalError(RefactoringCoreMessages.getFormattedString("SelfEncapsulateField.compiler_errors_field", new String[]{this.fField.getElementName(), messages[0].getMessage()}));
        return true;
    }

    private String getMappingErrorMessage() {
        return RefactoringCoreMessages.getFormattedString("SelfEncapsulateField.cannot_analyze_selected_field", new String[]{this.fField.getElementName()});
    }

    public RefactoringStatus checkMethodNames() {
        RefactoringStatus result = new RefactoringStatus();
        IType declaringType = this.fField.getDeclaringType();
        SelfEncapsulateFieldRefactoring.checkName(result, this.fGetterName, this.fUsedReadNames, declaringType);
        SelfEncapsulateFieldRefactoring.checkName(result, this.fSetterName, this.fUsedModifyNames, declaringType);
        return result;
    }

    private static void checkName(RefactoringStatus status, String name, List usedNames, IType type) {
        if (NO_NAME.equals(name)) {
            status.addFatalError(RefactoringCoreMessages.getString("Checks.Choose_name"));
            return;
        }
        status.merge(Checks.checkMethodName(name));
        Iterator iter = usedNames.iterator();
        while (iter.hasNext()) {
            IMethodBinding method = (IMethodBinding)iter.next();
            String selector = method.getName();
            if (!selector.equals(name)) continue;
            status.addFatalError(RefactoringCoreMessages.getFormattedString("SelfEncapsulateField.method_exists", new String[]{Bindings.asString((IBinding)method), type.getElementName()}));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        Object var10_11;
        RefactoringStatus result = new RefactoringStatus();
        this.fChangeManager.clear();
        pm.beginTask(NO_NAME, 11);
        pm.setTaskName(RefactoringCoreMessages.getString("SelfEncapsulateField.checking_preconditions"));
        result.merge(this.checkMethodNames());
        pm.worked(1);
        if (result.hasFatalError()) {
            return result;
        }
        pm.setTaskName(RefactoringCoreMessages.getString("SelfEncapsulateField.searching_for_cunits"));
        ICompilationUnit[] affectedCUs = RefactoringSearchEngine.findAffectedCompilationUnits(SearchPattern.createPattern((IJavaElement)this.fField, (int)2), RefactoringScopeFactory.create((IJavaElement)this.fField), (IProgressMonitor)new SubProgressMonitor(pm, 5), result);
        this.checkInHierarchy(result);
        if (result.hasFatalError()) {
            return result;
        }
        pm.setTaskName(RefactoringCoreMessages.getString("SelfEncapsulateField.analyzing"));
        SubProgressMonitor sub = new SubProgressMonitor(pm, 5);
        sub.beginTask(NO_NAME, affectedCUs.length);
        IVariableBinding fieldIdentifier = this.fFieldDeclaration.resolveBinding();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.dom.TypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITypeBinding declaringClass = ((TypeDeclaration)ASTNodes.getParent((ASTNode)this.fFieldDeclaration, clazz)).resolveBinding();
        ArrayList ownerDescriptions = new ArrayList();
        ICompilationUnit owner = this.fField.getCompilationUnit();
        int i = 0;
        while (i < affectedCUs.length) {
            ArrayList descriptions;
            ICompilationUnit unit = affectedCUs[i];
            sub.subTask(unit.getElementName());
            CompilationUnit root = null;
            OldASTRewrite rewriter = null;
            if (owner.equals(unit)) {
                root = this.fRoot;
                rewriter = this.fRewriter;
                descriptions = ownerDescriptions;
            } else {
                root = new RefactoringASTParser(2).parse(unit, true);
                rewriter = new OldASTRewrite((ASTNode)root);
                descriptions = new ArrayList();
            }
            this.checkCompileErrors(result, root, unit);
            AccessAnalyzer analyzer = new AccessAnalyzer(this, unit, fieldIdentifier, declaringClass, rewriter);
            root.accept((ASTVisitor)analyzer);
            result.merge(analyzer.getStatus());
            if (!this.fSetterMustReturnValue) {
                this.fSetterMustReturnValue = analyzer.getSetterMustReturnValue();
            }
            if (result.hasFatalError()) {
                this.fChangeManager.clear();
                return result;
            }
            descriptions.addAll(analyzer.getGroupDescriptions());
            if (!owner.equals(unit)) {
                this.createEdits(unit, rewriter, descriptions);
            }
            sub.worked(1);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            ++i;
        }
        TextBuffer buffer = TextBuffer.acquire(SelfEncapsulateFieldRefactoring.getFile(owner));
        try {
            ownerDescriptions.addAll(this.addGetterSetterChanges(this.fRoot, this.fRewriter, buffer.getLineDelimiter()));
            this.createEdits(owner, this.fRewriter, ownerDescriptions, buffer);
            var10_11 = null;
        }
        catch (Throwable throwable) {
            var10_11 = null;
            TextBuffer.release(buffer);
            throw throwable;
        }
        TextBuffer.release(buffer);
        sub.done();
        result.merge(this.validateModifiesFiles());
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createEdits(ICompilationUnit unit, OldASTRewrite rewriter, List groups) throws CoreException {
        TextBuffer buffer = TextBuffer.acquire(SelfEncapsulateFieldRefactoring.getFile(unit));
        try {
            this.createEdits(unit, rewriter, groups, buffer);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            TextBuffer.release(buffer);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        TextBuffer.release(buffer);
    }

    private void createEdits(ICompilationUnit unit, OldASTRewrite rewriter, List groups, TextBuffer buffer) {
        TextChange change = this.fChangeManager.get(unit);
        MultiTextEdit root = new MultiTextEdit();
        rewriter.rewriteNode(buffer, (TextEdit)root);
        change.setEdit((TextEdit)root);
        Iterator iter = groups.iterator();
        while (iter.hasNext()) {
            change.addTextEditGroup((TextEditGroup)iter.next());
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        DynamicValidationStateChange result = new DynamicValidationStateChange(this.getName());
        TextChange[] changes = this.fChangeManager.getAllChanges();
        pm.beginTask(NO_NAME, changes.length);
        pm.setTaskName(RefactoringCoreMessages.getString("SelfEncapsulateField.create_changes"));
        int i = 0;
        while (i < changes.length) {
            result.add((Change)changes[i]);
            pm.worked(1);
            ++i;
        }
        pm.done();
        return result;
    }

    public String getName() {
        return RefactoringCoreMessages.getString("SelfEncapsulateField.name");
    }

    private void checkCompileErrors(RefactoringStatus result, CompilationUnit root, ICompilationUnit element) {
        Message[] messages = root.getMessages();
        if (messages.length != 0) {
            result.addError(RefactoringCoreMessages.getFormattedString("SelfEncapsulateField.compiler_errors_update", element.getElementName()), JavaStatusContext.create(element));
        }
    }

    private void checkInHierarchy(RefactoringStatus status) {
        TypeDeclaration declaration = (TypeDeclaration)ASTNodes.getParent((ASTNode)this.fFieldDeclaration, 55);
        ITypeBinding type = declaration.resolveBinding();
        if (type != null) {
            ITypeBinding fieldType = this.fFieldDeclaration.resolveBinding().getType();
            status.merge(Checks.checkMethodInHierarchy(type, this.fGetterName, fieldType, new ITypeBinding[0], this.fField.getJavaProject()));
            status.merge(Checks.checkMethodInHierarchy(type, this.fSetterName, this.fFieldDeclaration.getAST().resolveWellKnownType("void"), new ITypeBinding[]{fieldType}, this.fField.getJavaProject()));
        }
    }

    private void computeUsedNames() {
        this.fUsedReadNames = new ArrayList(0);
        this.fUsedModifyNames = new ArrayList(0);
        IVariableBinding binding = this.fFieldDeclaration.resolveBinding();
        ITypeBinding type = binding.getType();
        IMethodBinding[] methods = binding.getDeclaringClass().getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            IMethodBinding method = methods[i];
            ITypeBinding[] parameters = methods[i].getParameterTypes();
            if (parameters == null || parameters.length == 0) {
                this.fUsedReadNames.add(method);
            } else if (parameters.length == 1 && parameters[0] == type) {
                this.fUsedModifyNames.add(method);
            }
            ++i;
        }
    }

    private List addGetterSetterChanges(CompilationUnit root, OldASTRewrite rewriter, String lineDelimiter) throws CoreException {
        TextEditGroup description;
        ArrayList<TextEditGroup> result = new ArrayList<TextEditGroup>(2);
        AST ast = root.getAST();
        FieldDeclaration decl = (FieldDeclaration)ASTNodes.getParent((ASTNode)this.fFieldDeclaration, 23);
        if (!JdtFlags.isPrivate((IMember)this.fField)) {
            result.add(this.makeDeclarationPrivate(rewriter, decl));
        }
        int position = 0;
        int numberOfMethods = 0;
        List members = ASTNodes.getBodyDeclarations(decl.getParent());
        Iterator iter = members.iterator();
        while (iter.hasNext()) {
            BodyDeclaration element = (BodyDeclaration)iter.next();
            if (element.getNodeType() == 31) {
                if (this.fInsertionIndex == -1) break;
                if (this.fInsertionIndex == numberOfMethods) {
                    ++position;
                    break;
                }
                ++numberOfMethods;
            }
            ++position;
        }
        if (!JdtFlags.isFinal((IMember)this.fField)) {
            description = new TextEditGroup(RefactoringCoreMessages.getString("SelfEncapsulateField.add_setter"));
            result.add(description);
            members.add(position++, this.createSetterMethod(ast, rewriter, description, lineDelimiter));
        }
        description = new TextEditGroup(RefactoringCoreMessages.getString("SelfEncapsulateField.add_getter"));
        result.add(description);
        members.add(position, this.createGetterMethod(ast, rewriter, description, lineDelimiter));
        return result;
    }

    private TextEditGroup makeDeclarationPrivate(OldASTRewrite rewriter, FieldDeclaration decl) {
        AST ast = rewriter.getAST();
        TextEditGroup description = new TextEditGroup(RefactoringCoreMessages.getString("SelfEncapsulateField.change_visibility"));
        if (decl.fragments().size() > 1) {
            rewriter.remove((ASTNode)this.fFieldDeclaration, description);
            List bodyDeclarations = ASTNodes.getBodyDeclarations(decl.getParent());
            int index = bodyDeclarations.indexOf(decl);
            VariableDeclarationFragment newField = (VariableDeclarationFragment)rewriter.createCopyTarget((ASTNode)this.fFieldDeclaration);
            decl = ast.newFieldDeclaration(newField);
            decl.setModifiers(2);
            bodyDeclarations.add(index + 1, decl);
            rewriter.markAsInserted((ASTNode)decl, description);
        } else {
            int newModifiers = ASTNodes.changeVisibility(decl.getModifiers(), 2);
            rewriter.set((ASTNode)decl, (StructuralPropertyDescriptor)FieldDeclaration.MODIFIERS_PROPERTY, new Integer(newModifiers), description);
        }
        return description;
    }

    private MethodDeclaration createSetterMethod(AST ast, OldASTRewrite rewriter, TextEditGroup description, String lineDelimiter) throws CoreException {
        String string;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.dom.FieldDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FieldDeclaration field = (FieldDeclaration)ASTNodes.getParent((ASTNode)this.fFieldDeclaration, clazz);
        Type type = field.getType();
        MethodDeclaration result = ast.newMethodDeclaration();
        rewriter.markAsInserted((ASTNode)result, description);
        result.setName(ast.newSimpleName(this.fSetterName));
        result.setModifiers(this.createModifiers());
        if (this.fSetterMustReturnValue) {
            result.setReturnType((Type)rewriter.createCopyTarget((ASTNode)type));
        }
        SingleVariableDeclaration param = ast.newSingleVariableDeclaration();
        result.parameters().add(param);
        param.setName(ast.newSimpleName(this.fArgName));
        param.setType((Type)rewriter.createCopyTarget((ASTNode)type));
        Block block = ast.newBlock();
        result.setBody(block);
        Assignment ass = ast.newAssignment();
        ass.setLeftHandSide(this.createFieldAccess(ast));
        ass.setRightHandSide((Expression)ast.newSimpleName(this.fArgName));
        if (this.fSetterMustReturnValue) {
            ReturnStatement rs = ast.newReturnStatement();
            rs.setExpression((Expression)ass);
            block.statements().add(rs);
        } else {
            block.statements().add(ast.newExpressionStatement((Expression)ass));
        }
        if (this.fGenerateJavadoc && (string = CodeGeneration.getSetterComment(this.fField.getCompilationUnit(), this.getTypeName(field.getParent()), this.fSetterName, this.fField.getElementName(), ASTNodes.asString((ASTNode)type), this.fArgName, NamingConventions.removePrefixAndSuffixForFieldName((IJavaProject)this.fField.getJavaProject(), (String)this.fField.getElementName(), (int)this.fField.getFlags()), lineDelimiter)) != null) {
            Javadoc javadoc = (Javadoc)this.fRewriter.createStringPlaceholder(string, 29);
            result.setJavadoc(javadoc);
        }
        return result;
    }

    private MethodDeclaration createGetterMethod(AST ast, OldASTRewrite rewriter, TextEditGroup description, String lineDelimiter) throws CoreException {
        String string;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.dom.FieldDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FieldDeclaration field = (FieldDeclaration)ASTNodes.getParent((ASTNode)this.fFieldDeclaration, clazz);
        Type type = field.getType();
        MethodDeclaration result = ast.newMethodDeclaration();
        rewriter.markAsInserted((ASTNode)result, description);
        result.setName(ast.newSimpleName(this.fGetterName));
        result.setModifiers(this.createModifiers());
        result.setReturnType((Type)rewriter.createCopyTarget((ASTNode)type));
        Block block = ast.newBlock();
        result.setBody(block);
        ReturnStatement rs = ast.newReturnStatement();
        rs.setExpression((Expression)ast.newSimpleName(this.fField.getElementName()));
        block.statements().add(rs);
        if (this.fGenerateJavadoc && (string = CodeGeneration.getGetterComment(this.fField.getCompilationUnit(), this.getTypeName(field.getParent()), this.fGetterName, this.fField.getElementName(), ASTNodes.asString((ASTNode)type), NamingConventions.removePrefixAndSuffixForFieldName((IJavaProject)this.fField.getJavaProject(), (String)this.fField.getElementName(), (int)this.fField.getFlags()), lineDelimiter)) != null) {
            Javadoc javadoc = (Javadoc)this.fRewriter.createStringPlaceholder(string, 29);
            result.setJavadoc(javadoc);
        }
        return result;
    }

    private int createModifiers() throws JavaModelException {
        int result = 0;
        if (Flags.isPublic((int)this.fVisibility)) {
            result |= 1;
        } else if (Flags.isProtected((int)this.fVisibility)) {
            result |= 4;
        } else if (Flags.isPrivate((int)this.fVisibility)) {
            result |= 2;
        }
        if (JdtFlags.isStatic((IMember)this.fField)) {
            result |= 8;
        }
        return result;
    }

    private Expression createFieldAccess(AST ast) throws JavaModelException {
        String fieldName = this.fField.getElementName();
        if (this.fArgName.equals(fieldName)) {
            if (JdtFlags.isStatic((IMember)this.fField)) {
                return ast.newQualifiedName((Name)ast.newSimpleName(this.fField.getDeclaringType().getElementName()), ast.newSimpleName(fieldName));
            }
            FieldAccess result = ast.newFieldAccess();
            result.setExpression((Expression)ast.newThisExpression());
            result.setName(ast.newSimpleName(fieldName));
            return result;
        }
        return ast.newSimpleName(fieldName);
    }

    private void checkArgName() {
        String fieldName = this.fField.getElementName();
        boolean isStatic = true;
        try {
            isStatic = JdtFlags.isStatic((IMember)this.fField);
        }
        catch (JavaModelException javaModelException) {}
        if (isStatic && this.fArgName.equals(fieldName) && fieldName.equals(this.fField.getDeclaringType().getElementName())) {
            this.fArgName = "_" + fieldName;
        }
    }

    private static IFile getFile(ICompilationUnit cu) {
        return (IFile)WorkingCopyUtil.getOriginal(cu).getResource();
    }

    private RefactoringStatus validateModifiesFiles() {
        return Checks.validateModifiesFiles(this.getAllFilesToModify(), this.getValidationContext());
    }

    private IFile[] getAllFilesToModify() {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    private String getTypeName(ASTNode type) {
        if (type instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)type).getName().getIdentifier();
        }
        if (type instanceof AnonymousClassDeclaration) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.jdt.core.dom.ClassInstanceCreation");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ClassInstanceCreation node = (ClassInstanceCreation)ASTNodes.getParent(type, clazz);
            return ASTNodes.asString((ASTNode)node.getName());
        }
        Assert.isTrue(false, "Should not happen");
        return null;
    }
}

