/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.Corext;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatusCodes;
import org.eclipse.jdt.internal.corext.refactoring.structure.InstanceMethodMover;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class MoveInstanceMethodRefactoring
extends Refactoring {
    private final IMethod fMethod;
    private final ICompilationUnit fCU;
    private final int fSelectionStart;
    private final int fSelectionLength;
    private CodeGenerationSettings fCodeGenerationSettings;
    private InstanceMethodMover fMover;
    static /* synthetic */ Class class$0;

    public static boolean isAvailable(IMethod method) throws JavaModelException {
        return method.exists() && !method.isConstructor() && !method.isBinary() && method.getCompilationUnit() != null && !JdtFlags.isStatic((IMember)method) && !method.getDeclaringType().isLocal();
    }

    public static MoveInstanceMethodRefactoring create(IMethod method, CodeGenerationSettings codeGenerationSettings) throws JavaModelException {
        if (!MoveInstanceMethodRefactoring.isAvailable(method)) {
            return null;
        }
        return new MoveInstanceMethodRefactoring(method, method.getCompilationUnit(), method.getNameRange().getOffset(), method.getNameRange().getLength(), codeGenerationSettings);
    }

    private MoveInstanceMethodRefactoring(IMethod method, ICompilationUnit cu, int selectionStart, int selectionLength, CodeGenerationSettings codeGenerationSettings) {
        this.fMethod = method;
        this.fCU = cu;
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCodeGenerationSettings = codeGenerationSettings;
    }

    public ICompilationUnit getSourceCU() {
        return this.fCU;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus status = this.initializeMover();
        if (status.hasFatalError()) {
            return status;
        }
        status.merge(this.fMover.checkInitialState());
        return status;
    }

    private RefactoringStatus initializeMover() {
        RefactoringStatus status = new RefactoringStatus();
        MethodDeclaration declaration = this.findMethodDeclaration(status);
        if (status.hasFatalError()) {
            return status;
        }
        Assert.isNotNull(declaration);
        this.fMover = InstanceMethodMover.create(declaration, this.fCU, this.fCodeGenerationSettings);
        if (this.fMover == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("MoveInstanceMethodRefactoring.2"));
        }
        return new RefactoringStatus();
    }

    private MethodDeclaration findMethodDeclaration(RefactoringStatus status) {
        ASTNode parentNode;
        CompilationUnit root = new RefactoringASTParser(2).parse(this.fCU, true);
        ASTNode node = NodeFinder.perform((ASTNode)root, this.fSelectionStart, this.fSelectionLength);
        if (node instanceof MethodDeclaration) {
            return (MethodDeclaration)node;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((parentNode = ASTNodes.getParent(node, clazz)) != null) {
            return (MethodDeclaration)parentNode;
        }
        status.merge(RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.getString("MoveInstanceMethodRefactoring.method_declaration"), null, (String)Corext.getPluginId(), (int)RefactoringStatusCodes.METHOD_NOT_SELECTED, null));
        return null;
    }

    public IMethod getMethodToMove() {
        return this.fMethod;
    }

    public String getNewMethodName() {
        return this.fMover.getNewMethodName();
    }

    public RefactoringStatus setNewMethodName(String newMethodName) {
        Assert.isNotNull(newMethodName);
        RefactoringStatus status = Checks.checkMethodName(newMethodName);
        if (status.hasFatalError()) {
            return status;
        }
        this.fMover.setNewMethodName(newMethodName);
        return status;
    }

    public String getOriginalReceiverParameterName() {
        return this.fMover.getOriginalReceiverParameterName();
    }

    public RefactoringStatus setOriginalReceiverParameterName(String originalReceiverParameterName) {
        RefactoringStatus status = Checks.checkTempName(originalReceiverParameterName);
        if (status.hasFatalError()) {
            return status;
        }
        this.fMover.setOriginalReceiverParameterName(originalReceiverParameterName);
        return status;
    }

    public void setInlineDelegator(boolean inlineDelegator) {
        this.fMover.setInlineDelegator(inlineDelegator);
    }

    public void setRemoveDelegator(boolean removeDelegator) {
        this.fMover.setRemoveDelegator(removeDelegator);
    }

    public INewReceiver[] getPossibleNewReceivers() {
        return this.fMover.getPossibleNewReceivers();
    }

    public void chooseNewReceiver(INewReceiver chosen) {
        this.fMover.chooseNewReceiver(chosen);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        return this.fMover.checkInput(pm, this.getValidationContext());
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        return this.fMover.createChange(pm);
    }

    public String getName() {
        return RefactoringCoreMessages.getString("MoveInstanceMethodRefactoring.name");
    }

    public static interface INewReceiver {
        public String getName();

        public ITypeBinding getType();

        public IBinding getBinding();

        public boolean isField();

        public boolean isParameter();
    }
}

