/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.util.Map;
import org.eclipse.jdt.internal.ui.preferences.formatter.CompilationUnitPreview;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.JavaPreview;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class BracesTabPage
extends ModifyDialogTabPage {
    private static final String PREVIEW = String.valueOf(ModifyDialogTabPage.createPreviewHeader(FormatterMessages.getString("BracesTabPage.preview.header"))) + "class Empty {}\n" + "\n" + "class Example {" + "  SomeClass fField= new SomeClass() {" + "  };" + "  int [] myArray= {1,2,3,4,5,6};" + "  int [] emptyArray= new int[] {};" + "  Example() {" + "  }" + "  void bar(int p) {" + "    for (int i= 0; i<10; i++) {" + "    }" + "    switch(p) {" + "      case 0:" + "        fField.set(0);" + "        break;" + "      case 1: {" + "        break;" + "        }" + "      default:" + "        fField.reset();" + "    }" + "  }" + "  void foo() {}" + "}";
    private CompilationUnitPreview fPreview;
    private static final String[] fBracePositions = new String[]{"end_of_line", "next_line", "next_line_shifted"};
    private static final String[] fExtendedBracePositions = new String[]{"end_of_line", "next_line", "next_line_shifted", "next_line_on_wrap"};
    private static final String[] fBracePositionNames = new String[]{FormatterMessages.getString("BracesTabPage.position.same_line"), FormatterMessages.getString("BracesTabPage.position.next_line"), FormatterMessages.getString("BracesTabPage.position.next_line_indented")};
    private static final String[] fExtendedBracePositionNames = new String[]{FormatterMessages.getString("BracesTabPage.position.same_line"), FormatterMessages.getString("BracesTabPage.position.next_line"), FormatterMessages.getString("BracesTabPage.position.next_line_indented"), FormatterMessages.getString("BracesTabPage.position.next_line_on_wrap")};

    public BracesTabPage(ModifyDialog modifyDialog, Map workingValues) {
        super(modifyDialog, workingValues);
    }

    protected void doCreatePreferences(Composite composite, int numColumns) {
        Group group = this.createGroup(numColumns, composite, FormatterMessages.getString("BracesTabPage.group.brace_positions.title"));
        this.createExtendedBracesCombo((Composite)group, numColumns, "BracesTabPage.option.class_declaration", "org.eclipse.jdt.core.formatter.brace_position_for_type_declaration");
        this.createExtendedBracesCombo((Composite)group, numColumns, "BracesTabPage.option.anonymous_class_declaration", "org.eclipse.jdt.core.formatter.brace_position_for_anonymous_type_declaration");
        this.createExtendedBracesCombo((Composite)group, numColumns, "BracesTabPage.option.constructor_declaration", "org.eclipse.jdt.core.formatter.brace_position_for_constructor_declaration");
        this.createExtendedBracesCombo((Composite)group, numColumns, "BracesTabPage.option.method_declaration", "org.eclipse.jdt.core.formatter.brace_position_for_method_declaration");
        this.createExtendedBracesCombo((Composite)group, numColumns, "BracesTabPage.option.blocks", "org.eclipse.jdt.core.formatter.brace_position_for_block");
        this.createExtendedBracesCombo((Composite)group, numColumns, "BracesTabPage.option.blocks_in_case", "org.eclipse.jdt.core.formatter.brace_position_for_block_in_case");
        this.createBracesCombo((Composite)group, numColumns, "BracesTabPage.option.switch_case", "org.eclipse.jdt.core.formatter.brace_position_for_switch");
        this.createBracesCombo((Composite)group, numColumns, "BracesTabPage.option.array_initializer", "org.eclipse.jdt.core.formatter.brace_position_for_array_initializer");
        this.createIndentedCheckboxPref((Composite)group, numColumns, "BracesTabPage.option.keep_empty_array_initializer_on_one_line", "org.eclipse.jdt.core.formatter.keep_empty_array_initializer_on_one_line", ModifyDialogTabPage.FALSE_TRUE);
    }

    protected void initializePage() {
        this.fPreview.setPreviewText(PREVIEW);
    }

    protected JavaPreview doCreateJavaPreview(Composite parent) {
        this.fPreview = new CompilationUnitPreview(this.fWorkingValues, parent);
        return this.fPreview;
    }

    private void createBracesCombo(Composite composite, int numColumns, String messagesKey, String key) {
        this.createComboPref(composite, numColumns, FormatterMessages.getString(messagesKey), key, fBracePositions, fBracePositionNames);
    }

    private void createExtendedBracesCombo(Composite composite, int numColumns, String messagesKey, String key) {
        this.createComboPref(composite, numColumns, FormatterMessages.getString(messagesKey), key, fExtendedBracePositions, fExtendedBracePositionNames);
    }

    private ModifyDialogTabPage.CheckboxPreference createIndentedCheckboxPref(Composite composite, int numColumns, String messagesKey, String key, String[] values) {
        ModifyDialogTabPage.CheckboxPreference pref = this.createCheckboxPref(composite, numColumns, FormatterMessages.getString(messagesKey), key, values);
        GridData data = (GridData)pref.getControl().getLayoutData();
        data.horizontalIndent = this.fPixelConverter.convertWidthInCharsToPixels(1);
        return pref;
    }

    protected void doUpdatePreview() {
        this.fPreview.update();
    }
}

