/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenamePackageProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.widgets.Shell;

public class NewNameQueries
implements INewNameQueries {
    private static final String INVALID_NAME_NO_MESSAGE = "";
    private final Wizard fWizard;
    private final Shell fShell;

    public NewNameQueries() {
        this.fShell = null;
        this.fWizard = null;
    }

    public NewNameQueries(Wizard wizard) {
        this.fWizard = wizard;
        this.fShell = null;
    }

    public NewNameQueries(Shell shell) {
        this.fShell = shell;
        this.fWizard = null;
    }

    private Shell getShell() {
        Assert.isTrue(this.fWizard == null || this.fShell == null);
        if (this.fWizard != null) {
            return this.fWizard.getContainer().getShell();
        }
        if (this.fShell != null) {
            return this.fShell;
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    private static String removeTrailingJava(String name) {
        Assert.isTrue(name.endsWith(".java"));
        return name.substring(0, name.length() - ".java".length());
    }

    public INewNameQuery createNewCompilationUnitNameQuery(ICompilationUnit cu, String initialSuggestedName) {
        String[] keys = new String[]{NewNameQueries.removeTrailingJava(cu.getElementName())};
        String message = ReorgMessages.getFormattedString("ReorgQueries.enterNewNameQuestion", keys);
        return NewNameQueries.createStaticQuery(NewNameQueries.createCompilationUnitNameValidator(cu), message, initialSuggestedName, this.getShell());
    }

    public INewNameQuery createNewResourceNameQuery(IResource res, String initialSuggestedName) {
        String[] keys = new String[]{res.getName()};
        String message = ReorgMessages.getFormattedString("ReorgQueries.enterNewNameQuestion", keys);
        return NewNameQueries.createStaticQuery(NewNameQueries.createResourceNameValidator(res), message, initialSuggestedName, this.getShell());
    }

    public INewNameQuery createNewPackageNameQuery(IPackageFragment pack, String initialSuggestedName) {
        String[] keys = new String[]{pack.getElementName()};
        String message = ReorgMessages.getFormattedString("ReorgQueries.enterNewNameQuestion", keys);
        return NewNameQueries.createStaticQuery(NewNameQueries.createPackageNameValidator(pack), message, initialSuggestedName, this.getShell());
    }

    public INewNameQuery createNewPackageFragmentRootNameQuery(IPackageFragmentRoot root, String initialSuggestedName) {
        String[] keys = new String[]{root.getElementName()};
        String message = ReorgMessages.getFormattedString("ReorgQueries.enterNewNameQuestion", keys);
        return NewNameQueries.createStaticQuery(NewNameQueries.createPackageFragmentRootNameValidator(root), message, initialSuggestedName, this.getShell());
    }

    public INewNameQuery createNullQuery() {
        return this.createStaticQuery(null);
    }

    public INewNameQuery createStaticQuery(final String newName) {
        return new INewNameQuery(){

            public String getNewName() {
                return newName;
            }
        };
    }

    private static INewNameQuery createStaticQuery(final IInputValidator validator, final String message, final String initial, final Shell shell) {
        return new INewNameQuery(){

            public String getNewName() {
                InputDialog dialog = new InputDialog(shell, ReorgMessages.getString("ReorgQueries.nameConflictMessage"), message, initial, validator);
                if (dialog.open() == 1) {
                    throw new OperationCanceledException();
                }
                return dialog.getValue();
            }
        };
    }

    private static IInputValidator createResourceNameValidator(final IResource res) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || NewNameQueries.INVALID_NAME_NO_MESSAGE.equals(newText) || res.getParent() == null) {
                    return NewNameQueries.INVALID_NAME_NO_MESSAGE;
                }
                if (res.getParent().findMember(newText) != null) {
                    return ReorgMessages.getString("ReorgQueries.resourceWithThisNameAlreadyExists");
                }
                if (!res.getParent().getFullPath().isValidSegment(newText)) {
                    return ReorgMessages.getString("ReorgQueries.invalidNameMessage");
                }
                IStatus status = res.getParent().getWorkspace().validateName(newText, res.getType());
                if (status.getSeverity() == 4) {
                    return status.getMessage();
                }
                if (res.getName().equalsIgnoreCase(newText)) {
                    return ReorgMessages.getString("ReorgQueries.resourceExistsWithDifferentCaseMassage");
                }
                return null;
            }
        };
        return validator;
    }

    private static IInputValidator createCompilationUnitNameValidator(final ICompilationUnit cu) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                RefactoringStatus refStatus;
                if (newText == null || NewNameQueries.INVALID_NAME_NO_MESSAGE.equals(newText)) {
                    return NewNameQueries.INVALID_NAME_NO_MESSAGE;
                }
                String newCuName = String.valueOf(newText) + ".java";
                IStatus status = JavaConventions.validateCompilationUnitName((String)newCuName);
                if (status.getSeverity() == 4) {
                    return status.getMessage();
                }
                try {
                    refStatus = Checks.checkCompilationUnitNewName(cu, newText);
                }
                catch (JavaModelException javaModelException) {
                    return NewNameQueries.INVALID_NAME_NO_MESSAGE;
                }
                if (refStatus.hasFatalError()) {
                    return refStatus.getMessageMatchingSeverity(4);
                }
                if (cu.getElementName().equalsIgnoreCase(newCuName)) {
                    return ReorgMessages.getString("ReorgQueries.resourceExistsWithDifferentCaseMassage");
                }
                return null;
            }
        };
        return validator;
    }

    private static IInputValidator createPackageFragmentRootNameValidator(IPackageFragmentRoot root) {
        return new IInputValidator(root){
            IInputValidator resourceNameValidator;
            {
                this.resourceNameValidator = NewNameQueries.createResourceNameValidator(iPackageFragmentRoot.getResource());
            }

            public String isValid(String newText) {
                return this.resourceNameValidator.isValid(newText);
            }
        };
    }

    private static IInputValidator createPackageNameValidator(final IPackageFragment pack) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || NewNameQueries.INVALID_NAME_NO_MESSAGE.equals(newText)) {
                    return NewNameQueries.INVALID_NAME_NO_MESSAGE;
                }
                IStatus status = JavaConventions.validatePackageName((String)newText);
                if (status.getSeverity() == 4) {
                    return status.getMessage();
                }
                IJavaElement parent = pack.getParent();
                try {
                    if (parent instanceof IPackageFragmentRoot && !RenamePackageProcessor.isPackageNameOkInRoot(newText, (IPackageFragmentRoot)parent)) {
                        return ReorgMessages.getString("ReorgQueries.packagewithThatNameexistsMassage");
                    }
                }
                catch (CoreException coreException) {
                    return NewNameQueries.INVALID_NAME_NO_MESSAGE;
                }
                if (pack.getElementName().equalsIgnoreCase(newText)) {
                    return ReorgMessages.getString("ReorgQueries.resourceExistsWithDifferentCaseMassage");
                }
                return null;
            }
        };
        return validator;
    }
}

