/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import org.eclipse.jdt.internal.ui.text.CustomSourceInformationControl;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.LineChangeHover;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class JavaChangeHover
extends LineChangeHover {
    String fPartition;
    CustomSourceInformationControl fInformationControl;
    private String fPartitioning;
    private int fLastScrollIndex = 0;

    public JavaChangeHover(String partitioning) {
        this.fPartitioning = partitioning;
    }

    protected String formatSource(String content) {
        return content;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                JavaChangeHover.this.fInformationControl = new CustomSourceInformationControl(parent, JavaChangeHover.this.fPartition);
                JavaChangeHover.this.fInformationControl.setHorizontalScrollPixel(JavaChangeHover.this.fLastScrollIndex);
                return JavaChangeHover.this.fInformationControl;
            }
        };
    }

    protected Point computeLineRange(ISourceViewer viewer, int line, int first, int number) {
        Point lineRange = super.computeLineRange(viewer, line, first, number);
        this.fPartition = lineRange != null ? this.getPartition(viewer, lineRange.x) : "__dftl_partition_content_type";
        this.fLastScrollIndex = viewer.getTextWidget().getHorizontalPixel();
        if (this.fInformationControl != null) {
            this.fInformationControl.setStartingPartitionType(this.fPartition);
            this.fInformationControl.setHorizontalScrollPixel(this.fLastScrollIndex);
        }
        return lineRange;
    }

    private String getPartition(ISourceViewer viewer, int startLine) {
        if (viewer == null) {
            return null;
        }
        IDocument doc = viewer.getDocument();
        if (doc == null) {
            return null;
        }
        if (startLine <= 0) {
            return "__dftl_partition_content_type";
        }
        try {
            ITypedRegion region = TextUtilities.getPartition((IDocument)doc, (String)this.fPartitioning, (int)(doc.getLineOffset(startLine) - 1), (boolean)true);
            return region.getType();
        }
        catch (BadLocationException badLocationException) {
            return "__dftl_partition_content_type";
        }
    }

    protected String getTabReplacement() {
        return Character.toString('\t');
    }
}

