/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jdt.internal.ui.text.ITypingRunListener;
import org.eclipse.jdt.internal.ui.text.TypingRun;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;

public class TypingRunDetector {
    private static final boolean DEBUG = false;
    private final Set fListeners = new HashSet();
    private ITextViewer fViewer;
    private final TextListener fTextListener = new TextListener();
    private SelectionListener fSelectionListener;
    private Change fLastChange;
    private TypingRun fRun;

    public void install(ITextViewer viewer) {
        Assert.isLegal((viewer != null ? 1 : 0) != 0);
        this.fViewer = viewer;
        this.connect();
    }

    private void connect() {
        if (this.fViewer != null) {
            this.fLastChange = new Change(TypingRun.UNKNOWN, -1);
            this.fRun = null;
            this.fSelectionListener = null;
            this.fViewer.addTextListener((ITextListener)this.fTextListener);
        }
    }

    public void uninstall() {
        if (this.fViewer != null) {
            this.fListeners.clear();
            this.disconnect();
            this.fViewer = null;
        }
    }

    private void disconnect() {
        this.fViewer.removeTextListener((ITextListener)this.fTextListener);
        this.ensureSelectionListenerRemoved();
    }

    public void addTypingRunListener(ITypingRunListener listener) {
        Assert.isLegal((listener != null ? 1 : 0) != 0);
        this.fListeners.add(listener);
        if (this.fListeners.size() == 1) {
            this.connect();
        }
    }

    public void removeTypingRunListener(ITypingRunListener listener) {
        this.fListeners.remove(listener);
        if (this.fListeners.size() == 0) {
            this.disconnect();
        }
    }

    void handleTextChanged(TextEvent event) {
        Change type = this.computeChange(event);
        this.handleChange(type);
    }

    private Change computeChange(TextEvent event) {
        DocumentEvent e = event.getDocumentEvent();
        if (e == null) {
            return new Change(TypingRun.NO_CHANGE, -1);
        }
        int start = e.getOffset();
        int end = e.getOffset() + e.getLength();
        String newText = e.getText();
        if (newText == null) {
            newText = new String();
        }
        if (start == end) {
            if (newText.length() == 1) {
                return new Change(TypingRun.INSERT, end + 1);
            }
        } else if (start == end - 1) {
            if (newText.length() == 1) {
                return new Change(TypingRun.OVERTYPE, end);
            }
            if (newText.length() == 0) {
                return new Change(TypingRun.DELETE, start);
            }
        }
        return new Change(TypingRun.UNKNOWN, -1);
    }

    void handleSelectionChanged() {
        this.handleChange(new Change(TypingRun.SELECTION, -1));
    }

    private void handleChange(Change change) {
        if (change.getType() == TypingRun.NO_CHANGE) {
            return;
        }
        if (!change.canFollow(this.fLastChange)) {
            this.endIfStarted(change);
        }
        this.fLastChange = change;
        if (change.isModification()) {
            this.startOrContinue();
        }
    }

    private void startOrContinue() {
        if (!this.hasRun()) {
            this.fRun = new TypingRun(this.fLastChange.getType());
            this.ensureSelectionListenerAdded();
            this.fireRunBegun(this.fRun);
        }
    }

    private boolean hasRun() {
        return this.fRun != null;
    }

    private void endIfStarted(Change change) {
        if (this.hasRun()) {
            this.ensureSelectionListenerRemoved();
            this.fireRunEnded(this.fRun, change.getType());
            this.fRun = null;
        }
    }

    private void ensureSelectionListenerAdded() {
        if (this.fSelectionListener == null) {
            this.fSelectionListener = new SelectionListener();
            StyledText textWidget = this.fViewer.getTextWidget();
            textWidget.addFocusListener((FocusListener)this.fSelectionListener);
            textWidget.addKeyListener((KeyListener)this.fSelectionListener);
            textWidget.addMouseListener((MouseListener)this.fSelectionListener);
        }
    }

    private void ensureSelectionListenerRemoved() {
        if (this.fSelectionListener != null) {
            StyledText textWidget = this.fViewer.getTextWidget();
            textWidget.removeFocusListener((FocusListener)this.fSelectionListener);
            textWidget.removeKeyListener((KeyListener)this.fSelectionListener);
            textWidget.removeMouseListener((MouseListener)this.fSelectionListener);
            this.fSelectionListener = null;
        }
    }

    private void fireRunBegun(TypingRun run) {
        ArrayList listeners = new ArrayList(this.fListeners);
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            ITypingRunListener listener = (ITypingRunListener)it.next();
            listener.typingRunStarted(this.fRun);
        }
    }

    private void fireRunEnded(TypingRun run, TypingRun.ChangeType reason) {
        ArrayList listeners = new ArrayList(this.fListeners);
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            ITypingRunListener listener = (ITypingRunListener)it.next();
            listener.typingRunEnded(this.fRun, reason);
        }
    }

    private static final class Change {
        private TypingRun.ChangeType fType;
        private int fNextOffset;

        public Change(TypingRun.ChangeType type, int nextOffset) {
            this.fType = type;
            this.fNextOffset = nextOffset;
        }

        public boolean canFollow(Change change) {
            if (this.fType == TypingRun.NO_CHANGE) {
                return true;
            }
            if (this.fType.equals(TypingRun.UNKNOWN)) {
                return false;
            }
            if (this.fType.equals(change.fType)) {
                if (this.fType == TypingRun.DELETE) {
                    return this.fNextOffset == change.fNextOffset - 1;
                }
                if (this.fType == TypingRun.INSERT) {
                    return this.fNextOffset == change.fNextOffset + 1;
                }
                if (this.fType == TypingRun.OVERTYPE) {
                    return this.fNextOffset == change.fNextOffset + 1;
                }
                if (this.fType == TypingRun.SELECTION) {
                    return true;
                }
            }
            return false;
        }

        public boolean isModification() {
            return this.fType.isModification();
        }

        public String toString() {
            return String.valueOf(this.fType.toString()) + "@" + this.fNextOffset;
        }

        public TypingRun.ChangeType getType() {
            return this.fType;
        }
    }

    private class TextListener
    implements ITextListener {
        TextListener() {
        }

        public void textChanged(TextEvent event) {
            TypingRunDetector.this.handleTextChanged(event);
        }
    }

    private class SelectionListener
    implements MouseListener,
    KeyListener,
    FocusListener {
        SelectionListener() {
        }

        public void focusGained(FocusEvent e) {
            TypingRunDetector.this.handleSelectionChanged();
        }

        public void focusLost(FocusEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            if (e.button == 1) {
                TypingRunDetector.this.handleSelectionChanged();
            }
        }

        public void mouseUp(MouseEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            switch (e.keyCode) {
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: 
                case 0x1000005: 
                case 0x1000006: 
                case 0x1000007: 
                case 0x1000008: {
                    TypingRunDetector.this.handleSelectionChanged();
                }
            }
        }
    }
}

