/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.comment;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.comment.CommentLine;
import org.eclipse.jdt.internal.ui.text.comment.CommentObjectFactory;
import org.eclipse.jdt.internal.ui.text.comment.CommentRange;
import org.eclipse.jdt.internal.ui.text.comment.IBorderAttributes;
import org.eclipse.jdt.internal.ui.text.comment.ICommentAttributes;
import org.eclipse.jdt.internal.ui.text.comment.ITextMeasurement;
import org.eclipse.jdt.internal.ui.text.javadoc.IHtmlTagConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ConfigurableLineTracker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class CommentRegion
extends TypedPosition
implements IHtmlTagConstants,
IBorderAttributes,
ICommentAttributes {
    public static final int COMMENT_PREFIX_LENGTH = 3;
    protected static final String COMMENT_RANGE_DELIMITER = " ";
    private int fBorders = 0;
    private final boolean fClear;
    private final String fDelimiter;
    private final IDocument fDocument;
    private final ITextMeasurement fTextMeasurement;
    private final LinkedList fLines = new LinkedList();
    private final Map fPreferences;
    private final LinkedList fRanges = new LinkedList();
    private MultiTextEdit fResult = new MultiTextEdit();
    private final boolean fSingleLine;
    private int fTabs;

    protected CommentRegion(IDocument document, TypedPosition position, String delimiter, Map preferences, ITextMeasurement textMeasurement) {
        super(position.getOffset(), position.getLength(), position.getType());
        this.fDelimiter = delimiter;
        this.fPreferences = preferences;
        this.fDocument = document;
        this.fClear = this.fPreferences.get("comment_clear_blank_lines") == "true";
        this.fTextMeasurement = textMeasurement;
        if (this.fPreferences.containsKey("org.eclipse.jdt.core.formatter.tabulation.size")) {
            try {
                this.fTabs = Integer.parseInt((String)this.fPreferences.get("org.eclipse.jdt.core.formatter.tabulation.size"));
            }
            catch (NumberFormatException numberFormatException) {
                this.fTabs = 4;
            }
        } else {
            this.fTabs = 4;
        }
        ConfigurableLineTracker tracker = new ConfigurableLineTracker(new String[]{delimiter});
        IRegion range = null;
        CommentLine line = null;
        tracker.set(this.getText(0, this.getLength()));
        int lines = tracker.getNumberOfLines();
        this.fSingleLine = lines == 1;
        try {
            int index = 0;
            while (index < lines) {
                range = tracker.getLineInformation(index);
                line = CommentObjectFactory.createLine(this);
                line.append(new CommentRange(range.getOffset(), range.getLength()));
                this.fLines.add(line);
                ++index;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    protected final void append(CommentRange range) {
        this.fRanges.addLast(range);
    }

    protected boolean canAppend(CommentLine line, CommentRange previous, CommentRange next, int index, int width) {
        return index == 0 || index + next.getLength() <= width;
    }

    protected boolean canFormat(CommentRange previous, CommentRange next) {
        return true;
    }

    public final TextEdit format(String indentation) {
        this.fResult = new MultiTextEdit();
        String probe = this.getText(0, "/*-".length());
        if (!probe.startsWith("/*-")) {
            int margin = 80;
            try {
                margin = Integer.parseInt(this.fPreferences.get("comment_line_length").toString());
            }
            catch (Exception exception) {}
            margin = Math.max(4, margin - this.stringToLength(indentation) - 3);
            this.tokenizeRegion();
            this.markRegion();
            this.wrapRegion(margin);
            this.formatRegion(indentation, margin);
        }
        return this.fResult;
    }

    protected void formatRegion(String indentation, int width) {
        int last = this.fLines.size() - 1;
        if (last >= 0) {
            CommentLine previous = null;
            CommentLine next = (CommentLine)this.fLines.get(last);
            CommentRange range = next.getLast();
            next.formatLowerBorder(range, indentation, width);
            int line = last;
            while (line >= 0) {
                previous = next;
                next = (CommentLine)this.fLines.get(line);
                range = next.formatLine(previous, range, indentation, line);
                --line;
            }
            next.formatUpperBorder(range, indentation, width);
        }
    }

    protected final String getDelimiter() {
        return this.fDelimiter;
    }

    protected String getDelimiter(CommentLine predecessor, CommentLine successor, CommentRange previous, CommentRange next, String indentation) {
        return String.valueOf(this.fDelimiter) + indentation + successor.getContentPrefix();
    }

    protected String getDelimiter(CommentRange previous, CommentRange next) {
        return COMMENT_RANGE_DELIMITER;
    }

    protected final IDocument getDocument() {
        return this.fDocument;
    }

    public final Map getPreferences() {
        return this.fPreferences;
    }

    protected final LinkedList getRanges() {
        return this.fRanges;
    }

    protected final int getSize() {
        return this.fLines.size();
    }

    protected final String getText(int position, int count) {
        String content = "";
        try {
            content = this.fDocument.get(this.getOffset() + position, count);
        }
        catch (BadLocationException badLocationException) {}
        return content;
    }

    protected final boolean hasBorder(int border) {
        return (this.fBorders & border) == border;
    }

    protected final boolean isAlphaNumeric(CommentRange range) {
        String token = this.getText(range.getOffset(), range.getLength());
        int index = 0;
        while (index < token.length()) {
            if (!Character.isLetterOrDigit(token.charAt(index))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    protected final boolean isNonAlphaNumeric(CommentRange range) {
        String token = this.getText(range.getOffset(), range.getLength());
        int index = 0;
        while (index < token.length()) {
            if (Character.isLetterOrDigit(token.charAt(index))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    protected final boolean isClearLines() {
        return this.fClear;
    }

    protected final boolean isSingleLine() {
        return this.fSingleLine;
    }

    protected final TextEdit logEdit(String change, int position, int count) {
        Object child = null;
        try {
            int base = this.getOffset() + position;
            String content = this.fDocument.get(base, count);
            if (!change.equals(content)) {
                child = count > 0 ? new ReplaceEdit(base, count, change) : new InsertEdit(base, change);
                this.fResult.addChild((TextEdit)child);
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (MalformedTreeException exception) {
            JavaPlugin.log(exception);
        }
        return child;
    }

    protected void markRegion() {
    }

    protected final void setBorder(int border) {
        this.fBorders |= border;
    }

    protected final String stringToIndent(String reference, boolean tabs) {
        int space;
        int pixels;
        if (this.fTextMeasurement != null) {
            pixels = this.stringToPixels(reference);
            space = this.fTextMeasurement.computeWidth(COMMENT_RANGE_DELIMITER);
        } else {
            space = 1;
            pixels = reference.length();
            int index = -1;
            while ((index = reference.indexOf(9, index + 1)) >= 0) {
                pixels += this.fTabs - 1;
            }
        }
        StringBuffer buffer = new StringBuffer();
        int spaces = pixels / space;
        if (tabs) {
            int count = spaces / this.fTabs;
            int modulo = spaces % this.fTabs;
            int index = 0;
            while (index < count) {
                buffer.append('\t');
                ++index;
            }
            index = 0;
            while (index < modulo) {
                buffer.append(' ');
                ++index;
            }
        } else {
            int index = 0;
            while (index < spaces) {
                buffer.append(' ');
                ++index;
            }
        }
        return buffer.toString();
    }

    protected final int stringToLength(String reference) {
        int tabs = 0;
        int count = reference.length();
        int index = 0;
        while (index < count) {
            if (reference.charAt(index) == '\t') {
                ++tabs;
            }
            ++index;
        }
        return count += tabs * (this.fTabs - 1);
    }

    protected final int stringToPixels(String reference) {
        StringBuffer buffer = new StringBuffer();
        char character = '\u0000';
        int index = 0;
        while (index < reference.length()) {
            character = reference.charAt(index);
            if (character == '\t') {
                int tab = 0;
                while (tab < this.fTabs) {
                    buffer.append(' ');
                    ++tab;
                }
            } else {
                buffer.append(character);
            }
            ++index;
        }
        return this.fTextMeasurement.computeWidth(buffer.toString());
    }

    protected void tokenizeRegion() {
        int index = 0;
        CommentLine line = null;
        Iterator iterator = this.fLines.iterator();
        while (iterator.hasNext()) {
            line = (CommentLine)iterator.next();
            line.scanLine(index);
            line.tokenizeLine(index);
            ++index;
        }
    }

    protected void wrapRegion(int width) {
        this.fLines.clear();
        int index = 0;
        boolean adapted = false;
        CommentLine successor = null;
        CommentLine predecessor = null;
        CommentRange previous = null;
        CommentRange next = null;
        block0: while (!this.fRanges.isEmpty()) {
            index = 0;
            adapted = false;
            predecessor = successor;
            successor = CommentObjectFactory.createLine(this);
            this.fLines.add(successor);
            while (!this.fRanges.isEmpty()) {
                next = (CommentRange)this.fRanges.getFirst();
                if (!this.canAppend(successor, previous, next, index, width)) continue block0;
                if (!adapted && predecessor != null) {
                    successor.adapt(predecessor);
                    adapted = true;
                }
                this.fRanges.removeFirst();
                successor.append(next);
                index += next.getLength() + 1;
                previous = next;
            }
        }
    }
}

