/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.folding;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.folding.JavaFoldingStructureProviderDescriptor;
import org.eclipse.jdt.ui.text.folding.IJavaFoldingStructureProvider;

public class JavaFoldingStructureProviderRegistry {
    private static final String EXTENSION_POINT = "foldingStructureProviders";
    private Map fDescriptors;

    public JavaFoldingStructureProviderDescriptor[] getFoldingProviderDescriptors() {
        JavaFoldingStructureProviderRegistry javaFoldingStructureProviderRegistry = this;
        synchronized (javaFoldingStructureProviderRegistry) {
            this.ensureRegistered();
            return this.fDescriptors.values().toArray(new JavaFoldingStructureProviderDescriptor[this.fDescriptors.size()]);
        }
    }

    public JavaFoldingStructureProviderDescriptor getFoldingProviderDescriptor(String id) {
        JavaFoldingStructureProviderRegistry javaFoldingStructureProviderRegistry = this;
        synchronized (javaFoldingStructureProviderRegistry) {
            this.ensureRegistered();
            return (JavaFoldingStructureProviderDescriptor)this.fDescriptors.get(id);
        }
    }

    public IJavaFoldingStructureProvider getCurrentFoldingProvider() {
        String id = JavaPlugin.getDefault().getPreferenceStore().getString("editor_folding_provider");
        JavaFoldingStructureProviderDescriptor desc = this.getFoldingProviderDescriptor(id);
        if (desc != null) {
            try {
                return desc.createProvider();
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
        return null;
    }

    private void ensureRegistered() {
        if (this.fDescriptors == null) {
            this.reloadExtensions();
        }
    }

    public void reloadExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        HashMap<String, JavaFoldingStructureProviderDescriptor> map = new HashMap<String, JavaFoldingStructureProviderDescriptor>();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(JavaPlugin.getPluginId(), EXTENSION_POINT);
        int i = 0;
        while (i < elements.length) {
            JavaFoldingStructureProviderDescriptor desc = new JavaFoldingStructureProviderDescriptor(elements[i]);
            map.put(desc.getId(), desc);
            ++i;
        }
        JavaFoldingStructureProviderRegistry javaFoldingStructureProviderRegistry = this;
        synchronized (javaFoldingStructureProviderRegistry) {
            this.fDescriptors = Collections.unmodifiableMap(map);
        }
    }
}

