/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.ui.text.AbstractJavaScanner;
import org.eclipse.jdt.internal.ui.text.CombinedWordRule;
import org.eclipse.jdt.internal.ui.text.JavaWhitespaceDetector;
import org.eclipse.jdt.internal.ui.text.JavaWordDetector;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.util.PropertyChangeEvent;

public final class JavaCodeScanner
extends AbstractJavaScanner {
    private static final String SOURCE_VERSION = "org.eclipse.jdt.core.compiler.source";
    static String[] fgKeywords = new String[]{"abstract", "break", "case", "catch", "class", "const", "continue", "default", "do", "else", "extends", "final", "finally", "for", "goto", "if", "implements", "import", "instanceof", "interface", "native", "new", "package", "private", "protected", "public", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "volatile", "while"};
    private static String[] fgNewKeywords = new String[]{"assert"};
    private static String[] fgTypes = new String[]{"void", "boolean", "char", "byte", "short", "strictfp", "int", "long", "float", "double"};
    private static String[] fgConstants = new String[]{"false", "null", "true"};
    private static String[] fgTokenProperties = new String[]{"java_keyword", "java_string", "java_default", "java_method_name", "java_keyword_return", "java_operator"};
    private VersionedWordMatcher fVersionedWordMatcher;

    public JavaCodeScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    protected List createRules() {
        ArrayList<Object> rules = new ArrayList<Object>();
        Token token = this.getToken("java_string");
        rules.add(new SingleLineRule("'", "'", (IToken)token, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new JavaWhitespaceDetector()));
        token = this.getToken("java_default");
        CombinedWordRule combinedWordRule = new CombinedWordRule((IWordDetector)new JavaWordDetector(), (IToken)token);
        String version = this.getPreferenceStore().getString(SOURCE_VERSION);
        token = this.getToken("java_default");
        this.fVersionedWordMatcher = new VersionedWordMatcher((IToken)token, "1.4", true, version);
        token = this.getToken("java_keyword");
        int i = 0;
        while (i < fgNewKeywords.length) {
            this.fVersionedWordMatcher.addWord(fgNewKeywords[i], (IToken)token);
            ++i;
        }
        combinedWordRule.addWordMatcher(this.fVersionedWordMatcher);
        token = this.getToken("java_operator");
        rules.add(new OperatorRule((IToken)token));
        CombinedWordRule.WordMatcher returnWordRule = new CombinedWordRule.WordMatcher();
        token = this.getToken("java_keyword_return");
        returnWordRule.addWord("return", (IToken)token);
        combinedWordRule.addWordMatcher(returnWordRule);
        token = this.getToken("java_method_name");
        combinedWordRule.addWordMatcher(new MethodNameMatcher((IToken)token));
        CombinedWordRule.WordMatcher wordRule = new CombinedWordRule.WordMatcher();
        token = this.getToken("java_keyword");
        int i2 = 0;
        while (i2 < fgKeywords.length) {
            wordRule.addWord(fgKeywords[i2], (IToken)token);
            ++i2;
        }
        i2 = 0;
        while (i2 < fgTypes.length) {
            wordRule.addWord(fgTypes[i2], (IToken)token);
            ++i2;
        }
        i2 = 0;
        while (i2 < fgConstants.length) {
            wordRule.addWord(fgConstants[i2], (IToken)token);
            ++i2;
        }
        combinedWordRule.addWordMatcher(wordRule);
        rules.add(combinedWordRule);
        this.setDefaultReturnToken((IToken)this.getToken("java_default"));
        return rules;
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return event.getProperty().equals(SOURCE_VERSION) || super.affectsBehavior(event);
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(SOURCE_VERSION)) {
            Object value = event.getNewValue();
            if (value instanceof String) {
                String s = (String)value;
                if (this.fVersionedWordMatcher != null) {
                    this.fVersionedWordMatcher.setCurrentVersion(s);
                }
            }
        } else if (super.affectsBehavior(event)) {
            super.adaptToPreferenceChange(event);
        }
    }

    protected class OperatorRule
    implements IRule {
        private final char[] JAVA_OPERATORS = new char[]{';', '(', ')', '{', '}', '.', '=', '/', '\\', '+', '-', '*', '[', ']', '<', '>', ':', '?', '!', ',', '|', '&', '^', '%', '~'};
        private final IToken fToken;

        public OperatorRule(IToken token) {
            this.fToken = token;
        }

        public boolean isOperator(char character) {
            int index = 0;
            while (index < this.JAVA_OPERATORS.length) {
                if (this.JAVA_OPERATORS[index] == character) {
                    return true;
                }
                ++index;
            }
            return false;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int character = scanner.read();
            if (this.isOperator((char)character)) {
                while (this.isOperator((char)(character = scanner.read()))) {
                }
                scanner.unread();
                return this.fToken;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
    }

    protected class MethodNameMatcher
    extends CombinedWordRule.WordMatcher {
        private final IToken fToken;

        public MethodNameMatcher(IToken token) {
            this.fToken = token;
        }

        public IToken evaluate(ICharacterScanner scanner, CombinedWordRule.CharacterBuffer word) {
            int count = 1;
            IToken token = Token.UNDEFINED;
            int character = scanner.read();
            while (Character.isWhitespace((char)character)) {
                character = scanner.read();
                ++count;
            }
            if (character == 40) {
                boolean isKeyword = false;
                int index = 0;
                while (index < fgKeywords.length) {
                    if (word.equals(fgKeywords[index])) {
                        isKeyword = true;
                        break;
                    }
                    ++index;
                }
                if (!isKeyword) {
                    scanner.unread();
                    return this.fToken;
                }
            }
            int index = 0;
            while (index < count) {
                scanner.unread();
                ++index;
            }
            return token;
        }
    }

    private static class VersionedWordMatcher
    extends CombinedWordRule.WordMatcher {
        private final IToken fDefaultToken;
        private final String fVersion;
        private final boolean fEnable;
        private String fCurrentVersion;

        public VersionedWordMatcher(IToken defaultToken, String version, boolean enable, String currentVersion) {
            this.fDefaultToken = defaultToken;
            this.fVersion = version;
            this.fEnable = enable;
            this.fCurrentVersion = currentVersion;
        }

        public void setCurrentVersion(String version) {
            this.fCurrentVersion = version;
        }

        public IToken evaluate(ICharacterScanner scanner, CombinedWordRule.CharacterBuffer word) {
            IToken token = super.evaluate(scanner, word);
            if (this.fEnable) {
                if (this.fCurrentVersion.equals(this.fVersion) || token.isUndefined()) {
                    return token;
                }
                return this.fDefaultToken;
            }
            if (this.fCurrentVersion.equals(this.fVersion)) {
                return Token.UNDEFINED;
            }
            return token;
        }
    }
}

