/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaHoverMessages;
import org.eclipse.jdt.ui.text.java.hover.IJavaEditorTextHover;
import org.eclipse.jface.text.Assert;

public class JavaEditorTextHoverDescriptor
implements Comparable {
    private static final String JAVA_EDITOR_TEXT_HOVER_EXTENSION_POINT = "org.eclipse.jdt.ui.javaEditorTextHovers";
    private static final String HOVER_TAG = "hover";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String LABEL_ATTRIBUTE = "label";
    private static final String ACTIVATE_PLUG_IN_ATTRIBUTE = "activate";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    public static final String NO_MODIFIER = "0";
    public static final String DISABLED_TAG = "!";
    public static final String VALUE_SEPARATOR = ";";
    private int fStateMask;
    private String fModifierString;
    private boolean fIsEnabled;
    private IConfigurationElement fElement;

    public static JavaEditorTextHoverDescriptor[] getContributedHovers() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(JAVA_EDITOR_TEXT_HOVER_EXTENSION_POINT);
        JavaEditorTextHoverDescriptor[] hoverDescs = JavaEditorTextHoverDescriptor.createDescriptors(elements);
        JavaEditorTextHoverDescriptor.initializeFromPreferences(hoverDescs);
        return hoverDescs;
    }

    public static int computeStateMask(String modifiers) {
        if (modifiers == null) {
            return -1;
        }
        if (modifiers.length() == 0) {
            return 0;
        }
        int stateMask = 0;
        StringTokenizer modifierTokenizer = new StringTokenizer(modifiers, ",;.:+-* ");
        while (modifierTokenizer.hasMoreTokens()) {
            int modifier = EditorUtility.findLocalizedModifier(modifierTokenizer.nextToken());
            if (modifier == 0 || (stateMask & modifier) == modifier) {
                return -1;
            }
            stateMask |= modifier;
        }
        return stateMask;
    }

    private JavaEditorTextHoverDescriptor(IConfigurationElement element) {
        Assert.isNotNull((Object)element);
        this.fElement = element;
    }

    public IJavaEditorTextHover createTextHover() {
        boolean isHoversPlugInActivated;
        String pluginId = this.fElement.getDeclaringExtension().getNamespace();
        boolean bl = isHoversPlugInActivated = Platform.getBundle((String)pluginId).getState() == 32;
        if (isHoversPlugInActivated || this.canActivatePlugIn()) {
            try {
                return (IJavaEditorTextHover)this.fElement.createExecutableExtension(CLASS_ATTRIBUTE);
            }
            catch (CoreException coreException) {
                JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, JavaHoverMessages.getString("JavaTextHover.createTextHover"), null));
            }
        }
        return null;
    }

    public String getId() {
        return this.fElement.getAttribute(ID_ATTRIBUTE);
    }

    public String getHoverClassName() {
        return this.fElement.getAttribute(CLASS_ATTRIBUTE);
    }

    public String getLabel() {
        String label = this.fElement.getAttribute(LABEL_ATTRIBUTE);
        if (label != null) {
            return label;
        }
        label = this.getHoverClassName();
        int lastDot = label.lastIndexOf(46);
        if (lastDot >= 0 && lastDot < label.length() - 1) {
            return label.substring(lastDot + 1);
        }
        return label;
    }

    public String getDescription() {
        return this.fElement.getAttribute(DESCRIPTION_ATTRIBUTE);
    }

    public boolean canActivatePlugIn() {
        return Boolean.valueOf(this.fElement.getAttribute(ACTIVATE_PLUG_IN_ATTRIBUTE));
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass()) || this.getId() == null) {
            return false;
        }
        return this.getId().equals(((JavaEditorTextHoverDescriptor)obj).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public int compareTo(Object o) {
        return Collator.getInstance().compare(this.getLabel(), ((JavaEditorTextHoverDescriptor)o).getLabel());
    }

    private static JavaEditorTextHoverDescriptor[] createDescriptors(IConfigurationElement[] elements) {
        ArrayList<JavaEditorTextHoverDescriptor> result = new ArrayList<JavaEditorTextHoverDescriptor>(elements.length);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (HOVER_TAG.equals(element.getName())) {
                JavaEditorTextHoverDescriptor desc = new JavaEditorTextHoverDescriptor(element);
                result.add(desc);
            }
            ++i;
        }
        Collections.sort(result);
        return result.toArray(new JavaEditorTextHoverDescriptor[result.size()]);
    }

    private static void initializeFromPreferences(JavaEditorTextHoverDescriptor[] hovers) {
        String compiledTextHoverModifiers = JavaPlugin.getDefault().getPreferenceStore().getString("hoverModifiers");
        StringTokenizer tokenizer = new StringTokenizer(compiledTextHoverModifiers, VALUE_SEPARATOR);
        HashMap<String, String> idToModifier = new HashMap<String, String>(tokenizer.countTokens() / 2);
        while (tokenizer.hasMoreTokens()) {
            String id = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) continue;
            idToModifier.put(id, tokenizer.nextToken());
        }
        String compiledTextHoverModifierMasks = JavaPlugin.getDefault().getPreferenceStore().getString("hoverModifierMasks");
        tokenizer = new StringTokenizer(compiledTextHoverModifierMasks, VALUE_SEPARATOR);
        HashMap<String, String> idToModifierMask = new HashMap<String, String>(tokenizer.countTokens() / 2);
        while (tokenizer.hasMoreTokens()) {
            String id = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) continue;
            idToModifierMask.put(id, tokenizer.nextToken());
        }
        int i = 0;
        while (i < hovers.length) {
            String modifierString = (String)idToModifier.get(hovers[i].getId());
            boolean enabled = true;
            if (modifierString == null) {
                modifierString = DISABLED_TAG;
            }
            if (modifierString.startsWith(DISABLED_TAG)) {
                enabled = false;
                modifierString = modifierString.substring(1);
            }
            if (modifierString.equals(NO_MODIFIER)) {
                modifierString = "";
            }
            hovers[i].fModifierString = modifierString;
            hovers[i].fIsEnabled = enabled;
            hovers[i].fStateMask = JavaEditorTextHoverDescriptor.computeStateMask(modifierString);
            if (hovers[i].fStateMask == -1) {
                try {
                    hovers[i].fStateMask = Integer.parseInt((String)idToModifierMask.get(hovers[i].getId()));
                }
                catch (NumberFormatException numberFormatException) {
                    hovers[i].fStateMask = -1;
                }
                int stateMask = hovers[i].fStateMask;
                hovers[i].fModifierString = stateMask == -1 ? "" : EditorUtility.getModifierString(stateMask);
            }
            ++i;
        }
    }

    public int getStateMask() {
        return this.fStateMask;
    }

    public String getModifierString() {
        return this.fModifierString;
    }

    public boolean isEnabled() {
        return this.fIsEnabled;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.fElement;
    }
}

