/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling;

import java.text.BreakIterator;
import java.util.LinkedList;
import java.util.Locale;
import org.eclipse.jdt.internal.ui.text.javadoc.IHtmlTagConstants;
import org.eclipse.jdt.internal.ui.text.javadoc.IJavaDocTagConstants;
import org.eclipse.jdt.internal.ui.text.spelling.engine.DefaultSpellChecker;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellCheckIterator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;

public class SpellCheckIterator
implements ISpellCheckIterator,
IJavaDocTagConstants,
IHtmlTagConstants {
    private final String fContent;
    private final String fDelimiter;
    private String fLastToken = null;
    private int fNext = 1;
    private final int fOffset;
    private int fPredecessor;
    private int fPrevious = 0;
    private final LinkedList fSentenceBreaks = new LinkedList();
    private boolean fStartsSentence = false;
    private int fSuccessor;
    private final BreakIterator fWordIterator;

    public SpellCheckIterator(IDocument document, IRegion region, Locale locale) {
        String content;
        this.fOffset = region.getOffset();
        this.fWordIterator = BreakIterator.getWordInstance(locale);
        this.fDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        try {
            content = document.get(region.getOffset(), region.getLength());
            if (content.startsWith("//$NON-NLS-")) {
                content = "";
            }
        }
        catch (Exception exception) {
            content = "";
        }
        this.fContent = content;
        this.fWordIterator.setText(content);
        this.fPredecessor = this.fWordIterator.first();
        this.fSuccessor = this.fWordIterator.next();
        BreakIterator iterator = BreakIterator.getSentenceInstance(locale);
        iterator.setText(content);
        int offset = iterator.current();
        while (offset != -1) {
            this.fSentenceBreaks.add(new Integer(offset));
            offset = iterator.next();
        }
    }

    public final int getBegin() {
        return this.fPrevious + this.fOffset;
    }

    public final int getEnd() {
        return this.fNext + this.fOffset - 1;
    }

    public final boolean hasNext() {
        return this.fSuccessor != -1;
    }

    protected final boolean isAlphaNumeric(int begin, int end) {
        char character = '\u0000';
        boolean letter = false;
        int index = begin;
        while (index < end) {
            character = this.fContent.charAt(index);
            if (Character.isLetter(character)) {
                letter = true;
            }
            if (!Character.isLetterOrDigit(character)) {
                return false;
            }
            ++index;
        }
        return letter;
    }

    protected final boolean isJavadocToken(String[] tags) {
        if (this.fLastToken != null) {
            int index = 0;
            while (index < tags.length) {
                if (this.fLastToken.equals(tags[index])) {
                    return true;
                }
                ++index;
            }
        }
        return false;
    }

    protected final boolean isSingleLetter(int begin) {
        if (begin > 0 && begin < this.fContent.length() - 1) {
            return Character.isWhitespace(this.fContent.charAt(begin - 1)) && Character.isLetter(this.fContent.charAt(begin)) && Character.isWhitespace(this.fContent.charAt(begin + 1));
        }
        return false;
    }

    protected final boolean isUrlToken(int begin) {
        int index = 0;
        while (index < DefaultSpellChecker.URL_PREFIXES.length) {
            if (this.fContent.startsWith(DefaultSpellChecker.URL_PREFIXES[index], begin)) {
                return true;
            }
            ++index;
        }
        return false;
    }

    protected final boolean isWhitespace(int begin, int end) {
        int index = begin;
        while (index < end) {
            if (!Character.isWhitespace(this.fContent.charAt(index))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public final Object next() {
        String token = this.nextToken();
        while (token == null && this.fSuccessor != -1) {
            token = this.nextToken();
        }
        this.fLastToken = token;
        return token;
    }

    protected final void nextBreak() {
        this.fNext = this.fSuccessor;
        this.fPredecessor = this.fSuccessor;
        this.fSuccessor = this.fWordIterator.next();
    }

    protected final int nextSentence() {
        return (Integer)this.fSentenceBreaks.getFirst();
    }

    protected String nextToken() {
        String token = null;
        this.fPrevious = this.fPredecessor;
        this.fStartsSentence = false;
        this.nextBreak();
        boolean update = false;
        if (this.fNext - this.fPrevious > 0) {
            if (this.fSuccessor != -1 && this.fContent.charAt(this.fPrevious) == '@') {
                this.nextBreak();
                if (Character.isLetter(this.fContent.charAt(this.fPrevious + 1))) {
                    update = true;
                    token = this.fContent.substring(this.fPrevious, this.fNext);
                } else {
                    this.fPredecessor = this.fNext;
                }
            } else if (this.fSuccessor != -1 && this.fContent.charAt(this.fPrevious) == '<' && (Character.isLetter(this.fContent.charAt(this.fNext)) || this.fContent.charAt(this.fNext) == '/')) {
                if (this.fContent.startsWith("</", this.fPrevious)) {
                    this.nextBreak();
                }
                this.nextBreak();
                if (this.fSuccessor != -1 && this.fContent.charAt(this.fNext) == '>') {
                    this.nextBreak();
                    if (this.fSuccessor != -1) {
                        update = true;
                        token = this.fContent.substring(this.fPrevious, this.fNext);
                    }
                }
            } else if (!this.isWhitespace(this.fPrevious, this.fNext) && this.isAlphaNumeric(this.fPrevious, this.fNext)) {
                if (this.isUrlToken(this.fPrevious)) {
                    this.skipTokens(this.fPrevious, ' ');
                } else if (this.isJavadocToken(IJavaDocTagConstants.JAVADOC_PARAM_TAGS)) {
                    this.fLastToken = null;
                } else if (this.isJavadocToken(IJavaDocTagConstants.JAVADOC_REFERENCE_TAGS)) {
                    this.fLastToken = null;
                    this.skipTokens(this.fPrevious, this.fDelimiter.charAt(0));
                } else if (this.fNext - this.fPrevious > 1 || this.isSingleLetter(this.fPrevious)) {
                    token = this.fContent.substring(this.fPrevious, this.fNext);
                }
                update = true;
            }
        }
        if (update && this.fSentenceBreaks.size() > 0 && this.fPrevious >= this.nextSentence()) {
            while (this.fSentenceBreaks.size() > 0 && this.fPrevious >= this.nextSentence()) {
                this.fSentenceBreaks.removeFirst();
            }
            this.fStartsSentence = this.fLastToken == null || token != null;
        }
        return token;
    }

    public final void remove() {
        throw new UnsupportedOperationException();
    }

    protected final void skipTokens(int begin, char stop) {
        int end = begin;
        while (end < this.fContent.length() && this.fContent.charAt(end) != stop) {
            ++end;
        }
        if (end < this.fContent.length()) {
            this.fPredecessor = this.fNext = end;
            this.fSuccessor = this.fWordIterator.following(this.fNext);
        } else {
            this.fSuccessor = -1;
        }
    }

    public final boolean startsSentence() {
        return this.fStartsSentence;
    }
}

