/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.BreakIterator;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelpResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocAccess;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocCommentReader;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.text.HTML2TextReader;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.help.WorkbenchHelp;

public class JavadocHelpContext
implements IContext {
    private IHelpResource[] fHelpResources;
    private String fText;

    public static void displayHelp(String contextId, Object[] selected) throws CoreException {
        IContext context = HelpSystem.getContext((String)contextId);
        if (context != null) {
            if (selected != null && selected.length > 0) {
                context = new JavadocHelpContext(context, selected);
            }
            WorkbenchHelp.displayHelp((IContext)context);
        }
    }

    public JavadocHelpContext(IContext context, Object[] elements) throws CoreException {
        IHelpResource[] resources;
        Assert.isNotNull(elements);
        ArrayList<IHelpResource> helpResources = new ArrayList<IHelpResource>();
        if (context != null && (resources = context.getRelatedTopics()) != null) {
            int j = 0;
            while (j < resources.length) {
                helpResources.add(resources[j]);
                ++j;
            }
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IJavaElement) {
                IPackageFragmentRoot root;
                Object element = (IJavaElement)elements[i];
                this.fText = this.fText == null ? this.retrieveText((IJavaElement)element) : "";
                URL url = JavaUI.getJavadocLocation(element, true);
                if ((url == null || this.doesNotExist(url)) && (root = JavaModelUtil.getPackageFragmentRoot(element)) != null) {
                    url = JavaUI.getJavadocBaseLocation(element);
                    element = root.getKind() == 1 ? element.getJavaProject() : root;
                    url = JavaUI.getJavadocLocation(element, false);
                }
                if (url != null) {
                    JavaUIHelpResource javaResource = new JavaUIHelpResource((IJavaElement)element, String.valueOf(url.toExternalForm()) + "?noframes=true");
                    helpResources.add(javaResource);
                }
            }
            ++i;
        }
        this.fHelpResources = helpResources.toArray(new IHelpResource[helpResources.size()]);
        if ((this.fText == null || this.fText.length() == 0) && context != null) {
            this.fText = context.getText();
        }
        if (this.fText != null && this.fText.length() == 0) {
            this.fText = null;
        }
    }

    private boolean doesNotExist(URL url) {
        if (url.getProtocol().equals("file")) {
            File file = new File(url.getFile());
            return !file.exists();
        }
        return false;
    }

    private String retrieveText(IJavaElement elem) throws JavaModelException {
        if (elem instanceof IMember) {
            try {
                JavaDocCommentReader reader = JavaDocAccess.getJavaDoc((IMember)elem, true);
                if (reader != null) {
                    HTML2TextReader htmlReader = new HTML2TextReader(reader, null);
                    String str = htmlReader.getString();
                    BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                    breakIterator.setText(str);
                    return str.substring(0, breakIterator.next());
                }
            }
            catch (IOException e) {
                JavaPlugin.log(e);
            }
        }
        return "";
    }

    public IHelpResource[] getRelatedTopics() {
        return this.fHelpResources;
    }

    public String getText() {
        return this.fText;
    }

    private static class JavaUIHelpResource
    implements IHelpResource {
        private IJavaElement fElement;
        private String fUrl;

        public JavaUIHelpResource(IJavaElement element, String url) {
            this.fElement = element;
            this.fUrl = url;
        }

        public String getHref() {
            return this.fUrl;
        }

        public String getLabel() {
            String label = JavaElementLabels.getTextLabel(this.fElement, 1);
            return JavaUIMessages.getFormattedString("JavaUIHelp.link.label", label);
        }
    }
}

