/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.ui.JavaUI;

public class CPUserLibraryElement {
    private String fName;
    private List fChildren;
    private boolean fIsSystemLibrary;

    public CPUserLibraryElement(String name, IClasspathContainer container) {
        this.fName = name;
        this.fChildren = new ArrayList();
        if (container != null) {
            IClasspathEntry[] entries = container.getClasspathEntries();
            CPListElement[] res = new CPListElement[entries.length];
            int i = 0;
            while (i < res.length) {
                IClasspathEntry curr = entries[i];
                CPListElement elem = new CPListElement(this, null, 1, curr.getPath(), null);
                elem.setAttribute("sourcepath", curr.getSourceAttachmentPath());
                elem.setAttribute("javadoc", JavaUI.getLibraryJavadocLocation(curr.getPath()));
                this.fChildren.add(elem);
                ++i;
            }
            this.fIsSystemLibrary = container.getKind() == 2;
        } else {
            this.fIsSystemLibrary = false;
        }
    }

    public CPUserLibraryElement(String name, boolean isSystemLibrary, CPListElement[] children) {
        this.fName = name;
        this.fChildren = new ArrayList();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                this.fChildren.add(children[i]);
                ++i;
            }
        }
        this.fIsSystemLibrary = isSystemLibrary;
    }

    public CPListElement[] getChildren() {
        return this.fChildren.toArray(new CPListElement[this.fChildren.size()]);
    }

    public String getName() {
        return this.fName;
    }

    public IPath getPath() {
        return new Path("org.eclipse.jdt.USER_LIBRARY").append(this.fName);
    }

    public boolean isSystemLibrary() {
        return this.fIsSystemLibrary;
    }

    public void add(CPListElement element) {
        if (!this.fChildren.contains(element)) {
            this.fChildren.add(element);
        }
    }

    public void remove(CPListElement element) {
        this.fChildren.remove(element);
    }

    public void replace(CPListElement existingElement, CPListElement element) {
        if (this.fChildren.contains(element)) {
            this.fChildren.remove(existingElement);
        } else {
            int index = this.fChildren.indexOf(existingElement);
            if (index != -1) {
                this.fChildren.set(index, element);
            } else {
                this.fChildren.add(element);
            }
        }
    }

    public void collectJavaDocLocations(ArrayList paths, ArrayList urls) {
        int i = 0;
        while (i < this.fChildren.size()) {
            CPListElement curr = (CPListElement)this.fChildren.get(i);
            curr.collectJavaDocLocations(paths, urls);
            ++i;
        }
    }

    public IClasspathContainer getUpdatedContainer() {
        return new UpdatedClasspathContainer();
    }

    public boolean hasChanges(IClasspathContainer oldContainer) {
        if (oldContainer == null || oldContainer.getKind() == 2 && !this.fIsSystemLibrary) {
            return true;
        }
        IClasspathEntry[] oldEntries = oldContainer.getClasspathEntries();
        if (this.fChildren.size() != oldEntries.length) {
            return true;
        }
        int i = 0;
        while (i < oldEntries.length) {
            CPListElement child = (CPListElement)this.fChildren.get(i);
            if (!child.getClasspathEntry().equals(oldEntries[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private class UpdatedClasspathContainer
    implements IClasspathContainer {
        UpdatedClasspathContainer() {
        }

        public IClasspathEntry[] getClasspathEntries() {
            CPListElement[] children = CPUserLibraryElement.this.getChildren();
            IClasspathEntry[] entries = new IClasspathEntry[children.length];
            int i = 0;
            while (i < entries.length) {
                entries[i] = children[i].getClasspathEntry();
                ++i;
            }
            return entries;
        }

        public String getDescription() {
            return CPUserLibraryElement.this.getName();
        }

        public int getKind() {
            return CPUserLibraryElement.this.isSystemLibrary() ? 2 : 1;
        }

        public IPath getPath() {
            return CPUserLibraryElement.this.getPath();
        }
    }
}

