/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.structure.ExtractInterfaceRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.ExtractInterfaceWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringActions;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class ExtractInterfaceAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;

    public ExtractInterfaceAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public ExtractInterfaceAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.getString("ExtractInterfaceAction.Extract_Interface"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.extract_interface_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(ExtractInterfaceAction.canEnable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection selection) {
        try {
            if (ExtractInterfaceAction.canEnable(selection)) {
                this.startRefactoring(ExtractInterfaceAction.getSingleSelectedType(selection));
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("OpenRefactoringWizardAction.exception"));
        }
    }

    private static boolean canEnable(IStructuredSelection selection) throws JavaModelException {
        return ExtractInterfaceAction.canRunOn(ExtractInterfaceAction.getSingleSelectedType(selection));
    }

    private static IType getSingleSelectedType(IStructuredSelection selection) throws JavaModelException {
        if (selection.isEmpty() || selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (first instanceof IType) {
            return (IType)first;
        }
        if (first instanceof ICompilationUnit) {
            return JavaElementUtil.getMainType((ICompilationUnit)first);
        }
        return null;
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    private boolean canEnable(JavaTextSelection selection) throws JavaModelException {
        IType type = RefactoringActions.getEnclosingOrPrimaryType(selection);
        return ExtractInterfaceRefactoring.isAvailable(type);
    }

    public void run(ITextSelection selection) {
        try {
            if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
                return;
            }
            IType type = this.getSingleSelectedType();
            if (ExtractInterfaceAction.canRunOn(type)) {
                this.startRefactoring(type);
            } else {
                String unavailable = RefactoringMessages.getString("ExtractInterfaceAction.To_activate");
                MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.getString("OpenRefactoringWizardAction.unavailable"), (String)unavailable);
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("OpenRefactoringWizardAction.exception"));
        }
    }

    private IType getSingleSelectedType() throws JavaModelException {
        return RefactoringActions.getEnclosingOrPrimaryType(this.fEditor);
    }

    private static boolean canRunOn(IType type) throws JavaModelException {
        return ExtractInterfaceRefactoring.isAvailable(type);
    }

    private static RefactoringWizard createWizard(ExtractInterfaceRefactoring refactoring) {
        return new ExtractInterfaceWizard(refactoring);
    }

    private void startRefactoring(IType type) throws JavaModelException {
        ExtractInterfaceRefactoring refactoring = ExtractInterfaceRefactoring.create(type, JavaPreferencesSettings.getCodeGenerationSettings());
        Assert.isNotNull((Object)refactoring);
        if (!ActionUtil.isProcessable(this.getShell(), refactoring.getInputType())) {
            return;
        }
        new RefactoringStarter().activate(refactoring, ExtractInterfaceAction.createWizard(refactoring), this.getShell(), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), true);
    }
}

