/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.search.FindOccurrencesEngine;
import org.eclipse.jdt.internal.ui.search.OccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class FindOccurrencesInFileAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;
    private IActionBars fActionBars;
    static /* synthetic */ Class class$0;

    public FindOccurrencesInFileAction(IViewPart part) {
        this((IWorkbenchSite)part.getSite());
        this.fActionBars = part.getViewSite().getActionBars();
    }

    public FindOccurrencesInFileAction(Page page) {
        this((IWorkbenchSite)page.getSite());
        this.fActionBars = page.getSite().getActionBars();
    }

    public FindOccurrencesInFileAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(FindOccurrencesInFileAction.getEditorInput(editor) != null);
    }

    private FindOccurrencesInFileAction(IWorkbenchSite site) {
        super(site);
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.setEnabled(this.getMember((IStructuredSelection)selection) != null);
        }
        this.setText(SearchMessages.getString("Search.FindOccurrencesInFile.label"));
        this.setToolTipText(SearchMessages.getString("Search.FindOccurrencesInFile.tooltip"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.find_occurrences_in_file_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.getMember(selection) != null);
    }

    private IMember getMember(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object o = selection.getFirstElement();
        if (o instanceof IMember) {
            IMember member = (IMember)o;
            IClassFile file = member.getClassFile();
            if (file != null) {
                try {
                    if (file.getSourceRange() != null) {
                        return member;
                    }
                }
                catch (JavaModelException javaModelException) {
                    return null;
                }
            }
            return member;
        }
        return null;
    }

    public void run(IStructuredSelection selection) {
        IMember member = this.getMember(selection);
        if (!ActionUtil.isProcessable(this.getShell(), member)) {
            return;
        }
        FindOccurrencesEngine engine = FindOccurrencesEngine.create((IJavaElement)member, new OccurrencesFinder());
        try {
            ISourceRange range = member.getNameRange();
            String result = engine.run(range.getOffset(), range.getLength());
            if (result != null) {
                FindOccurrencesInFileAction.showMessage(this.getShell(), this.fActionBars, result);
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    private static void showMessage(Shell shell, IActionBars actionBars, String msg) {
        IStatusLineManager statusLine = actionBars.getStatusLineManager();
        if (statusLine != null) {
            statusLine.setMessage(msg);
        }
        shell.getDisplay().beep();
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public final void run(ITextSelection ts) {
        IJavaElement input = FindOccurrencesInFileAction.getEditorInput(this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), input)) {
            return;
        }
        FindOccurrencesEngine engine = FindOccurrencesEngine.create(input, new OccurrencesFinder());
        try {
            String result = engine.run(ts.getOffset(), ts.getLength());
            if (result != null) {
                FindOccurrencesInFileAction.showMessage(this.getShell(), this.fEditor, result);
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    private static IJavaElement getEditorInput(JavaEditor editor) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)input).getClassFile();
        }
        return JavaPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(input);
    }

    private static void showMessage(Shell shell, JavaEditor editor, String msg) {
        IEditorStatusLine statusLine;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((statusLine = (IEditorStatusLine)editor.getAdapter(clazz)) != null) {
            statusLine.setMessage(true, msg, null);
        }
        shell.getDisplay().beep();
    }
}

