/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.connection;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSStatus;

public class CVSServerException
extends CVSException {
    public boolean isNoTagException() {
        IStatus status = this.getStatus();
        if (!status.isMultiStatus()) {
            return false;
        }
        IStatus[] children = ((MultiStatus)status).getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].getCode() == -11) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsErrors() {
        IStatus status = this.getStatus();
        if (!status.isMultiStatus()) {
            return status.getSeverity() == 4;
        }
        IStatus[] children = ((MultiStatus)status).getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].getSeverity() == 4) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static CVSServerException forError(String message, IStatus[] children) {
        if (children.length > 0) {
            return new CVSServerException(message, children);
        }
        return new CVSServerException((IStatus)new CVSStatus(4, -10, message, null));
    }

    public CVSServerException(IStatus status) {
        super(status);
    }

    private CVSServerException(String message, IStatus[] children) {
        super((IStatus)new MultiStatus("org.eclipse.team.cvs.core", -10, children, message, null));
    }
}

