/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.team.internal.ccvs.core.util.Assert;
import org.eclipse.team.internal.ccvs.core.util.StringMatcher;

public class FileNameMatcher {
    private List matchers = new ArrayList();
    private List results = new ArrayList();
    private static final String TRUE = "true";

    public FileNameMatcher() {
    }

    public FileNameMatcher(String[] patterns) {
        this.register(patterns);
    }

    void register(String[] patterns) {
        int i = 0;
        while (i < patterns.length) {
            this.register(patterns[i], TRUE);
            ++i;
        }
    }

    public void register(String pattern, String result) {
        Assert.isTrue(this.matchers.size() == this.results.size());
        pattern = pattern.trim();
        if (pattern.length() == 0) {
            return;
        }
        this.matchers.add(new StringMatcher(pattern, false, false));
        this.results.add(result);
    }

    public String getMatch(String name) {
        int i = 0;
        while (i < this.matchers.size()) {
            StringMatcher stringMatcher = (StringMatcher)this.matchers.get(i);
            if (stringMatcher.match(name)) {
                return (String)this.results.get(i);
            }
            ++i;
        }
        return null;
    }

    public boolean match(String name) {
        return this.getMatch(name) != null;
    }
}

