/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class ExplicitConstructorCall
extends Statement
implements InvocationSite {
    public Expression[] arguments;
    public Expression qualification;
    public MethodBinding binding;
    public int accessMode;
    public static final int ImplicitSuper = 1;
    public static final int Super = 2;
    public static final int This = 3;
    public VariableBinding[][] implicitArguments;
    boolean discardEnclosingInstance;
    MethodBinding syntheticAccessor;

    public ExplicitConstructorCall(int accessMode) {
        this.accessMode = accessMode;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        try {
            ((MethodScope)currentScope).isConstructorCall = true;
            if (this.qualification != null) {
                flowInfo = this.qualification.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
            }
            if (this.arguments != null) {
                int i = 0;
                int max = this.arguments.length;
                while (i < max) {
                    flowInfo = this.arguments[i].analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
                    ++i;
                }
            }
            TypeBinding[] thrownExceptions = this.binding.thrownExceptions;
            if (this.binding.thrownExceptions != TypeConstants.NoExceptions) {
                flowContext.checkExceptionHandlers(thrownExceptions, this.accessMode == 1 ? (ASTNode)((Object)currentScope.methodScope().referenceContext) : this, flowInfo, currentScope);
            }
            this.manageEnclosingInstanceAccessIfNecessary(currentScope, flowInfo);
            this.manageSyntheticAccessIfNecessary(currentScope, flowInfo);
            FlowInfo flowInfo2 = flowInfo;
            Object var6_8 = null;
            ((MethodScope)currentScope).isConstructorCall = false;
            return flowInfo2;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            ((MethodScope)currentScope).isConstructorCall = false;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        try {
            int pc;
            block11: {
                int max;
                int i;
                ((MethodScope)currentScope).isConstructorCall = true;
                pc = codeStream.position;
                codeStream.aload_0();
                ReferenceBinding targetType = this.binding.declaringClass;
                if (targetType.isNestedType()) {
                    codeStream.generateSyntheticEnclosingInstanceValues(currentScope, targetType, this.discardEnclosingInstance ? null : this.qualification, this);
                }
                if (this.arguments != null) {
                    i = 0;
                    max = this.arguments.length;
                    while (i < max) {
                        this.arguments[i].generateCode(currentScope, codeStream, true);
                        ++i;
                    }
                }
                if (targetType.isNestedType()) {
                    codeStream.generateSyntheticOuterArgumentValues(currentScope, targetType, this);
                }
                if (this.syntheticAccessor != null) {
                    i = 0;
                    max = this.syntheticAccessor.parameters.length - this.binding.parameters.length;
                    while (true) {
                        if (i >= max) {
                            codeStream.invokespecial(this.syntheticAccessor);
                            break block11;
                        }
                        codeStream.aconst_null();
                        ++i;
                    }
                }
                codeStream.invokespecial(this.binding);
            }
            codeStream.recordPositionsFrom(pc, this.sourceStart);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            ((MethodScope)currentScope).isConstructorCall = false;
            throw throwable;
        }
        {
            Object var7_9 = null;
            ((MethodScope)currentScope).isConstructorCall = false;
            return;
        }
    }

    public boolean isImplicitSuper() {
        return this.accessMode == 1;
    }

    public boolean isSuperAccess() {
        return this.accessMode != 3;
    }

    public boolean isTypeAccess() {
        return true;
    }

    void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        ReferenceBinding superType = this.binding.declaringClass;
        if (superType.isNestedType() && currentScope.enclosingSourceType().isLocalType()) {
            if (superType.isLocalType()) {
                ((LocalTypeBinding)superType).addInnerEmulationDependent(currentScope, this.qualification != null);
            } else {
                currentScope.propagateInnerEmulation(superType, this.qualification != null);
            }
        }
    }

    public void manageSyntheticAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        if (this.binding.isPrivate() && this.accessMode != 3) {
            if (currentScope.environment().options.isPrivateConstructorAccessChangingVisibility) {
                this.binding.tagForClearingPrivateModifier();
            } else {
                this.syntheticAccessor = ((SourceTypeBinding)this.binding.declaringClass).addSyntheticMethod(this.binding, this.isSuperAccess());
                currentScope.problemReporter().needToEmulateMethodAccess(this.binding, this);
            }
        }
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        ASTNode.printIndent(indent, output);
        if (this.qualification != null) {
            this.qualification.printExpression(0, output).append('.');
        }
        if (this.accessMode == 3) {
            output.append("this(");
        } else {
            output.append("super(");
        }
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.arguments[i].printExpression(0, output);
                ++i;
            }
        }
        return output.append(");");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolve(BlockScope scope) {
        block24: {
            block23: {
                block22: {
                    MethodScope methodScope = scope.methodScope();
                    try {
                        int i;
                        AbstractMethodDeclaration methodDeclaration = methodScope.referenceMethod();
                        if (methodDeclaration == null || !methodDeclaration.isConstructor() || ((ConstructorDeclaration)methodDeclaration).constructorCall != this) {
                            scope.problemReporter().invalidExplicitConstructorCall(this);
                            Object var11_4 = null;
                            methodScope.isConstructorCall = false;
                            return;
                        }
                        methodScope.isConstructorCall = true;
                        ReferenceBinding receiverType = scope.enclosingSourceType();
                        if (this.accessMode != 3) {
                            receiverType = receiverType.superclass();
                        }
                        if (receiverType == null) {
                            break block22;
                        }
                        if (this.qualification != null) {
                            ReferenceBinding enclosingType;
                            if (this.accessMode != 2) {
                                scope.problemReporter().unnecessaryEnclosingInstanceSpecification(this.qualification, receiverType);
                            }
                            if ((enclosingType = receiverType.enclosingType()) == null) {
                                scope.problemReporter().unnecessaryEnclosingInstanceSpecification(this.qualification, receiverType);
                                this.discardEnclosingInstance = true;
                            } else {
                                TypeBinding qTb = this.qualification.resolveTypeExpecting(scope, enclosingType);
                                this.qualification.implicitWidening(qTb, qTb);
                            }
                        }
                        TypeBinding[] argumentTypes = TypeConstants.NoParameters;
                        boolean argsContainCast = false;
                        if (this.arguments != null) {
                            boolean argHasError = false;
                            int length = this.arguments.length;
                            argumentTypes = new TypeBinding[length];
                            i = 0;
                            while (true) {
                                if (i >= length) {
                                    if (!argHasError) break;
                                    break block23;
                                }
                                Expression argument = this.arguments[i];
                                if (argument instanceof CastExpression) {
                                    argument.bits |= 0x20;
                                    argsContainCast = true;
                                }
                                if ((argumentTypes[i] = argument.resolveType(scope)) == null) {
                                    argHasError = true;
                                }
                                ++i;
                            }
                        }
                        if ((this.binding = scope.getConstructor(receiverType, argumentTypes, this)).isValidBinding()) {
                            if (this.isMethodUseDeprecated(this.binding, scope)) {
                                scope.problemReporter().deprecatedMethod(this.binding, this);
                            }
                            if (this.arguments != null) {
                                int length = this.arguments.length;
                                TypeBinding[] paramTypes = this.binding.parameters;
                                i = 0;
                                while (true) {
                                    if (i >= length) {
                                        if (!argsContainCast) break;
                                        CastExpression.checkNeedForArgumentCasts(scope, null, receiverType, this.binding, this.arguments, argumentTypes, this);
                                        break;
                                    }
                                    this.arguments[i].implicitWidening(paramTypes[i], argumentTypes[i]);
                                    ++i;
                                }
                            }
                            if (this.binding.isPrivate()) {
                                this.binding.modifiers |= 0x8000000;
                            }
                            break block24;
                        }
                        if (this.binding.declaringClass == null) {
                            this.binding.declaringClass = receiverType;
                        }
                        scope.problemReporter().invalidConstructor(this, this.binding);
                        break block24;
                    }
                    catch (Throwable throwable) {
                        Object var11_7 = null;
                        methodScope.isConstructorCall = false;
                        throw throwable;
                    }
                }
                Object var11_5 = null;
                methodScope.isConstructorCall = false;
                return;
            }
            Object var11_6 = null;
            methodScope.isConstructorCall = false;
            return;
        }
        Object var11_8 = null;
        methodScope.isConstructorCall = false;
    }

    public void setActualReceiverType(ReferenceBinding receiverType) {
    }

    public void setDepth(int depth) {
    }

    public void setFieldIndex(int depth) {
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.qualification != null) {
                this.qualification.traverse(visitor, scope);
            }
            if (this.arguments != null) {
                int i = 0;
                int argumentLength = this.arguments.length;
                while (i < argumentLength) {
                    this.arguments[i].traverse(visitor, scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, scope);
    }
}

