/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;
import org.eclipse.search.internal.ui.Search;
import org.eclipse.search.internal.ui.SearchManager;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchResultView;
import org.eclipse.search.internal.ui.SearchResultViewEntry;
import org.eclipse.search.internal.ui.text.ReplaceDialog;
import org.eclipse.search.internal.ui.text.SearchAgainConfirmationDialog;
import org.eclipse.search.internal.ui.text.TextSearchOperation;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

class ReplaceAction
extends Action {
    private IWorkbenchSite fSite;
    private List fElements;

    public ReplaceAction(IWorkbenchSite site, List elements) {
        Assert.isNotNull((Object)site);
        this.fSite = site;
        this.fElements = elements != null ? elements : new ArrayList(0);
        this.setText(SearchMessages.getString("ReplaceAction.label_all"));
        this.setEnabled(!this.fElements.isEmpty());
    }

    public ReplaceAction(IWorkbenchSite site, IStructuredSelection selection) {
        Assert.isNotNull((Object)site);
        this.fSite = site;
        this.setText(SearchMessages.getString("ReplaceAction.label_selected"));
        this.fElements = selection.toList();
        this.setEnabled(!this.fElements.isEmpty());
    }

    public void run() {
        Search search = SearchManager.getDefault().getCurrentSearch();
        IRunnableWithProgress operation = search.getOperation();
        if (operation instanceof TextSearchOperation) {
            if (this.validateResources((TextSearchOperation)operation)) {
                ReplaceDialog dialog = new ReplaceDialog(this.fSite.getShell(), this.fElements, (TextSearchOperation)operation);
                dialog.open();
            }
        } else {
            MessageDialog.openError((Shell)this.fSite.getShell(), (String)this.getDialogTitle(), (String)SearchMessages.getString("ReplaceAction.error.only_on_text_search"));
        }
    }

    private boolean validateResources(final TextSearchOperation operation) {
        final ArrayList<SearchResultViewEntry> outOfDateEntries = new ArrayList<SearchResultViewEntry>();
        Iterator elements = this.fElements.iterator();
        while (elements.hasNext()) {
            SearchResultViewEntry entry = (SearchResultViewEntry)elements.next();
            if (!this.isOutOfDate(entry)) continue;
            outOfDateEntries.add(entry);
        }
        ArrayList<SearchResultViewEntry> outOfSyncEntries = new ArrayList<SearchResultViewEntry>();
        Iterator elements2 = this.fElements.iterator();
        while (elements2.hasNext()) {
            SearchResultViewEntry entry = (SearchResultViewEntry)elements2.next();
            if (!this.isOutOfSync(entry)) continue;
            outOfSyncEntries.add(entry);
        }
        if (outOfDateEntries.size() > 0 || outOfSyncEntries.size() > 0) {
            if (this.askForResearch(outOfDateEntries, outOfSyncEntries)) {
                ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.fSite.getShell());
                try {
                    pmd.run(true, true, (IRunnableWithProgress)new WorkspaceModifyOperation(null){

                        protected void execute(IProgressMonitor monitor) throws CoreException {
                            ReplaceAction.this.research(monitor, outOfDateEntries, operation);
                        }
                    });
                    return true;
                }
                catch (InvocationTargetException e) {
                    ExceptionHandler.handle(e, this.fSite.getShell(), SearchMessages.getString("ReplaceAction.label"), SearchMessages.getString("ReplaceAction.research.error"));
                }
                catch (InterruptedException interruptedException) {}
            }
            return false;
        }
        return true;
    }

    private void research(IProgressMonitor monitor, List outOfDateEntries, TextSearchOperation operation) throws CoreException {
        IStatus status = null;
        Iterator elements = outOfDateEntries.iterator();
        while (elements.hasNext()) {
            SearchResultViewEntry entry = (SearchResultViewEntry)elements.next();
            status = this.research(operation, monitor, entry);
            if (status == null || status.isOK()) continue;
            throw new CoreException(status);
        }
    }

    private boolean askForResearch(List outOfDateEntries, List outOfSyncEntries) {
        SearchAgainConfirmationDialog dialog;
        SearchResultView view = (SearchResultView)SearchPlugin.getSearchResultView();
        ILabelProvider labelProvider = null;
        if (view != null) {
            labelProvider = view.getLabelProvider();
        }
        return (dialog = new SearchAgainConfirmationDialog(this.fSite.getShell(), labelProvider, outOfSyncEntries, outOfDateEntries)).open() == 0;
    }

    private String getDialogTitle() {
        return SearchMessages.getString("ReplaceAction.dialog.title");
    }

    private boolean isOutOfDate(SearchResultViewEntry entry) {
        IResource resource = entry.getResource();
        if (entry.getModificationStamp() != resource.getModificationStamp()) {
            return true;
        }
        ITextFileBufferManager bm = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer fb = bm.getTextFileBuffer(resource.getFullPath());
        return fb != null && fb.isDirty();
    }

    private boolean isOutOfSync(SearchResultViewEntry entry) {
        return !entry.getResource().isSynchronized(0);
    }

    private IStatus research(TextSearchOperation operation, final IProgressMonitor monitor, SearchResultViewEntry entry) throws CoreException {
        ArrayList markers = new ArrayList();
        markers.addAll(entry.getMarkers());
        operation.searchInFile((IFile)entry.getResource(), new ITextSearchResultCollector(){

            public IProgressMonitor getProgressMonitor() {
                return monitor;
            }

            public void aboutToStart() {
            }

            public void accept(IResourceProxy proxy, String line, int start, int length, int lineNumber) throws CoreException {
                IFile file = (IFile)proxy.requestResource();
                if (start < 0 || length < 1) {
                    return;
                }
                IMarker marker = file.createMarker("org.eclipse.search.searchmarker");
                HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                attributes.put("line", line);
                attributes.put("charStart", new Integer(start));
                attributes.put("charEnd", new Integer(start + length));
                attributes.put("lineNumber", new Integer(lineNumber));
                marker.setAttributes(attributes);
            }

            public void done() {
            }
        });
        IStatus status = operation.getStatus();
        if (status == null || status.isOK()) {
            Iterator markerIter = markers.iterator();
            while (markerIter.hasNext()) {
                IMarker marker = (IMarker)markerIter.next();
                marker.delete();
            }
        }
        return status;
    }
}

