/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.rules;

import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.Token;

public class WhitespaceRule
implements IRule {
    protected IWhitespaceDetector fDetector;

    public WhitespaceRule(IWhitespaceDetector detector) {
        Assert.isNotNull((Object)detector);
        this.fDetector = detector;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        if (this.fDetector.isWhitespace((char)c)) {
            while (this.fDetector.isWhitespace((char)(c = scanner.read()))) {
            }
            scanner.unread();
            return Token.WHITESPACE;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }
}

