/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.internal.ui.actions.AbstractDebugActionDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class AbstractListenerActionDelegate
extends AbstractDebugActionDelegate
implements IDebugEventSetListener,
IActionDelegate2 {
    public void dispose() {
        super.dispose();
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    public void handleDebugEvents(final DebugEvent[] events) {
        if (this.getWindow() == null || this.getAction() == null) {
            return;
        }
        Shell shell = this.getWindow().getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                Shell windowShell = AbstractListenerActionDelegate.this.getWindow().getShell();
                if (windowShell == null || windowShell.isDisposed()) {
                    return;
                }
                int i = 0;
                while (i < events.length) {
                    if (events[i].getSource() != null) {
                        AbstractListenerActionDelegate.this.doHandleDebugEvent(events[i]);
                    }
                    ++i;
                }
            }
        };
        shell.getDisplay().asyncExec(r);
    }

    protected void doHandleDebugEvent(DebugEvent event) {
        switch (event.getKind()) {
            case 8: {
                this.update(this.getAction(), (ISelection)this.getSelection());
                break;
            }
            case 1: {
                if (event.isEvaluation() && (event.getDetail() & 0x80) != 0) break;
                this.update(this.getAction(), (ISelection)this.getSelection());
                break;
            }
            case 2: {
                this.update(this.getAction(), (ISelection)this.getSelection());
            }
        }
    }

    public void init(IWorkbenchWindow window) {
        super.init(window);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void init(IViewPart view) {
        super.init(view);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.setWindow(view.getViewSite().getWorkbenchWindow());
    }

    public void init(IAction action) {
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }
}

