/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.actions.AbstractDebugActionDelegate;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;

public class CopyToClipboardActionDelegate
extends AbstractDebugActionDelegate {
    private TreeViewer fViewer;
    static /* synthetic */ Class class$0;

    protected boolean initialize(IAction action, ISelection selection) {
        if (!this.isInitialized()) {
            IDebugView adapter;
            IViewPart iViewPart = this.getView();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.ui.IDebugView");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IDebugView)iViewPart.getAdapter((Class)clazz)) != null) {
                if (adapter.getViewer() instanceof ContentViewer) {
                    this.setViewer((TreeViewer)adapter.getViewer());
                }
                adapter.setAction(this.getActionId(), action);
            }
            return super.initialize(action, selection);
        }
        return false;
    }

    protected String getActionId() {
        return IDebugView.COPY_ACTION;
    }

    protected boolean isEnabledFor(Object element) {
        return this.getViewer() != null && element instanceof IDebugElement;
    }

    protected void doAction(TreeItem item, StringBuffer buffer) {
        this.append(item, buffer, 0);
    }

    protected void append(TreeItem item, StringBuffer buffer, int indent) {
        int i = 0;
        while (i < indent) {
            buffer.append('\t');
            ++i;
        }
        buffer.append(item.getText());
        buffer.append(System.getProperty("line.separator"));
        if (this.shouldAppendChildren(item)) {
            TreeItem[] children = item.getItems();
            int i2 = 0;
            while (i2 < children.length) {
                TreeItem child = children[i2];
                this.append(child, buffer, indent + 1);
                ++i2;
            }
        }
    }

    public void run(IAction action) {
        final Iterator iter = this.pruneSelection();
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                StringBuffer buffer = new StringBuffer();
                while (iter.hasNext()) {
                    CopyToClipboardActionDelegate.this.doAction((TreeItem)iter.next(), buffer);
                }
                TextTransfer plainTextTransfer = TextTransfer.getInstance();
                Clipboard clipboard = new Clipboard(CopyToClipboardActionDelegate.this.getViewer().getControl().getDisplay());
                try {
                    CopyToClipboardActionDelegate.this.doCopy(clipboard, plainTextTransfer, buffer);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    clipboard.dispose();
                    throw throwable;
                }
                clipboard.dispose();
            }
        });
    }

    protected void doCopy(Clipboard clipboard, TextTransfer plainTextTransfer, StringBuffer buffer) {
        block3: {
            try {
                clipboard.setContents((Object[])new String[]{buffer.toString()}, new Transfer[]{plainTextTransfer});
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.getViewer().getControl().getShell(), (String)ActionMessages.getString("CopyToClipboardActionDelegate.Problem_Copying_to_Clipboard_1"), (String)ActionMessages.getString("CopyToClipboardActionDelegate.There_was_a_problem_when_accessing_the_system_clipboard._Retry__2"))) break block3;
                this.doCopy(clipboard, plainTextTransfer, buffer);
            }
        }
    }

    protected Iterator pruneSelection() {
        TreeItem[] selection = this.getViewer().getTree().getSelection();
        ArrayList<TreeItem> items = new ArrayList<TreeItem>(selection.length);
        int i = 0;
        while (i < selection.length) {
            TreeItem item = selection[i];
            if (this.isEnabledFor(item.getData()) && this.walkHierarchy(item, items)) {
                items.add(item);
            }
            ++i;
        }
        return items.iterator();
    }

    protected boolean walkHierarchy(TreeItem item, List elements) {
        TreeItem parent = item.getParentItem();
        if (parent == null) {
            return true;
        }
        if (elements.contains(parent)) {
            return false;
        }
        return this.walkHierarchy(parent, elements);
    }

    protected boolean shouldAppendChildren(TreeItem item) {
        Object data = item.getData();
        return data instanceof IDebugTarget || data instanceof IThread;
    }

    protected TreeViewer getViewer() {
        return this.fViewer;
    }

    protected void setViewer(TreeViewer viewer) {
        this.fViewer = viewer;
    }

    protected void doAction(Object element) {
    }
}

