/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.util.List;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class LaunchShortcutAction
extends Action {
    private String fMode;
    private LaunchShortcutExtension fShortcut;

    public LaunchShortcutAction(String mode, LaunchShortcutExtension shortcut) {
        super(shortcut.getLabel(), shortcut.getImageDescriptor());
        this.fMode = mode;
        this.fShortcut = shortcut;
        this.updateEnablement();
    }

    public void run() {
        IWorkbenchPage page;
        IWorkbenchWindow wb = DebugUIPlugin.getActiveWorkbenchWindow();
        if (wb != null && (page = wb.getActivePage()) != null) {
            ISelection selection = page.getSelection();
            if (selection instanceof IStructuredSelection) {
                this.fShortcut.launch(selection, this.fMode);
            } else {
                IEditorPart editor = page.getActiveEditor();
                if (editor != null) {
                    this.fShortcut.launch(editor, this.fMode);
                }
            }
        }
    }

    private void updateEnablement() {
        boolean enabled;
        block7: {
            IWorkbenchPage page;
            IWorkbenchWindow wb = DebugUIPlugin.getActiveWorkbenchWindow();
            enabled = false;
            if (wb != null && (page = wb.getActivePage()) != null) {
                ISelection selection = page.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    try {
                        Expression expression = this.fShortcut.getShortcutEnablementExpression();
                        if (expression == null) {
                            enabled = !structuredSelection.isEmpty();
                            break block7;
                        }
                        List list = structuredSelection.toList();
                        EvaluationContext context = new EvaluationContext(null, (Object)list);
                        context.addVariable("selection", (Object)list);
                        enabled = this.fShortcut.evalEnablementExpression((IEvaluationContext)context, expression);
                    }
                    catch (CoreException coreException) {}
                } else {
                    IEditorPart editor = page.getActiveEditor();
                    if (editor != null) {
                        enabled = true;
                    }
                }
            }
        }
        this.setEnabled(enabled);
    }
}

